/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.data;

import java.io.Serializable;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;
import org.infinispan.protostream.annotations.ProtoField;

public class Address
implements Serializable,
JsonSerialization {
    private static final long serialVersionUID = 5943073369866339615L;
    @ProtoField(value=1)
    String street = null;
    @ProtoField(value=2, defaultValue="San Jose")
    String city = "San Jose";
    @ProtoField(number=3, defaultValue="0")
    int zip = 0;

    public Address() {
    }

    public Address(String street, String city, int zip) {
        this.street = street;
        this.city = city;
        this.zip = zip;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public int getZip() {
        return this.zip;
    }

    public void setZip(int zip) {
        this.zip = zip;
    }

    public String toString() {
        return "street=" + this.getStreet() + ", city=" + this.getCity() + ", zip=" + this.getZip();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        if (this.zip != address.zip) {
            return false;
        }
        if (this.city != null ? !this.city.equals(address.city) : address.city != null) {
            return false;
        }
        return !(this.street != null ? !this.street.equals(address.street) : address.street != null);
    }

    public boolean equalsIgnoreStreetWhitespace(Address address) {
        if (this.zip != address.zip) {
            return false;
        }
        if (this.city != null ? !this.city.equals(address.city) : address.city != null) {
            return false;
        }
        return !(this.street != null ? !this.street.trim().equals(address.street.trim()) : address.street != null);
    }

    public int hashCode() {
        int result = this.street != null ? this.street.hashCode() : 0;
        result = 29 * result + (this.city != null ? this.city.hashCode() : 0);
        result = 29 * result + this.zip;
        return result;
    }

    public Json toJson() {
        return Json.object().set("street", (Object)this.street).set("city", (Object)this.city).set("zip", (Object)this.zip);
    }
}

