/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.fwk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.commons.util.LegacyKeySupportSystemProperties;
import org.infinispan.test.fwk.TransportFlags;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;

public class JGroupsConfigBuilder {
    public static final int BASE_TCP_PORT = 7900;
    public static final int MAX_NODES_PER_SITE = 50;
    private static final int MAX_SITES_PER_THREAD = 4;
    public static final int MAX_NODES_PER_THREAD = 200;
    public static final String JGROUPS_STACK;
    private static final Map<String, ProtocolStackConfigurator> protocolStackConfigurator;
    private static final ThreadLocal<Integer> threadTcpIndex;
    private static final ThreadLocal<Integer> threadUdpIndex;
    private static final ConcurrentMap<String, Integer> testUdpIndex;

    public static String getJGroupsConfig(String fullTestName, TransportFlags flags) {
        JGroupsProtocolCfg jgroupsCfg = JGroupsConfigBuilder.getJGroupsProtocolCfg(JGroupsConfigBuilder.getConfigurator().getProtocolStack());
        if (!flags.withFD()) {
            JGroupsConfigBuilder.removeFailureDetection(jgroupsCfg);
        }
        JGroupsConfigBuilder.removeFD_SOCK(jgroupsCfg);
        if (!flags.isRelayRequired()) {
            JGroupsConfigBuilder.removeRelay2(jgroupsCfg);
        } else {
            ProtocolConfiguration protocol = jgroupsCfg.getProtocol(ProtocolType.TEST_RELAY2);
            protocol.getProperties().put("site", flags.siteName());
            if (flags.relayConfig() != null) {
                protocol.getProperties().put("config", flags.relayConfig());
            }
        }
        if (!flags.withMerge()) {
            JGroupsConfigBuilder.removeMerge(jgroupsCfg);
        }
        JGroupsConfigBuilder.replacePing(jgroupsCfg);
        int siteIndex = flags.siteIndex();
        if (siteIndex > 4) {
            throw new IllegalStateException("Currently we only support 4 ranges/sites!");
        }
        JGroupsConfigBuilder.replaceTcpStartPort(jgroupsCfg, siteIndex);
        JGroupsConfigBuilder.replaceMCastAddressAndPort(jgroupsCfg, fullTestName, siteIndex);
        JGroupsConfigBuilder.configureGMSTimeout(jgroupsCfg, flags);
        return jgroupsCfg.toString();
    }

    public static ProtocolStackConfigurator getConfigurator() {
        ProtocolStackConfigurator stack = protocolStackConfigurator.get(JGROUPS_STACK);
        if (stack == null) {
            throw new IllegalStateException("Unknown protocol stack : " + JGROUPS_STACK);
        }
        return stack;
    }

    private static void replacePing(JGroupsProtocolCfg jgroupsCfg) {
        if (!jgroupsCfg.containsProtocol(ProtocolType.LOCAL_PING)) {
            ProtocolType[] pingProtocols = new ProtocolType[]{ProtocolType.MPING, ProtocolType.PING};
            ProtocolType pingProtocolToBeReplaced = null;
            for (ProtocolType protocol : pingProtocols) {
                if (!jgroupsCfg.containsProtocol(protocol)) continue;
                pingProtocolToBeReplaced = protocol;
                break;
            }
            if (pingProtocolToBeReplaced == null) {
                throw new IllegalStateException("Can't replace the ping protocol with LOCAL_PING");
            }
            jgroupsCfg.replaceProtocol(pingProtocolToBeReplaced, new ProtocolConfiguration(ProtocolType.LOCAL_PING.name(), new HashMap()));
        }
    }

    private static void removeMerge(JGroupsProtocolCfg jgroupsCfg) {
        jgroupsCfg.removeProtocol(ProtocolType.MERGE3);
    }

    private static void removeFailureDetection(JGroupsProtocolCfg jgroupsCfg) {
        jgroupsCfg.removeProtocol(ProtocolType.FD).removeProtocol(ProtocolType.FD_SOCK).removeProtocol(ProtocolType.FD_SOCK2).removeProtocol(ProtocolType.FD_ALL).removeProtocol(ProtocolType.FD_ALL2).removeProtocol(ProtocolType.FD_ALL3).removeProtocol(ProtocolType.VERIFY_SUSPECT).removeProtocol(ProtocolType.VERIFY_SUSPECT2);
    }

    private static void removeFD_SOCK(JGroupsProtocolCfg jgroupsCfg) {
        jgroupsCfg.removeProtocol(ProtocolType.FD_SOCK).removeProtocol(ProtocolType.FD_SOCK2);
    }

    private static void removeRelay2(JGroupsProtocolCfg jgroupsCfg) {
        jgroupsCfg.removeProtocol(ProtocolType.TEST_RELAY2);
    }

    private static void replaceMCastAddressAndPort(JGroupsProtocolCfg jgroupsCfg, String fullTestName, int siteIndex) {
        ProtocolConfiguration udp = jgroupsCfg.getProtocol(ProtocolType.UDP);
        if (udp == null) {
            return;
        }
        Integer udpIndex = testUdpIndex.computeIfAbsent(fullTestName, k -> threadUdpIndex.get());
        if (siteIndex < 0) {
            siteIndex = 0;
        }
        int clusterOffset = udpIndex * 4 + siteIndex;
        Map props = udp.getProperties();
        props.put("mcast_addr", "239.10.10." + clusterOffset);
        props.put("mcast_port", String.valueOf(46000 + clusterOffset));
        JGroupsConfigBuilder.replaceProperties(jgroupsCfg, props, ProtocolType.UDP);
    }

    private static void replaceTcpStartPort(JGroupsProtocolCfg jgroupsCfg, int siteIndex) {
        int portRange;
        int startPort;
        ProtocolType transportProtocol = jgroupsCfg.transportType;
        if (transportProtocol != ProtocolType.TCP && transportProtocol != ProtocolType.TCP_NIO2) {
            return;
        }
        Map props = jgroupsCfg.getProtocol(transportProtocol).getProperties();
        Integer threadIndex = threadTcpIndex.get();
        if (siteIndex >= 0) {
            startPort = 7900 + threadIndex * 200 + siteIndex * 50;
            portRange = 50;
        } else {
            startPort = 7900 + threadIndex * 200;
            portRange = 200;
        }
        props.put("bind_port", String.valueOf(startPort));
        props.put("port_range", String.valueOf(portRange - 1));
        JGroupsConfigBuilder.replaceProperties(jgroupsCfg, props, transportProtocol);
    }

    private static void configureGMSTimeout(JGroupsProtocolCfg jgroupsCfg, TransportFlags flags) {
        if (!flags.isZeroJoinTimeout()) {
            return;
        }
        ProtocolConfiguration protocol = jgroupsCfg.getProtocol(ProtocolType.GMS);
        if (protocol == null) {
            return;
        }
        protocol.getProperties().put("join_timeout", "0");
    }

    private static void replaceProperties(JGroupsProtocolCfg cfg, Map<String, String> newProps, ProtocolType type) {
        ProtocolConfiguration protocol = cfg.getProtocol(type);
        ProtocolConfiguration newProtocol = new ProtocolConfiguration(protocol.getProtocolName(), newProps);
        cfg.replaceProtocol(type, newProtocol);
    }

    private static ProtocolStackConfigurator loadProtocolStack(String relativePath) {
        try {
            return ConfiguratorFactory.getStackConfigurator((String)relativePath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static JGroupsProtocolCfg getJGroupsProtocolCfg(List<ProtocolConfiguration> baseStack) {
        JGroupsXmxlConfigurator configurator = new JGroupsXmxlConfigurator(baseStack);
        List protoStack = configurator.getProtocolStack();
        ProtocolType transportType = JGroupsConfigBuilder.getProtocolType(((ProtocolConfiguration)protoStack.get(0)).getProtocolName());
        HashMap<ProtocolType, ProtocolConfiguration> protoMap = new HashMap<ProtocolType, ProtocolConfiguration>(protoStack.size());
        for (ProtocolConfiguration cfg : protoStack) {
            protoMap.put(JGroupsConfigBuilder.getProtocolType(cfg.getProtocolName()), cfg);
        }
        return new JGroupsProtocolCfg(protoMap, configurator, transportType);
    }

    private static ProtocolType getProtocolType(String name) {
        int dotIndex = name.lastIndexOf(".");
        return ProtocolType.valueOf(dotIndex == -1 ? name : name.substring(dotIndex + 1));
    }

    static {
        protocolStackConfigurator = new HashMap<String, ProtocolStackConfigurator>();
        threadTcpIndex = new ThreadLocal<Integer>(){
            private final AtomicInteger counter = new AtomicInteger(0);

            @Override
            protected Integer initialValue() {
                return this.counter.getAndIncrement();
            }
        };
        threadUdpIndex = new ThreadLocal<Integer>(){
            private final AtomicInteger counter = new AtomicInteger(0);

            @Override
            protected Integer initialValue() {
                return this.counter.getAndIncrement();
            }
        };
        testUdpIndex = new ConcurrentHashMap<String, Integer>();
        JGROUPS_STACK = LegacyKeySupportSystemProperties.getProperty((String)"infinispan.cluster.stack", (String)"infinispan.test.jgroups.protocol", (String)"test-udp");
        System.out.println("Transport protocol stack used = " + JGROUPS_STACK);
        protocolStackConfigurator.put("test-tcp", JGroupsConfigBuilder.loadProtocolStack("stacks/tcp.xml"));
        protocolStackConfigurator.put("test-udp", JGroupsConfigBuilder.loadProtocolStack("stacks/udp.xml"));
        protocolStackConfigurator.put("tcp", JGroupsConfigBuilder.loadProtocolStack("default-configs/default-jgroups-tcp.xml"));
        protocolStackConfigurator.put("udp", JGroupsConfigBuilder.loadProtocolStack("default-configs/default-jgroups-udp.xml"));
    }

    static class JGroupsProtocolCfg {
        final Map<ProtocolType, ProtocolConfiguration> protoMap;
        final XmlConfigurator configurator;
        final ProtocolType transportType;

        JGroupsProtocolCfg(Map<ProtocolType, ProtocolConfiguration> protoMap, XmlConfigurator configurator, ProtocolType transportType) {
            this.protoMap = protoMap;
            this.configurator = configurator;
            this.transportType = transportType;
        }

        JGroupsProtocolCfg addProtocol(ProtocolType type, ProtocolConfiguration cfg, int position) {
            this.protoMap.put(type, cfg);
            this.configurator.getProtocolStack().add(position, cfg);
            return this;
        }

        JGroupsProtocolCfg removeProtocol(ProtocolType type) {
            this.configurator.getProtocolStack().remove(this.protoMap.remove((Object)type));
            return this;
        }

        ProtocolConfiguration getProtocol(ProtocolType type) {
            return this.protoMap.get((Object)type);
        }

        boolean containsProtocol(ProtocolType type) {
            return this.getProtocol(type) != null;
        }

        JGroupsProtocolCfg replaceProtocol(ProtocolType type, ProtocolConfiguration newCfg) {
            ProtocolConfiguration oldCfg = this.protoMap.get((Object)type);
            int position = this.configurator.getProtocolStack().indexOf(oldCfg);
            return this.removeProtocol(type).addProtocol(type, newCfg, position);
        }

        public String toString() {
            return this.configurator.getProtocolStackString(true);
        }
    }

    static enum ProtocolType {
        TCP,
        TCP_NIO2,
        UDP,
        SHARED_LOOPBACK,
        RED,
        MPING,
        PING,
        TCPPING,
        LOCAL_PING,
        SHARED_LOOPBACK_PING,
        MERGE2,
        MERGE3,
        FD_SOCK,
        FD,
        VERIFY_SUSPECT,
        VERIFY_SUSPECT2,
        FD_ALL,
        FD_ALL2,
        FD_ALL3,
        FD_SOCK2,
        BARRIER,
        UNICAST,
        UNICAST2,
        UNICAST3,
        NAKACK,
        NAKACK2,
        RSVP,
        STABLE,
        GMS,
        UFC,
        MFC,
        FC,
        UFC_NB,
        MFC_NB,
        FRAG2,
        FRAG3,
        FRAG4,
        STREAMING_STATE_TRANSFER,
        TEST_RELAY2;

    }

    static class JGroupsXmxlConfigurator
    extends XmlConfigurator {
        protected JGroupsXmxlConfigurator(List<ProtocolConfiguration> protocols) {
            super(JGroupsXmxlConfigurator.copy(protocols));
        }

        static List<ProtocolConfiguration> copy(List<ProtocolConfiguration> protocols) {
            ArrayList<ProtocolConfiguration> copy = new ArrayList<ProtocolConfiguration>(protocols.size());
            for (ProtocolConfiguration p : protocols) {
                copy.add(new ProtocolConfiguration(p.getProtocolName(), Map.copyOf(p.getProperties())));
            }
            return copy;
        }
    }
}

