/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.fwk;

public class TransportFlags {
    private boolean withFD;
    private boolean withMerge;
    private int siteIndex = -1;
    private String siteName;
    private String relayConfig;
    private boolean preserveConfig;
    private boolean zeroJoinTimeout;

    public TransportFlags withFD(boolean withFD) {
        this.withFD = withFD;
        return this;
    }

    public boolean withFD() {
        return this.withFD;
    }

    public TransportFlags withMerge(boolean withMerge) {
        this.withMerge = withMerge;
        return this;
    }

    public boolean withMerge() {
        return this.withMerge;
    }

    @Deprecated(forRemoval=true, since="13.0")
    public TransportFlags withPortRange(int portRange) {
        return this.withSiteIndex(portRange);
    }

    public TransportFlags withSiteIndex(int siteIndex) {
        this.siteIndex = siteIndex;
        return this;
    }

    public TransportFlags withSiteName(String siteName) {
        this.siteName = siteName;
        return this;
    }

    public TransportFlags withRelayConfig(String relayConf) {
        this.relayConfig = relayConf;
        return this;
    }

    public TransportFlags withPreserveConfig(boolean preserveConfig) {
        this.preserveConfig = preserveConfig;
        return this;
    }

    public TransportFlags withZeroJoinTimeout(boolean zeroJoinTimeout) {
        this.zeroJoinTimeout = zeroJoinTimeout;
        return this;
    }

    public String siteName() {
        return this.siteName;
    }

    public String relayConfig() {
        return this.relayConfig;
    }

    @Deprecated(forRemoval=true, since="13.0")
    public int portRange() {
        return this.siteIndex();
    }

    public int siteIndex() {
        return this.siteIndex;
    }

    public boolean isPortRangeSpecified() {
        return this.portRange() >= 0;
    }

    public boolean isRelayRequired() {
        return this.isPortRangeSpecified() && this.siteName != null;
    }

    public boolean isPreserveConfig() {
        return this.preserveConfig;
    }

    public boolean isZeroJoinTimeout() {
        return this.zeroJoinTimeout;
    }

    public static TransportFlags minimalXsiteFlags() {
        return new TransportFlags().withSiteIndex(0).withSiteName("LON-1").withFD(true);
    }
}

