/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.transaction.LockingMode;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.ExplicitLockingMultipleKeyTest")
public class ExplicitLockingMultipleKeyTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder c = ExplicitLockingMultipleKeyTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        c.transaction().lockingMode(LockingMode.PESSIMISTIC);
        this.createCluster(TestDataSCI.INSTANCE, c, 2);
        this.waitForClusterToForm();
    }

    public void testAcquireRemoteLocks1() throws Exception {
        this.runTest(0, 1);
    }

    public void testAcquireRemoteLocks2() throws Exception {
        this.runTest(0, 0);
    }

    public void testAcquireRemoteLocks3() throws Exception {
        this.runTest(1, 1);
    }

    public void testAcquireRemoteLocks4() throws Exception {
        this.runTest(1, 0);
    }

    private void runTest(int lockOwner, int txOriginator) throws Exception {
        Object k0_1 = this.getKeyForCache(lockOwner);
        Object k0_2 = this.getKeyForCache(lockOwner);
        this.tm(txOriginator).begin();
        this.advancedCache(txOriginator).lock(new Object[]{k0_1, k0_2});
        this.assertKeyLockedCorrectly(k0_1);
        this.assertKeyLockedCorrectly(k0_2);
        this.tm(txOriginator).commit();
        this.assertNotLocked(k0_1);
        this.assertNotLocked(k0_2);
    }
}

