/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.remoting.inboundhandler.AbstractDelegatingHandler;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.impl.TransactionTable;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.PrepareProcessedAfterOriginatorCrashTest")
public class PrepareProcessedAfterOriginatorCrashTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder dcc = PrepareProcessedAfterOriginatorCrashTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        dcc.clustering().hash().numOwners(1);
        this.createClusteredCaches(2, dcc);
    }

    public void testBelatedTransactionDoesntLeak() throws Throwable {
        final CountDownLatch prepareReceived = new CountDownLatch(1);
        final CountDownLatch prepareBlocked = new CountDownLatch(1);
        final CountDownLatch prepareExecuted = new CountDownLatch(1);
        Cache receiver = this.cache(1);
        PerCacheInboundInvocationHandler originalInvocationHandler = TestingUtil.extractComponent(receiver, PerCacheInboundInvocationHandler.class);
        AbstractDelegatingHandler blockingInvocationHandler = new AbstractDelegatingHandler(originalInvocationHandler){

            public void handle(CacheRpcCommand command, Reply reply, DeliverOrder order) {
                if (!(command instanceof PrepareCommand)) {
                    this.delegate.handle(command, reply, order);
                    return;
                }
                try {
                    prepareReceived.countDown();
                    prepareBlocked.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new IllegalLifecycleStateException((Throwable)e);
                }
                log.trace((Object)"Processing belated prepare");
                this.delegate.handle(command, returnValue -> {
                    prepareExecuted.countDown();
                    reply.reply(returnValue);
                }, order);
            }
        };
        TestingUtil.replaceComponent(receiver, PerCacheInboundInvocationHandler.class, blockingInvocationHandler, true);
        TestingUtil.extractComponentRegistry(receiver).cacheComponents();
        Object key = this.getKeyForCache(1);
        this.fork(() -> {
            try {
                this.cache(0).put(key, (Object)"v");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        prepareReceived.await(10L, TimeUnit.SECONDS);
        this.killMember(0);
        Thread.sleep(5000L);
        prepareBlocked.countDown();
        prepareExecuted.await(10L, TimeUnit.SECONDS);
        log.trace((Object)"Finished waiting for belated prepare to complete");
        TransactionTable transactionTable = TestingUtil.getTransactionTable(receiver);
        AssertJUnit.assertEquals((int)0, (int)transactionTable.getRemoteTxCount());
        AssertJUnit.assertEquals((int)0, (int)transactionTable.getLocalTxCount());
        AssertJUnit.assertFalse((boolean)receiver.getAdvancedCache().getLockManager().isLocked(key));
    }
}

