/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.util.concurrent.CountDownLatch;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commons.TimeoutException;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.InCacheMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.util.mocks.ControlledCommandFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="tx.RollbackBeforePrepareTest", groups={"functional"})
@InCacheMode(value={CacheMode.DIST_SYNC, CacheMode.REPL_SYNC})
public class RollbackBeforePrepareTest
extends MultipleCacheManagersTest {
    public static final long REPL_TIMEOUT = 1000L;
    public static final long LOCK_TIMEOUT = 500L;
    private FailPrepareInterceptor failPrepareInterceptor;
    protected int numOwners = 3;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder config = RollbackBeforePrepareTest.getDefaultClusteredCacheConfig(this.cacheMode, true);
        config.locking().lockAcquisitionTimeout(500L).clustering().remoteTimeout(1000L).clustering().hash().numOwners(this.numOwners).transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).transaction().completedTxTimeout(3600000L);
        this.createCluster(config, 3);
        this.waitForClusterToForm();
        this.failPrepareInterceptor = new FailPrepareInterceptor();
        TestingUtil.extractInterceptorChain(this.advancedCache(2)).addInterceptor((AsyncInterceptor)this.failPrepareInterceptor, 1);
    }

    public void testCommitNotSentBeforeAllPrepareAreAck() throws Exception {
        ControlledCommandFactory ccf = ControlledCommandFactory.registerControlledCommandFactory(this.cache(1), PrepareCommand.class);
        ccf.gate.close();
        try {
            this.cache(0).put((Object)"k", (Object)"v");
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RollbackBeforePrepareTest.allowRollbackToRun();
        ccf.gate.open();
        Thread.sleep(3000L);
        RollbackBeforePrepareTest.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                int remoteTxCount0 = TestingUtil.getTransactionTable(RollbackBeforePrepareTest.this.cache(0)).getRemoteTxCount();
                int remoteTxCount1 = TestingUtil.getTransactionTable(RollbackBeforePrepareTest.this.cache(1)).getRemoteTxCount();
                int remoteTxCount2 = TestingUtil.getTransactionTable(RollbackBeforePrepareTest.this.cache(2)).getRemoteTxCount();
                log.tracef("remote0=%s, remote1=%s, remote2=%s", remoteTxCount0, remoteTxCount1, remoteTxCount2);
                return remoteTxCount0 == 0 && remoteTxCount1 == 0 && remoteTxCount2 == 0;
            }
        });
        Assert.assertNull((Object)this.cache(0).get((Object)"k"));
        Assert.assertNull((Object)this.cache(1).get((Object)"k"));
        Assert.assertNull((Object)this.cache(2).get((Object)"k"));
        this.assertNotLocked("k");
    }

    private static void allowRollbackToRun() throws InterruptedException {
        Thread.sleep(15000L);
    }

    public static class FailPrepareInterceptor
    extends DDAsyncInterceptor {
        CountDownLatch failureFinish = new CountDownLatch(1);

        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            try {
                throw new TimeoutException("Induced!");
            }
            catch (Throwable throwable) {
                this.failureFinish.countDown();
                throw throwable;
            }
        }
    }
}

