/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.tx.RollbackBeforePrepareTest;
import org.infinispan.util.mocks.ControlledCommandFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.TxCompletionForRolledBackTxOptTest")
public class TxCompletionForRolledBackTxOptTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder dcc = TxCompletionForRolledBackTxOptTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        dcc.clustering().hash().numOwners(1).transaction().lockingMode(LockingMode.OPTIMISTIC);
        this.createCluster(TestDataSCI.INSTANCE, dcc, 3);
        this.waitForClusterToForm();
        TestingUtil.extractInterceptorChain(this.advancedCache(2)).addInterceptor((AsyncInterceptor)new RollbackBeforePrepareTest.FailPrepareInterceptor(), 1);
    }

    public void testTxCompletionNotSentForRollback() throws Throwable {
        ControlledCommandFactory cf = ControlledCommandFactory.registerControlledCommandFactory(this.cache(1), null);
        this.tm(0).begin();
        Object k1 = this.getKeyForCache(1);
        Object k2 = this.getKeyForCache(2);
        this.cache(0).put(k1, k1);
        this.cache(0).put(k2, k2);
        try {
            this.tm(0).commit();
            Assert.fail();
        }
        catch (Throwable t) {
            log.debugf("Got expected exception", (Object)t);
        }
        this.assertNotLocked(k1);
        this.assertNotLocked(k2);
        Assert.assertNull((Object)this.cache(0).get(k1));
        Assert.assertNull((Object)this.cache(0).get(k2));
        Assert.assertEquals((int)cf.received(VersionedPrepareCommand.class), (int)1);
        Assert.assertEquals((int)cf.received(RollbackCommand.class), (int)1);
        Assert.assertEquals((int)cf.received(TxCompletionNotificationCommand.class), (int)0);
    }
}

