/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.util.CyclicDependencyException;
import org.infinispan.util.DependencyGraph;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="util.DependencyGraphTest", groups={"unit"})
public class DependencyGraphTest
extends AbstractInfinispanTest {
    @Test
    public void testEmpty() throws CyclicDependencyException {
        Assert.assertTrue((boolean)new DependencyGraph().topologicalSort().isEmpty());
    }

    @Test
    public void testLinear() throws CyclicDependencyException {
        DependencyGraph graph = new DependencyGraph();
        int size = 100;
        for (int i = 1; i <= size; ++i) {
            graph.addDependency((Object)i, (Object)(i - 1));
        }
        List sort = graph.topologicalSort();
        Assert.assertEquals((int)sort.size(), (int)(size + 1));
        Assert.assertEquals(sort.get(0), (Object)100);
        Assert.assertEquals(sort.get(100), (Object)0);
    }

    @Test
    public void testNonLinear() throws CyclicDependencyException {
        DependencyGraph graph = new DependencyGraph();
        String A2 = "a";
        String B2 = "b";
        String C2 = "c";
        String D4 = "d";
        graph.addDependency((Object)C2, (Object)B2);
        graph.addDependency((Object)C2, (Object)D4);
        graph.addDependency((Object)B2, (Object)A2);
        graph.addDependency((Object)A2, (Object)D4);
        List sort = graph.topologicalSort();
        Assert.assertEquals((Collection)sort, Arrays.asList(C2, B2, A2, D4));
    }

    @Test
    public void testIdempotency() throws CyclicDependencyException {
        DependencyGraph g = new DependencyGraph();
        g.addDependency((Object)"N1", (Object)"N2");
        g.addDependency((Object)"N2", (Object)"N3");
        g.addDependency((Object)"N1", (Object)"N2");
        g.addDependency((Object)"N2", (Object)"N3");
        Assert.assertEquals((int)g.topologicalSort().size(), (int)3);
        Assert.assertEquals((Collection)g.topologicalSort(), Arrays.asList("N1", "N2", "N3"));
    }

    @Test
    public void testDependent() throws CyclicDependencyException {
        DependencyGraph graph = new DependencyGraph();
        graph.addDependency((Object)"A", (Object)"B");
        graph.addDependency((Object)"A", (Object)"C");
        graph.addDependency((Object)"A", (Object)"D");
        graph.addDependency((Object)"D", (Object)"F");
        Assert.assertTrue((boolean)graph.hasDependent((Object)"B"));
        Assert.assertTrue((boolean)graph.hasDependent((Object)"C"));
        Assert.assertTrue((boolean)graph.hasDependent((Object)"D"));
        Assert.assertTrue((boolean)graph.hasDependent((Object)"F"));
        Assert.assertFalse((boolean)graph.hasDependent((Object)"A"));
        Assert.assertTrue((boolean)graph.getDependents((Object)"A").isEmpty());
        Assert.assertEquals((String)((String)graph.getDependents((Object)"B").iterator().next()), (String)"A");
        Assert.assertEquals((String)((String)graph.getDependents((Object)"C").iterator().next()), (String)"A");
        Assert.assertEquals((String)((String)graph.getDependents((Object)"D").iterator().next()), (String)"A");
        Assert.assertEquals((String)((String)graph.getDependents((Object)"F").iterator().next()), (String)"D");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentAccess() throws Exception {
        DependencyGraph graph = new DependencyGraph();
        ExecutorService service = Executors.newCachedThreadPool(this.getTestThreadFactory("Worker"));
        try {
            CountDownLatch startLatch = new CountDownLatch(1);
            int threads = 20;
            ArrayList futures = new ArrayList();
            for (int i = 0; i < threads; ++i) {
                futures.add(this.submitTask("A", "B", startLatch, service, (DependencyGraph<String>)graph));
                futures.add(this.submitTask("A", "C", startLatch, service, (DependencyGraph<String>)graph));
                futures.add(this.submitTask("A", "D", startLatch, service, (DependencyGraph<String>)graph));
                futures.add(this.submitTask("A", "B", startLatch, service, (DependencyGraph<String>)graph));
                futures.add(this.submitTask("D", "B", startLatch, service, (DependencyGraph<String>)graph));
                futures.add(this.submitTask("D", "C", startLatch, service, (DependencyGraph<String>)graph));
                futures.add(this.submitTask("C", "B", startLatch, service, (DependencyGraph<String>)graph));
            }
            startLatch.countDown();
            this.awaitAll(futures);
        }
        finally {
            service.shutdownNow();
        }
        Assert.assertEquals((Collection)graph.topologicalSort(), Arrays.asList("A", "D", "C", "B"));
    }

    @Test
    public void testRemoveDependency() throws CyclicDependencyException {
        DependencyGraph g = new DependencyGraph();
        g.addDependency((Object)"E", (Object)"B");
        g.addDependency((Object)"E", (Object)"C");
        g.addDependency((Object)"E", (Object)"D");
        g.addDependency((Object)"B", (Object)"D");
        g.addDependency((Object)"B", (Object)"C");
        g.addDependency((Object)"C", (Object)"D");
        Assert.assertEquals((Collection)g.topologicalSort(), Arrays.asList("E", "B", "C", "D"));
        g.removeDependency((Object)"E", (Object)"B");
        g.addDependency((Object)"B", (Object)"E");
        Assert.assertEquals((Collection)g.topologicalSort(), Arrays.asList("B", "E", "C", "D"));
        g.clearAll();
        Assert.assertTrue((boolean)g.topologicalSort().isEmpty());
    }

    @Test
    public void testRemoveElement() throws CyclicDependencyException {
        DependencyGraph g = new DependencyGraph();
        g.addDependency((Object)"E", (Object)"B");
        g.addDependency((Object)"E", (Object)"C");
        g.addDependency((Object)"E", (Object)"D");
        g.addDependency((Object)"B", (Object)"D");
        g.addDependency((Object)"B", (Object)"C");
        g.addDependency((Object)"C", (Object)"D");
        Assert.assertEquals((Collection)g.topologicalSort(), Arrays.asList("E", "B", "C", "D"));
        g.remove((Object)"C");
        Assert.assertEquals((Collection)g.topologicalSort(), Arrays.asList("E", "B", "D"));
        g.remove((Object)"B");
        Assert.assertEquals((Collection)g.topologicalSort(), Arrays.asList("E", "D"));
        g.remove((Object)"E");
        Assert.assertEquals((Collection)g.topologicalSort(), Arrays.asList("D"));
        g.remove((Object)"D");
        Assert.assertTrue((boolean)g.topologicalSort().isEmpty());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testAddSelf() {
        new DependencyGraph().addDependency((Object)"N", (Object)"N");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testAdNull() {
        new DependencyGraph().addDependency((Object)"N", null);
    }

    @Test(expectedExceptions={CyclicDependencyException.class})
    public void testCycle() throws CyclicDependencyException {
        DependencyGraph graph = new DependencyGraph();
        Object o1 = new Object();
        Object o2 = new Object();
        Object o3 = new Object();
        graph.addDependency(o1, o2);
        graph.addDependency(o2, o3);
        graph.addDependency(o3, o1);
        graph.topologicalSort();
    }

    private Future<?> submitTask(final String from, final String to, final CountDownLatch waitingFor, ExecutorService onExecutor, final DependencyGraph<String> graph) {
        return onExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    waitingFor.await();
                    graph.addDependency((Object)from, (Object)to);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
    }

    private void awaitAll(List<Future<?>> futures) throws Exception {
        for (Future<?> f : futures) {
            f.get(10L, TimeUnit.SECONDS);
        }
    }
}

