/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional", "xsite"}, testName="xsite.XSiteCacheConfigurationTest")
public class XSiteCacheConfigurationTest {
    public static final String LON = "LON-1";
    public static final String NYC = "NYC-2";
    public static final String SFO = "SFO-3";

    public void testApi() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(CacheMode.DIST_SYNC);
        cb.sites().addBackup().site(LON).strategy(BackupConfiguration.BackupStrategy.SYNC).sites().addBackup().site(SFO).sites().addBackup().site(NYC);
        Assert.assertEquals((int)cb.sites().backups().size(), (int)3);
        BackupConfigurationBuilder backup0 = (BackupConfigurationBuilder)cb.sites().backups().get(0);
        Assert.assertEquals((String)backup0.site(), (String)LON);
        Assert.assertEquals((Object)backup0.strategy(), (Object)BackupConfiguration.BackupStrategy.SYNC);
        BackupConfigurationBuilder backup1 = (BackupConfigurationBuilder)cb.sites().backups().get(1);
        Assert.assertEquals((String)backup1.site(), (String)SFO);
        Assert.assertEquals((Object)backup1.strategy(), (Object)BackupConfiguration.BackupStrategy.ASYNC);
        BackupConfigurationBuilder backup2 = (BackupConfigurationBuilder)cb.sites().backups().get(2);
        Assert.assertEquals((String)backup2.site(), (String)NYC);
        Assert.assertEquals((Object)backup2.strategy(), (Object)BackupConfiguration.BackupStrategy.ASYNC);
        Configuration b = cb.build();
        Assert.assertEquals((int)b.sites().allBackups().size(), (int)3);
        BackupConfiguration b0 = (BackupConfiguration)b.sites().allBackups().get(0);
        Assert.assertEquals((String)b0.site(), (String)LON);
        Assert.assertEquals((Object)b0.strategy(), (Object)BackupConfiguration.BackupStrategy.SYNC);
        BackupConfiguration b1 = (BackupConfiguration)b.sites().allBackups().get(1);
        Assert.assertEquals((String)b1.site(), (String)SFO);
        Assert.assertEquals((Object)b1.strategy(), (Object)BackupConfiguration.BackupStrategy.ASYNC);
        BackupConfigurationBuilder b2 = (BackupConfigurationBuilder)cb.sites().backups().get(2);
        Assert.assertEquals((String)b2.site(), (String)NYC);
        Assert.assertEquals((Object)b2.strategy(), (Object)BackupConfiguration.BackupStrategy.ASYNC);
    }

    @Test(expectedExceptions={CacheConfigurationException.class}, expectedExceptionsMessageRegExp="ISPN\\d+: Multiple sites have the same name 'LON-1'. This configuration is not valid.")
    public void testSameBackupDefinedMultipleTimes() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(CacheMode.DIST_SYNC);
        cb.sites().addBackup().site(LON).strategy(BackupConfiguration.BackupStrategy.SYNC).sites().addBackup().site(LON).sites().addBackup().site(NYC);
        cb.build();
    }

    @Test(expectedExceptions={CacheConfigurationException.class}, expectedExceptionsMessageRegExp="ISPN\\d+: Backup configuration must include a 'site'.")
    public void testBackupSiteNotSpecified() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(CacheMode.DIST_SYNC);
        cb.sites().addBackup().site();
        cb.build();
    }

    @Test(expectedExceptions={CacheConfigurationException.class}, expectedExceptionsMessageRegExp="ISPN\\d+: You must specify a 'failure-policy-class' to use a custom backup failure policy for backup 'LON-1'.")
    public void testCustomBackupFailurePolicyClassNotSpecified() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(CacheMode.DIST_SYNC);
        cb.sites().addBackup().site(LON).backupFailurePolicy(BackupFailurePolicy.CUSTOM).failurePolicyClass();
        cb.build();
    }

    @Test(expectedExceptions={CacheConfigurationException.class}, expectedExceptionsMessageRegExp="ISPN\\d+: Two-phase commit can only be used with synchronous backup strategy.")
    public void testTwoPhaseCommitAsyncBackup() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(CacheMode.DIST_SYNC);
        cb.sites().addBackup().site(LON).strategy(BackupConfiguration.BackupStrategy.ASYNC).useTwoPhaseCommit(true);
        cb.build();
    }

    public void testMultipleCachesWithNoCacheName() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(CacheMode.DIST_SYNC);
        cb.sites().addBackup().site(LON).strategy(BackupConfiguration.BackupStrategy.SYNC).sites().addBackup().site(SFO).sites().addBackup().site(NYC);
        cb.build();
    }

    @Test(expectedExceptions={CacheConfigurationException.class}, expectedExceptionsMessageRegExp="ISPN\\d+: Cross-site replication not available for local cache.")
    public void testLocalCache() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.sites().addBackup().site(LON);
        builder.build();
    }

    @Test(expectedExceptions={CacheConfigurationException.class}, expectedExceptionsMessageRegExp="ISPN\\d+: Cross-site replication not available for local cache.")
    public void testLocalCacheWithBackupFor() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.sites().backupFor().remoteCache("remote").remoteSite(LON);
        builder.build();
    }

    @Test(expectedExceptions={CacheConfigurationException.class}, expectedExceptionsMessageRegExp="ISPN\\d+: The XSiteEntryMergePolicy is missing. The cache configuration must include a merge policy.")
    public void testNullXSiteEntryMergePolicy() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.sites().mergePolicy(null);
        builder.build();
    }
}

