/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.remoting.transport.AbstractDelegatingTransport;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.XSiteResponse;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.commands.remote.XSiteRequest;

public class ControlledTransport
extends AbstractDelegatingTransport {
    volatile Supplier<Throwable> throwableSupplier = () -> null;
    private final String local;
    private final Collection<String> connectedSites;
    private final Collection<String> disconnectedSites;

    ControlledTransport(Transport actual, String local, Collection<String> connectedSites, Collection<String> disconnectedSites) {
        super(actual);
        this.local = local;
        this.connectedSites = connectedSites;
        this.disconnectedSites = disconnectedSites;
    }

    ControlledTransport(Transport actual, String local, Collection<String> disconnectedSites) {
        this(actual, local, Collections.singleton(local), disconnectedSites);
    }

    public void start() {
    }

    public <O> XSiteResponse<O> backupRemotely(XSiteBackup backup, XSiteRequest<O> rpcCommand) {
        Throwable t = null;
        if (this.disconnectedSites.contains(backup.getSiteName())) {
            t = this.throwableSupplier.get();
        }
        ControlledXSiteResponse response = new ControlledXSiteResponse(backup, t);
        response.complete();
        return response;
    }

    public void checkCrossSiteAvailable() throws CacheConfigurationException {
    }

    public String localSiteName() {
        return this.local;
    }

    public Set<String> getSitesView() {
        return Set.copyOf(this.connectedSites);
    }

    private static class ControlledXSiteResponse<T>
    extends CompletableFuture<T>
    implements XSiteResponse<T> {
        private final XSiteBackup backup;
        private final Throwable result;

        private ControlledXSiteResponse(XSiteBackup backup, Throwable result) {
            this.backup = backup;
            this.result = result;
        }

        public void whenCompleted(XSiteResponse.XSiteResponseCompleted listener) {
            listener.onCompleted(this.backup, System.currentTimeMillis(), 0L, this.result);
        }

        void complete() {
            if (this.result == null) {
                this.complete(null);
            } else {
                this.completeExceptionally(this.result);
            }
        }
    }
}

