/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac.persistence;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.versioning.irac.IracEntryVersion;
import org.infinispan.container.versioning.irac.IracVersionGenerator;
import org.infinispan.container.versioning.irac.TopologyIracVersion;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.manager.PreloadManager;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.support.WaitDelegatingNonBlockingStore;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.AbstractXSiteTest;
import org.infinispan.xsite.XSiteNamedCache;
import org.infinispan.xsite.irac.ControlledIracVersionGenerator;
import org.infinispan.xsite.irac.ManualIracManager;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="xsite.irac.persistence.IracMetadataStoreTest")
public class IracMetadataStoreTest
extends AbstractXSiteTest {
    private static final String LON = "LON-1";
    private static final String NYC = "NYC-2";
    private static final int NUM_NODES = 3;
    private static final AtomicLong V_GENERATOR = new AtomicLong(0L);
    private final List<Runnable> cleanupTask = Collections.synchronizedList(new LinkedList());
    private TxMode lonTxMode;
    private TxMode nycTxMode;
    private boolean passivation;

    private static ConfigurationBuilder createConfigurationBuilder(TxMode txMode, boolean passivation) {
        ConfigurationBuilder builder;
        switch (txMode.ordinal()) {
            case 0: {
                builder = IracMetadataStoreTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
                break;
            }
            case 1: {
                builder = IracMetadataStoreTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
                builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
                builder.transaction().lockingMode(LockingMode.OPTIMISTIC);
                break;
            }
            case 2: {
                builder = IracMetadataStoreTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
                builder.transaction().lockingMode(LockingMode.PESSIMISTIC);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        builder.persistence().passivation(passivation);
        builder.clustering().hash().numSegments(4);
        return builder;
    }

    private static IracMetadata generateNew() {
        long v = V_GENERATOR.incrementAndGet();
        ByteString site = XSiteNamedCache.cachedByteString((String)LON);
        return new IracMetadata(site, IracEntryVersion.newVersion((ByteString)site, (TopologyIracVersion)TopologyIracVersion.create((int)1, (long)v)));
    }

    private static ManualIracVersionGenerator createManualIracVerionGenerator(Cache<String, Object> cache) {
        return TestingUtil.wrapComponent(cache, IracVersionGenerator.class, ManualIracVersionGenerator::new);
    }

    @Factory
    public Object[] factory() {
        LinkedList<IracMetadataStoreTest> tests = new LinkedList<IracMetadataStoreTest>();
        for (TxMode lon : TxMode.values()) {
            for (TxMode nyc : TxMode.values()) {
                tests.add(new IracMetadataStoreTest().setLonTxMode(lon).setNycTxMode(nyc).setPassivation(true));
                tests.add(new IracMetadataStoreTest().setLonTxMode(lon).setNycTxMode(nyc).setPassivation(false));
            }
        }
        return tests.toArray();
    }

    public void testSendEvictedKey(Method method) {
        IracMetadata metadata;
        String key = TestingUtil.k(method, 1);
        Cache<String, Object> pOwnerCache = this.findPrimaryOwner(key);
        ManualIracVersionGenerator vGenerator = IracMetadataStoreTest.createManualIracVerionGenerator(pOwnerCache);
        ManualIracManager iracManager = this.createManualIracManager(pOwnerCache);
        vGenerator.metadata = metadata = IracMetadataStoreTest.generateNew();
        pOwnerCache.put((Object)key, (Object)"v1");
        this.evictKey(LON, key);
        this.assertNotInDataContainer(LON, key);
        this.assertInCacheStore(LON, key, "v1", metadata);
        this.assertInSite(NYC, cache -> AssertJUnit.assertNull((Object)cache.get((Object)key)));
        iracManager.sendKeys();
        this.assertEventuallyInSite(NYC, cache -> cache.get((Object)key) != null, 30L, TimeUnit.SECONDS);
        this.assertInDataContainer(NYC, key, "v1", metadata);
        if (!this.passivation) {
            this.assertInCacheStore(NYC, key, "v1", metadata);
        }
    }

    public void testCorrectMetadataStored(Method method) {
        IracMetadata metadata;
        String key = TestingUtil.k(method, 1);
        Cache<String, Object> pOwnerCache = this.findPrimaryOwner(key);
        ManualIracVersionGenerator vGenerator = IracMetadataStoreTest.createManualIracVerionGenerator(pOwnerCache);
        ManualIracManager iracManager = this.createManualIracManager(pOwnerCache);
        vGenerator.metadata = metadata = IracMetadataStoreTest.generateNew();
        pOwnerCache.put((Object)key, (Object)"v");
        this.assertInDataContainer(LON, key, "v", metadata);
        if (!this.passivation) {
            this.assertInCacheStore(LON, key, "v", metadata);
        }
        this.assertInSite(NYC, cache -> AssertJUnit.assertNull((Object)cache.get((Object)key)));
        iracManager.sendKeys();
        this.assertEventuallyInSite(NYC, cache -> cache.get((Object)key) != null, 30L, TimeUnit.SECONDS);
        this.assertInDataContainer(NYC, key, "v", metadata);
        if (!this.passivation) {
            this.assertInCacheStore(NYC, key, "v", metadata);
        }
    }

    public void testKeyEvictedOnReceive(Method method) {
        IracMetadata metadata;
        String key = TestingUtil.k(method, 1);
        Cache<String, Object> pOwnerCache = this.findPrimaryOwner(key);
        ManualIracVersionGenerator vGenerator = IracMetadataStoreTest.createManualIracVerionGenerator(pOwnerCache);
        ManualIracManager iracManager = this.createManualIracManager(pOwnerCache);
        vGenerator.metadata = metadata = IracMetadataStoreTest.generateNew();
        pOwnerCache.put((Object)key, (Object)"v2");
        iracManager.sendKeys();
        this.assertInDataContainer(LON, key, "v2", metadata);
        if (!this.passivation) {
            this.assertInCacheStore(LON, key, "v2", metadata);
        }
        this.assertEventuallyInSite(NYC, cache -> cache.get((Object)key) != null, 30L, TimeUnit.SECONDS);
        this.assertInDataContainer(NYC, key, "v2", metadata);
        if (!this.passivation) {
            this.assertInCacheStore(NYC, key, "v2", metadata);
        }
        this.evictKey(NYC, key);
        this.assertNotInDataContainer(NYC, key);
        this.assertInCacheStore(NYC, key, "v2", metadata);
        vGenerator.metadata = metadata = IracMetadataStoreTest.generateNew();
        pOwnerCache.put((Object)key, (Object)"v3");
        iracManager.sendKeys();
        this.assertEventuallyInSite(NYC, cache -> "v3".equals(cache.get((Object)key)), 30L, TimeUnit.SECONDS);
        this.assertInDataContainer(NYC, key, "v3", metadata);
        if (!this.passivation) {
            this.assertInCacheStore(NYC, key, "v3", metadata);
        }
    }

    public void testPreload(Method method) {
        IracMetadata metadata;
        String key = TestingUtil.k(method, 1);
        Cache<String, Object> pOwnerCache = this.findPrimaryOwner(key);
        ManualIracVersionGenerator vGenerator = IracMetadataStoreTest.createManualIracVerionGenerator(pOwnerCache);
        ManualIracManager iracManager = this.createManualIracManager(pOwnerCache);
        vGenerator.metadata = metadata = IracMetadataStoreTest.generateNew();
        pOwnerCache.put((Object)key, (Object)"v4");
        iracManager.sendKeys();
        this.assertEventuallyInSite(NYC, cache -> "v4".equals(cache.get((Object)key)), 30L, TimeUnit.SECONDS);
        this.evictKey(LON, key);
        this.assertNotInDataContainer(LON, key);
        this.assertInCacheStore(LON, key, "v4", metadata);
        this.preload();
        this.assertInDataContainer(LON, key, "v4", metadata);
        if (!this.passivation) {
            this.assertInCacheStore(LON, key, "v4", metadata);
        }
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void destroy() {
        this.cleanupTask.forEach(Runnable::run);
        super.destroy();
    }

    @Override
    protected void createSites() {
        GlobalConfigurationBuilder lonGCB = this.globalConfigurationBuilderForSite();
        AbstractXSiteTest.TestSite lon = this.addSite(LON);
        for (int i = 0; i < 3; ++i) {
            ConfigurationBuilder builder = this.getLonActiveConfig();
            ((DummyInMemoryStoreConfigurationBuilder)builder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).preload(true);
            lon.addCache(lonGCB, builder);
        }
        GlobalConfigurationBuilder nycGCB = this.globalConfigurationBuilderForSite();
        AbstractXSiteTest.TestSite nyc = this.addSite(NYC);
        for (int i = 0; i < 3; ++i) {
            ConfigurationBuilder builder = this.getNycActiveConfig();
            ((DummyInMemoryStoreConfigurationBuilder)builder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).preload(true);
            nyc.addCache(nycGCB, builder);
        }
        lon.waitForClusterToForm(null);
        nyc.waitForClusterToForm(null);
    }

    @Override
    protected String[] parameterNames() {
        return new String[]{"LON", "NYC", "passivation"};
    }

    @Override
    protected Object[] parameterValues() {
        return new Object[]{this.lonTxMode, this.nycTxMode, this.passivation};
    }

    private void preload() {
        for (Cache cache : this.caches(LON)) {
            PreloadManager pm = TestingUtil.extractComponent(cache, PreloadManager.class);
            pm.start();
        }
    }

    private GlobalConfigurationBuilder globalConfigurationBuilderForSite() {
        GlobalConfigurationBuilder builder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        builder.serialization().addContextInitializer((SerializationContextInitializer)TestDataSCI.INSTANCE);
        return builder;
    }

    private ConfigurationBuilder getNycActiveConfig() {
        return IracMetadataStoreTest.createConfigurationBuilder(this.nycTxMode, this.passivation);
    }

    private ConfigurationBuilder getLonActiveConfig() {
        ConfigurationBuilder builder = IracMetadataStoreTest.createConfigurationBuilder(this.lonTxMode, this.passivation);
        BackupConfigurationBuilder lonBackupConfigurationBuilder = builder.sites().addBackup();
        lonBackupConfigurationBuilder.site(NYC).strategy(BackupConfiguration.BackupStrategy.ASYNC);
        return builder;
    }

    private ManualIracManager createManualIracManager(Cache<String, Object> cache) {
        ManualIracManager manager = ManualIracManager.wrapCache(cache);
        manager.enable();
        return manager;
    }

    private void assertNotInDataContainer(String site, String key) {
        for (Cache cache : this.caches(site)) {
            if (this.isNotWriteOwner(cache, key)) continue;
            InternalDataContainer<String, Object> dc = this.getInternalDataContainer(cache);
            InternalCacheEntry ice = dc.peek((Object)key);
            log.debugf("Checking DataContainer in %s. entry=%s", (Object)DistributionTestHelper.addressOf(cache), (Object)ice);
            AssertJUnit.assertNull((String)String.format("Internal entry found for key %s", key), (Object)ice);
        }
    }

    private void assertInDataContainer(String site, String key, String value, IracMetadata metadata) {
        for (Cache cache : this.caches(site)) {
            if (this.isNotWriteOwner(cache, key)) continue;
            InternalDataContainer<String, Object> dc = this.getInternalDataContainer(cache);
            InternalCacheEntry ice = dc.peek((Object)key);
            log.debugf("Checking DataContainer in %s. entry=%s", (Object)DistributionTestHelper.addressOf(cache), (Object)ice);
            AssertJUnit.assertNotNull((String)String.format("Internal entry is null for key %s", key), (Object)ice);
            AssertJUnit.assertEquals((String)"Internal entry wrong key", (String)key, (String)((String)ice.getKey()));
            AssertJUnit.assertEquals((String)"Internal entry wrong value", (Object)value, (Object)ice.getValue());
            AssertJUnit.assertEquals((String)"Internal entry wrong metadata", (Object)metadata, (Object)ice.getInternalMetadata().iracMetadata());
        }
    }

    private void assertInCacheStore(String site, String key, String value, IracMetadata metadata) {
        for (Cache cache : this.caches(site)) {
            if (this.isNotWriteOwner(cache, key)) continue;
            WaitDelegatingNonBlockingStore cl = TestingUtil.getFirstStoreWait(cache);
            MarshallableEntry mEntry = cl.loadEntry(key);
            log.debugf("Checking CacheLoader in %s. entry=%s", (Object)DistributionTestHelper.addressOf(cache), mEntry);
            AssertJUnit.assertNotNull((String)String.format("CacheLoader entry is null for key %s", key), mEntry);
            AssertJUnit.assertEquals((String)"CacheLoader entry wrong key", (String)key, (String)((String)mEntry.getKey()));
            AssertJUnit.assertEquals((String)"CacheLoader entry wrong value", (Object)value, (Object)mEntry.getValue());
            AssertJUnit.assertNotNull((String)"CacheLoader entry wrong internal metadata", (Object)mEntry.getInternalMetadata());
            AssertJUnit.assertEquals((String)"CacheLoader entry wrong IRAC metadata", (Object)metadata, (Object)mEntry.getInternalMetadata().iracMetadata());
        }
    }

    private InternalDataContainer<String, Object> getInternalDataContainer(Cache<String, Object> cache) {
        return TestingUtil.extractComponent(cache, InternalDataContainer.class);
    }

    private void evictKey(String site, String key) {
        for (Cache cache : this.caches(site)) {
            if (this.isNotWriteOwner(cache, key)) continue;
            this.getInternalDataContainer(cache).evict(this.getSegmentForKey(cache, key), (Object)key).toCompletableFuture().join();
        }
    }

    private IracMetadataStoreTest setLonTxMode(TxMode lonTxMode) {
        this.lonTxMode = lonTxMode;
        return this;
    }

    private IracMetadataStoreTest setNycTxMode(TxMode nycTxMode) {
        this.nycTxMode = nycTxMode;
        return this;
    }

    private IracMetadataStoreTest setPassivation(boolean passivation) {
        this.passivation = passivation;
        return this;
    }

    private DistributionInfo getDistributionForKey(Cache<String, Object> cache, String key) {
        return TestingUtil.extractComponent(cache, ClusteringDependentLogic.class).getCacheTopology().getDistribution((Object)key);
    }

    private int getSegmentForKey(Cache<String, Object> cache, String key) {
        return this.getDistributionForKey(cache, key).segmentId();
    }

    private Cache<String, Object> findPrimaryOwner(String key) {
        for (Cache c : this.caches(LON)) {
            if (!this.getDistributionForKey(c, key).isPrimary()) continue;
            return c;
        }
        throw new IllegalStateException(String.format("Unable to find primary owner for key %s", key));
    }

    private boolean isNotWriteOwner(Cache<String, Object> cache, String key) {
        return !this.getDistributionForKey(cache, key).isWriteOwner();
    }

    private static enum TxMode {
        NON_TX,
        OPT_TX,
        PES_TX;

    }

    private static class ManualIracVersionGenerator
    extends ControlledIracVersionGenerator {
        private volatile IracMetadata metadata;

        public ManualIracVersionGenerator(IracVersionGenerator actual) {
            super(actual);
        }

        @Override
        public IracMetadata generateNewMetadata(int segment) {
            return this.metadata;
        }

        @Override
        public IracMetadata generateNewMetadata(int segment, IracEntryVersion versionSeen) {
            return this.metadata;
        }
    }
}

