/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager.impl;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.security.auth.Subject;
import org.infinispan.commons.TimeoutException;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.manager.ClusterExecutionPolicy;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.impl.FailOverClusterExecutor;
import org.infinispan.manager.impl.UnwrappingEmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.security.Security;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.function.TriConsumer;

class LocalClusterExecutor
implements ClusterExecutor {
    protected final Predicate<? super Address> predicate;
    protected final EmbeddedCacheManager manager;
    protected final long time;
    protected final TimeUnit unit;
    protected final BlockingManager blockingManager;
    protected final ScheduledExecutorService timeoutExecutor;

    LocalClusterExecutor(Predicate<? super Address> predicate, EmbeddedCacheManager manager, BlockingManager blockingManager, long time, TimeUnit unit, ScheduledExecutorService timeoutExecutor) {
        this.predicate = predicate;
        this.manager = new UnwrappingEmbeddedCacheManager(Objects.requireNonNull(manager));
        this.blockingManager = Objects.requireNonNull(blockingManager);
        if (time <= 0L) {
            throw new IllegalArgumentException("time must be greater than 0");
        }
        this.time = time;
        this.unit = Objects.requireNonNull(unit);
        this.timeoutExecutor = Objects.requireNonNull(timeoutExecutor);
    }

    Address getMyAddress() {
        return null;
    }

    @Override
    public void execute(Runnable command) {
        this.blockingManager.runBlocking(command, this.getClass().getSimpleName() + "-execute");
    }

    @Override
    public CompletableFuture<Void> submit(Runnable command) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.blockingManager.runBlocking(command, this.getClass().getSimpleName() + "-submit").whenComplete((ignore, t) -> {
            if (t != null) {
                future.completeExceptionally(CompletableFutures.extractException((Throwable)t));
            } else {
                future.complete(null);
            }
        });
        ScheduledFuture<Boolean> scheduledFuture = this.timeoutExecutor.schedule(() -> future.completeExceptionally(new TimeoutException()), this.time, this.unit);
        future.whenComplete((v, t) -> scheduledFuture.cancel(true));
        return future;
    }

    @Override
    public <V> CompletableFuture<Void> submitConsumer(Function<? super EmbeddedCacheManager, ? extends V> callable, TriConsumer<? super Address, ? super V, ? super Throwable> triConsumer) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.localInvocation(callable).whenComplete((r, t) -> {
            try {
                triConsumer.accept(this.getMyAddress(), (Object)r, CompletableFutures.extractException((Throwable)t));
                future.complete(null);
            }
            catch (Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        });
        ScheduledFuture<Boolean> scheduledFuture = this.timeoutExecutor.schedule(() -> future.completeExceptionally(new TimeoutException()), this.time, this.unit);
        future.whenComplete((v, t) -> scheduledFuture.cancel(true));
        return future;
    }

    <T> CompletableFuture<T> localInvocation(Function<? super EmbeddedCacheManager, ? extends T> function) {
        Subject subject = Security.getSubject();
        return this.blockingManager.supplyBlocking(() -> Security.doAs(subject, function, this.manager), this.getClass().getSimpleName() + "local-invocation").toCompletableFuture();
    }

    protected ClusterExecutor sameClusterExecutor(Predicate<? super Address> predicate, long time, TimeUnit unit) {
        return new LocalClusterExecutor(predicate, this.manager, this.blockingManager, time, unit, this.timeoutExecutor);
    }

    @Override
    public ClusterExecutor timeout(long time, TimeUnit unit) {
        if (time <= 0L) {
            throw new IllegalArgumentException("Time must be greater than 0!");
        }
        Objects.requireNonNull(unit, "TimeUnit must be non null!");
        if (this.time == time && this.unit == unit) {
            return this;
        }
        return this.sameClusterExecutor(this.predicate, time, unit);
    }

    @Override
    public ClusterExecutor filterTargets(Predicate<? super Address> predicate) {
        return this.sameClusterExecutor(predicate, this.time, this.unit);
    }

    @Override
    public ClusterExecutor filterTargets(ClusterExecutionPolicy policy) throws IllegalStateException {
        throw new IllegalStateException();
    }

    @Override
    public ClusterExecutor filterTargets(ClusterExecutionPolicy policy, Predicate<? super Address> predicate) throws IllegalStateException {
        throw new IllegalStateException();
    }

    @Override
    public ClusterExecutor filterTargets(Collection<Address> addresses) {
        return this.filterTargets(addresses::contains);
    }

    @Override
    public ClusterExecutor noFilter() {
        if (this.predicate == null) {
            return this;
        }
        return this.sameClusterExecutor(null, this.time, this.unit);
    }

    @Override
    public ClusterExecutor singleNodeSubmission() {
        return this;
    }

    @Override
    public ClusterExecutor singleNodeSubmission(int failOverCount) {
        return new FailOverClusterExecutor(this, failOverCount);
    }

    @Override
    public ClusterExecutor allNodeSubmission() {
        return this;
    }
}

