/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.protostream.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.infinispan.commons.GlobalContextInitializerImpl;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.UserContextInitializerImpl;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.marshall.persistence.impl.PersistenceContextInitializer;
import org.infinispan.marshall.persistence.impl.PersistenceContextInitializerImpl;
import org.infinispan.marshall.protostream.impl.MarshallableUserObject;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.types.java.CommonContainerTypesSchema;
import org.infinispan.protostream.types.java.CommonTypesSchema;

@Scope(value=Scopes.GLOBAL)
public class SerializationContextRegistryImpl
implements SerializationContextRegistry {
    @Inject
    GlobalConfiguration globalConfig;
    @Inject
    @ComponentName(value="org.infinispan.marshaller.user")
    ComponentRef<Marshaller> userMarshaller;
    private final MarshallerContext global = new MarshallerContext();
    private final MarshallerContext persistence = new MarshallerContext();
    private final MarshallerContext user = new MarshallerContext();

    @Start
    public void start() {
        this.global.addContextInitializer((SerializationContextInitializer)new CommonTypesSchema());
        this.global.addContextInitializer((SerializationContextInitializer)new CommonContainerTypesSchema());
        this.global.addContextInitializer((SerializationContextInitializer)new UserContextInitializerImpl());
        this.user.addContextInitializer((SerializationContextInitializer)new CommonTypesSchema());
        this.user.addContextInitializer((SerializationContextInitializer)new CommonContainerTypesSchema());
        this.user.addContextInitializer((SerializationContextInitializer)new UserContextInitializerImpl());
        Collection<Object> initializers = this.globalConfig.serialization().contextInitializers();
        if (initializers == null || initializers.isEmpty()) {
            initializers = ServiceFinder.load(SerializationContextInitializer.class, (ClassLoader[])new ClassLoader[]{this.globalConfig.classLoader()});
        }
        initializers.forEach(this.user::addContextInitializer);
        String messageName = PersistenceContextInitializer.getFqTypeName(MarshallableUserObject.class);
        MarshallableUserObject.Marshaller userObjectMarshaller = new MarshallableUserObject.Marshaller(messageName, this.userMarshaller.wired());
        this.update(SerializationContextRegistry.MarshallerType.GLOBAL, arg_0 -> SerializationContextRegistryImpl.lambda$start$0((BaseMarshaller)userObjectMarshaller, arg_0));
        this.update(SerializationContextRegistry.MarshallerType.PERSISTENCE, arg_0 -> SerializationContextRegistryImpl.lambda$start$1((BaseMarshaller)userObjectMarshaller, arg_0));
    }

    @Override
    public ImmutableSerializationContext getGlobalCtx() {
        return this.global.ctx;
    }

    @Override
    public ImmutableSerializationContext getPersistenceCtx() {
        return this.persistence.ctx;
    }

    @Override
    public ImmutableSerializationContext getUserCtx() {
        return this.user.ctx;
    }

    @Override
    public void addContextInitializer(SerializationContextRegistry.MarshallerType type, SerializationContextInitializer sci) {
        this.update(type, ctx -> {
            ctx.addContextInitializer(sci);
            ctx.marshallers.forEach(arg_0 -> ((SerializationContext)ctx.ctx).registerMarshaller(arg_0));
        });
    }

    @Override
    public void addProtoFile(SerializationContextRegistry.MarshallerType type, FileDescriptorSource fileDescriptorSource) {
        this.update(type, ctx -> ctx.addProtoFile(fileDescriptorSource));
    }

    @Override
    public void removeProtoFile(SerializationContextRegistry.MarshallerType type, String fileName) {
        this.update(type, ctx -> ctx.removeProtoFile(fileName));
    }

    @Override
    public void addMarshaller(SerializationContextRegistry.MarshallerType type, BaseMarshaller marshaller) {
        this.update(type, ctx -> ctx.addMarshaller(marshaller));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(SerializationContextRegistry.MarshallerType type, Consumer<MarshallerContext> consumer) {
        MarshallerContext ctx;
        MarshallerContext marshallerContext = ctx = type == SerializationContextRegistry.MarshallerType.GLOBAL ? this.global : (type == SerializationContextRegistry.MarshallerType.PERSISTENCE ? this.persistence : this.user);
        synchronized (marshallerContext) {
            consumer.accept(ctx);
        }
    }

    private static void register(SerializationContextInitializer sci, SerializationContext ctx) {
        sci.registerSchema(ctx);
        sci.registerMarshallers(ctx);
    }

    private static /* synthetic */ void lambda$start$1(BaseMarshaller userObjectMarshaller, MarshallerContext ctx) {
        ctx.addContextInitializer(new PersistenceContextInitializerImpl()).addMarshaller(userObjectMarshaller);
    }

    private static /* synthetic */ void lambda$start$0(BaseMarshaller userObjectMarshaller, MarshallerContext ctx) {
        ctx.addContextInitializer(new PersistenceContextInitializerImpl()).addContextInitializer((SerializationContextInitializer)new GlobalContextInitializerImpl()).addMarshaller(userObjectMarshaller);
    }

    private static final class MarshallerContext {
        private final List<BaseMarshaller<?>> marshallers = new ArrayList();
        private final SerializationContext ctx = ProtobufUtil.newSerializationContext();

        private MarshallerContext() {
        }

        MarshallerContext addContextInitializer(SerializationContextInitializer sci) {
            SerializationContextRegistryImpl.register(sci, this.ctx);
            return this;
        }

        MarshallerContext addProtoFile(FileDescriptorSource fileDescriptorSource) {
            this.ctx.registerProtoFiles(fileDescriptorSource);
            return this;
        }

        MarshallerContext removeProtoFile(String fileName) {
            this.ctx.unregisterProtoFile(fileName);
            return this;
        }

        MarshallerContext addMarshaller(BaseMarshaller marshaller) {
            this.marshallers.add(marshaller);
            this.ctx.registerMarshaller(marshaller);
            return this;
        }
    }
}

