/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.AdvancedCache;
import org.infinispan.cache.impl.SimpleCacheImpl;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.ByRef;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.metadata.Metadata;
import org.infinispan.stats.Stats;
import org.infinispan.stats.impl.StatsCollector;
import org.infinispan.stats.impl.StatsImpl;

public class StatsCollectingCache<K, V>
extends SimpleCacheImpl<K, V> {
    @Inject
    StatsCollector statsCollector;
    @Inject
    TimeService timeService;

    public StatsCollectingCache(String cacheName) {
        super(cacheName);
    }

    @Override
    public AdvancedCache<K, V> withFlags(Flag ... flags) {
        return this;
    }

    @Override
    public Stats getStats() {
        return StatsImpl.create(this.statsCollector);
    }

    @Override
    public V get(Object key) {
        boolean statisticsEnabled = this.statsCollector.getStatisticsEnabled();
        long start = 0L;
        if (statisticsEnabled) {
            start = this.timeService.time();
        }
        Object value = super.get(key);
        if (statisticsEnabled) {
            long end = this.timeService.time();
            if (value == null) {
                this.statsCollector.recordMisses(1, end - start);
            } else {
                this.statsCollector.recordHits(1, end - start);
            }
        }
        return value;
    }

    @Override
    public CacheEntry<K, V> getCacheEntry(Object k) {
        boolean statisticsEnabled = this.statsCollector.getStatisticsEnabled();
        long start = 0L;
        if (statisticsEnabled) {
            start = this.timeService.time();
        }
        CacheEntry entry = super.getCacheEntry(k);
        if (statisticsEnabled) {
            long end = this.timeService.time();
            if (entry == null) {
                this.statsCollector.recordMisses(1, end - start);
            } else {
                this.statsCollector.recordHits(1, end - start);
            }
        }
        return entry;
    }

    @Override
    public Map<K, V> getAll(Set<?> keys) {
        boolean statisticsEnabled = this.statsCollector.getStatisticsEnabled();
        long start = 0L;
        if (statisticsEnabled) {
            start = this.timeService.time();
        }
        Map map = super.getAll(keys);
        if (statisticsEnabled) {
            long end = this.timeService.time();
            int requests = keys.size();
            int hits = 0;
            for (Object value : map.values()) {
                if (value == null) continue;
                ++hits;
            }
            int misses = requests - hits;
            if (hits > 0) {
                this.statsCollector.recordHits(hits, (long)hits * (end - start) / (long)requests);
            }
            if (misses > 0) {
                this.statsCollector.recordMisses(misses, (long)misses * (end - start) / (long)requests);
            }
        }
        return map;
    }

    @Override
    public Map<K, CacheEntry<K, V>> getAllCacheEntries(Set<?> keys) {
        boolean statisticsEnabled = this.statsCollector.getStatisticsEnabled();
        long start = 0L;
        if (statisticsEnabled) {
            start = this.timeService.time();
        }
        Map map = super.getAllCacheEntries(keys);
        if (statisticsEnabled) {
            long end = this.timeService.time();
            int requests = keys.size();
            int hits = 0;
            for (CacheEntry entry : map.values()) {
                if (entry == null || entry.getValue() == null) continue;
                ++hits;
            }
            int misses = requests - hits;
            if (hits > 0) {
                this.statsCollector.recordHits(hits, (long)hits * (end - start) / (long)requests);
            }
            if (misses > 0) {
                this.statsCollector.recordMisses(misses, (long)misses * (end - start) / (long)requests);
            }
        }
        return map;
    }

    @Override
    public Map<K, V> getAndPutAll(Map<? extends K, ? extends V> entries) {
        boolean statisticsEnabled = this.statsCollector.getStatisticsEnabled();
        long start = 0L;
        if (statisticsEnabled) {
            start = this.timeService.time();
        }
        Map<? extends K, ? extends V> map = super.getAndPutAll(entries);
        if (statisticsEnabled) {
            long end = this.timeService.time();
            this.statsCollector.recordStores(entries.size(), end - start);
        }
        return map;
    }

    @Override
    public void evict(K key) {
        super.evict(key);
        this.statsCollector.recordEviction();
    }

    @Override
    protected V getAndPutInternal(K key, V value, Metadata metadata) {
        boolean statisticsEnabled = this.statsCollector.getStatisticsEnabled();
        long start = 0L;
        if (statisticsEnabled) {
            start = this.timeService.time();
        }
        V ret = super.getAndPutInternal(key, value, metadata);
        if (statisticsEnabled) {
            long end = this.timeService.time();
            this.statsCollector.recordStores(1, end - start);
        }
        return ret;
    }

    @Override
    protected V getAndReplaceInternal(K key, V value, Metadata metadata) {
        boolean statisticsEnabled = this.statsCollector.getStatisticsEnabled();
        long start = 0L;
        if (statisticsEnabled) {
            start = this.timeService.time();
        }
        V ret = super.getAndReplaceInternal(key, value, metadata);
        if (statisticsEnabled && ret != null) {
            long end = this.timeService.time();
            this.statsCollector.recordStores(1, end - start);
        }
        return ret;
    }

    @Override
    protected void putForExternalReadInternal(K key, V value, Metadata metadata, ByRef.Boolean isCreatedRef) {
        boolean statisticsEnabled = this.statsCollector.getStatisticsEnabled();
        long start = 0L;
        if (statisticsEnabled) {
            start = this.timeService.time();
        }
        super.putForExternalReadInternal(key, value, metadata, isCreatedRef);
        if (statisticsEnabled && isCreatedRef.get()) {
            long end = this.timeService.time();
            this.statsCollector.recordStores(1, end - start);
        }
    }

    @Override
    protected V putIfAbsentInternal(K key, V value, Metadata metadata) {
        boolean statisticsEnabled = this.statsCollector.getStatisticsEnabled();
        long start = 0L;
        if (statisticsEnabled) {
            start = this.timeService.time();
        }
        V ret = super.putIfAbsentInternal(key, value, metadata);
        if (statisticsEnabled && ret == null) {
            long end = this.timeService.time();
            this.statsCollector.recordStores(1, end - start);
        }
        return ret;
    }

    @Override
    public V remove(Object key) {
        boolean statisticsEnabled = this.statsCollector.getStatisticsEnabled();
        long start = 0L;
        if (statisticsEnabled) {
            start = this.timeService.time();
        }
        Object ret = super.remove(key);
        if (statisticsEnabled) {
            long end = this.timeService.time();
            if (ret != null) {
                this.statsCollector.recordRemoveHits(1, end - start);
            } else {
                this.statsCollector.recordRemoveMisses(1);
            }
        }
        return ret;
    }

    @Override
    public boolean remove(Object key, Object value) {
        boolean statisticsEnabled = this.statsCollector.getStatisticsEnabled();
        long start = 0L;
        if (statisticsEnabled) {
            start = this.timeService.time();
        }
        boolean removed = super.remove(key, value);
        if (statisticsEnabled) {
            long end = this.timeService.time();
            if (removed) {
                this.statsCollector.recordRemoveHits(1, end - start);
            } else {
                this.statsCollector.recordRemoveMisses(1);
            }
        }
        return removed;
    }

    @Override
    protected boolean replaceInternal(K key, V oldValue, V value, Metadata metadata) {
        boolean statisticsEnabled = this.statsCollector.getStatisticsEnabled();
        long start = 0L;
        if (statisticsEnabled) {
            start = this.timeService.time();
        }
        boolean replaced = super.replaceInternal(key, oldValue, value, metadata);
        if (statisticsEnabled && replaced) {
            long end = this.timeService.time();
            this.statsCollector.recordStores(1, end - start);
        }
        return replaced;
    }

    @Override
    protected V computeIfAbsentInternal(K key, Function<? super K, ? extends V> mappingFunction, ByRef<V> newValueRef) {
        boolean statisticsEnabled = this.statsCollector.getStatisticsEnabled();
        long start = 0L;
        if (statisticsEnabled) {
            start = this.timeService.time();
        }
        V ret = super.computeIfAbsentInternal(key, mappingFunction, newValueRef);
        if (statisticsEnabled) {
            long end = this.timeService.time();
            if (newValueRef.get() != null) {
                this.statsCollector.recordStores(1, end - start);
            }
        }
        return ret;
    }

    @Override
    protected V computeIfPresentInternal(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, SimpleCacheImpl.CacheEntryChange<K, V> ref) {
        boolean statisticsEnabled = this.statsCollector.getStatisticsEnabled();
        long start = 0L;
        if (statisticsEnabled) {
            start = this.timeService.time();
        }
        V ret = super.computeIfPresentInternal(key, remappingFunction, ref);
        if (statisticsEnabled) {
            long end = this.timeService.time();
            if (ref.getNewValue() != null) {
                this.statsCollector.recordStores(1, end - start);
            } else if (ref.getKey() != null) {
                this.statsCollector.recordRemoveHits(1, end - start);
            }
        }
        return ret;
    }

    @Override
    protected V computeInternal(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, SimpleCacheImpl.CacheEntryChange<K, V> ref) {
        boolean statisticsEnabled = this.statsCollector.getStatisticsEnabled();
        long start = 0L;
        if (statisticsEnabled) {
            start = this.timeService.time();
        }
        V ret = super.computeInternal(key, remappingFunction, ref);
        if (statisticsEnabled) {
            long end = this.timeService.time();
            if (ref.getNewValue() != null) {
                this.statsCollector.recordStores(1, end - start);
            } else if (ref.getKey() != null) {
                this.statsCollector.recordRemoveHits(1, end - start);
            }
        }
        return ret;
    }

    @Override
    protected V mergeInternal(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, SimpleCacheImpl.CacheEntryChange<K, V> ref, Metadata metadata) {
        boolean statisticsEnabled = this.statsCollector.getStatisticsEnabled();
        long start = 0L;
        if (statisticsEnabled) {
            start = this.timeService.time();
        }
        V ret = super.mergeInternal(key, value, remappingFunction, ref, metadata);
        if (statisticsEnabled) {
            long end = this.timeService.time();
            if (ref.getNewValue() != null) {
                this.statsCollector.recordStores(1, end - start);
            } else if (ref.getKey() != null) {
                this.statsCollector.recordRemoveHits(1, end - start);
            }
        }
        return ret;
    }

    @Override
    public String toString() {
        return "StatsCollectingCache '" + this.getName() + "'";
    }
}

