/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.remoting.transport.jgroups.FileJGroupsChannelConfigurator;
import org.infinispan.util.logging.Log;

public class BuiltinJGroupsChannelConfigurator
extends FileJGroupsChannelConfigurator {
    public static final String TCP_STACK_NAME = "tcp";

    public static BuiltinJGroupsChannelConfigurator TCP(Properties properties) {
        return BuiltinJGroupsChannelConfigurator.loadBuiltIn(TCP_STACK_NAME, "default-configs/default-jgroups-tcp.xml", properties);
    }

    public static BuiltinJGroupsChannelConfigurator UDP(Properties properties) {
        return BuiltinJGroupsChannelConfigurator.loadBuiltIn("udp", "default-configs/default-jgroups-udp.xml", properties);
    }

    public static BuiltinJGroupsChannelConfigurator KUBERNETES(Properties properties) {
        return BuiltinJGroupsChannelConfigurator.loadBuiltIn("kubernetes", "default-configs/default-jgroups-kubernetes.xml", properties);
    }

    public static BuiltinJGroupsChannelConfigurator EC2(Properties properties) {
        return BuiltinJGroupsChannelConfigurator.loadBuiltIn("ec2", "default-configs/default-jgroups-ec2.xml", properties);
    }

    public static BuiltinJGroupsChannelConfigurator GOOGLE(Properties properties) {
        return BuiltinJGroupsChannelConfigurator.loadBuiltIn("google", "default-configs/default-jgroups-google.xml", properties);
    }

    public static BuiltinJGroupsChannelConfigurator AZURE(Properties properties) {
        return BuiltinJGroupsChannelConfigurator.loadBuiltIn("azure", "default-configs/default-jgroups-azure.xml", properties);
    }

    public static BuiltinJGroupsChannelConfigurator TUNNEL(Properties properties) {
        return BuiltinJGroupsChannelConfigurator.loadBuiltIn("tunnel", "default-configs/default-jgroups-tunnel.xml", properties);
    }

    private static BuiltinJGroupsChannelConfigurator loadBuiltIn(String name, String path, Properties properties) {
        BuiltinJGroupsChannelConfigurator builtinJGroupsChannelConfigurator;
        block8: {
            InputStream xml = FileLookupFactory.newInstance().lookupFileStrict(path, BuiltinJGroupsChannelConfigurator.class.getClassLoader());
            try {
                builtinJGroupsChannelConfigurator = new BuiltinJGroupsChannelConfigurator(name, path, xml, properties);
                if (xml == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (xml != null) {
                        try {
                            xml.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Log.CONFIG.jgroupsConfigurationNotFound(path);
                }
            }
            xml.close();
        }
        return builtinJGroupsChannelConfigurator;
    }

    BuiltinJGroupsChannelConfigurator(String name, String path, InputStream is, Properties properties) throws IOException {
        super(name, path, is, properties);
    }
}

