package org.infinispan.remoting.transport.jgroups;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.processing.Generated;
import org.infinispan.commons.stat.GaugeMetricInfo;
import org.infinispan.commons.stat.MetricInfo;
import org.jgroups.stack.Protocol;

@Generated(value = "org.infinispan.component.processor.external.JGroupsComponentProcessor")
public class JGroupsMetricsMetadata {
   public static final Map<Class<? extends Protocol>, Collection<MetricInfo>> PROTOCOL_METADATA = new HashMap<>();
   private JGroupsMetricsMetadata() {}
   static {
      List<MetricInfo> attributes;
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.FD_SOCK>("getClientBindPortActual", "The actual client_bind_port", null, org.jgroups.protocols.FD_SOCK::getClientBindPortActual));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.FD_SOCK>("getNumSuspectEventsGenerated", "Number of suspect event generated", null, org.jgroups.protocols.FD_SOCK::getNumSuspectEventsGenerated));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.FD_SOCK>("getNumSuspectedMembers", "The number of currently suspected members", null, org.jgroups.protocols.FD_SOCK::getNumSuspectedMembers));
      PROTOCOL_METADATA.put(org.jgroups.protocols.FD_SOCK.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.FRAG>("getNumberOfReceivedFragments", "Number of received fragments", null, org.jgroups.protocols.FRAG::getNumberOfReceivedFragments));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.FRAG>("getNumberOfSentFragments", "Number of sent fragments", null, org.jgroups.protocols.FRAG::getNumberOfSentFragments));
      PROTOCOL_METADATA.put(org.jgroups.protocols.FRAG.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.FRAG2>("getNumberOfReceivedFragments", "Number of received fragments", null, org.jgroups.protocols.FRAG2::getNumberOfReceivedFragments));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.FRAG2>("getNumberOfSentFragments", "Number of sent fragments", null, org.jgroups.protocols.FRAG2::getNumberOfSentFragments));
      PROTOCOL_METADATA.put(org.jgroups.protocols.FRAG2.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.GMS>("getViewHandlerSize", "", null, org.jgroups.protocols.pbcast.GMS::getViewHandlerSize));
      PROTOCOL_METADATA.put(org.jgroups.protocols.pbcast.GMS.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.STABLE>("getNumVotes", "The number of votes for the current digest", null, org.jgroups.protocols.pbcast.STABLE::getNumVotes));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.STABLE>("getStabilityReceived", "", null, org.jgroups.protocols.pbcast.STABLE::getStabilityReceived));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.STABLE>("getStabilitySent", "", null, org.jgroups.protocols.pbcast.STABLE::getStabilitySent));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.STABLE>("getStableReceived", "", null, org.jgroups.protocols.pbcast.STABLE::getStableReceived));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.STABLE>("getStableSent", "", null, org.jgroups.protocols.pbcast.STABLE::getStableSent));
      PROTOCOL_METADATA.put(org.jgroups.protocols.pbcast.STABLE.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.STATE_TRANSFER>("getAverageStateSize", "", null, org.jgroups.protocols.pbcast.STATE_TRANSFER::getAverageStateSize));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.STATE_TRANSFER>("getNumberOfStateBytesSent", "", null, org.jgroups.protocols.pbcast.STATE_TRANSFER::getNumberOfStateBytesSent));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.STATE_TRANSFER>("getNumberOfStateRequests", "", null, org.jgroups.protocols.pbcast.STATE_TRANSFER::getNumberOfStateRequests));
      PROTOCOL_METADATA.put(org.jgroups.protocols.pbcast.STATE_TRANSFER.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.COMPRESS>("getNumCompressions", "Number of compressions", null, org.jgroups.protocols.COMPRESS::getNumCompressions));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.COMPRESS>("getNumUncompressions", "Number of un-compressions", null, org.jgroups.protocols.COMPRESS::getNumUncompressions));
      PROTOCOL_METADATA.put(org.jgroups.protocols.COMPRESS.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UDP>("getDifferentClusterMessages", "Number of messages from members in a different cluster", null, org.jgroups.protocols.UDP::getDifferentClusterMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UDP>("getDifferentVersionMessages", "Number of messages from members with a different JGroups version", null, org.jgroups.protocols.UDP::getDifferentVersionMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UDP>("getDroppedMessages", "Number of messages dropped when sending because of insufficient buffer space", null, org.jgroups.protocols.UDP::getDroppedMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UDP>("getNumMcastMsgsReceived", "", null, org.jgroups.protocols.UDP::getNumMcastMsgsReceived));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UDP>("getNumMcastMsgsSent", "", null, org.jgroups.protocols.UDP::getNumMcastMsgsSent));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UDP>("getNumRejectedMsgs", "", null, org.jgroups.protocols.UDP::getNumRejectedMsgs));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UDP>("getNumTimerTasks", "Number of timer tasks queued up for execution", null, org.jgroups.protocols.UDP::getNumTimerTasks));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UDP>("getNumUcastMsgsReceived", "", null, org.jgroups.protocols.UDP::getNumUcastMsgsReceived));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UDP>("getNumUcastMsgsSent", "", null, org.jgroups.protocols.UDP::getNumUcastMsgsSent));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UDP>("getTimerThreads", "Number of threads currently in the pool", null, org.jgroups.protocols.UDP::getTimerThreads));
      attributes.add(new GaugeMetricInfo<>("getLargestSize", "Largest number of threads in the thread pool", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getThreadPool().getLargestSize())));
      attributes.add(new GaugeMetricInfo<>("getThreadPoolSize", "Current number of threads in the thread pool", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getThreadPool().getThreadPoolSize())));
      attributes.add(new GaugeMetricInfo<>("getThreadPoolSizeActive", "Current number of active threads in the thread pool", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getThreadPool().getThreadPoolSizeActive())));
      attributes.add(new GaugeMetricInfo<>("getNumBatchesReceived", "Number of batches received (by the transport)", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumBatchesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumBatchesSent", "Number of batches sent (by the bundler)", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumBatchesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumBytesReceived", "Total number of bytes received (unicast + multicast)", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumBytesSent", "Total number of bytes sent (unicast + multicast bytes)", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastBytesReceived", "Number of multicast bytes received", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumMcastBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastBytesSent", "Number of multicast bytes sent", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumMcastBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastsReceived", "Total number of multicast messages received", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumMcastsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastsSent", "Number of multicast messages sent", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumMcastsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumMsgsReceived", "Number of messages received (mcasts and ucasts received)", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumMsgsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMsgsSent", "Number of messages sent (mcasts and ucasts sent)", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumSingleMsgsSent", "Number of single messages sent (by the bundler)", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumSingleMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastBytesReceived", "Number of unicast bytes received", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumUcastBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastBytesSent", "Number of unicast bytes sent", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumUcastBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastsReceived", "Number of unicast messages received", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumUcastsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastsSent", "Number of unicast messages sent", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumUcastsSent())));
      PROTOCOL_METADATA.put(org.jgroups.protocols.UDP.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TCP>("getDifferentClusterMessages", "Number of messages from members in a different cluster", null, org.jgroups.protocols.TCP::getDifferentClusterMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TCP>("getDifferentVersionMessages", "Number of messages from members with a different JGroups version", null, org.jgroups.protocols.TCP::getDifferentVersionMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TCP>("getNumMcastMsgsReceived", "", null, org.jgroups.protocols.TCP::getNumMcastMsgsReceived));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TCP>("getNumMcastMsgsSent", "", null, org.jgroups.protocols.TCP::getNumMcastMsgsSent));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TCP>("getNumRejectedMsgs", "", null, org.jgroups.protocols.TCP::getNumRejectedMsgs));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TCP>("getNumTimerTasks", "Number of timer tasks queued up for execution", null, org.jgroups.protocols.TCP::getNumTimerTasks));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TCP>("getNumUcastMsgsReceived", "", null, org.jgroups.protocols.TCP::getNumUcastMsgsReceived));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TCP>("getNumUcastMsgsSent", "", null, org.jgroups.protocols.TCP::getNumUcastMsgsSent));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TCP>("getOpenConnections", "", null, org.jgroups.protocols.TCP::getOpenConnections));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TCP>("getTimerThreads", "Number of threads currently in the pool", null, org.jgroups.protocols.TCP::getTimerThreads));
      attributes.add(new GaugeMetricInfo<>("getLargestSize", "Largest number of threads in the thread pool", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getThreadPool().getLargestSize())));
      attributes.add(new GaugeMetricInfo<>("getThreadPoolSize", "Current number of threads in the thread pool", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getThreadPool().getThreadPoolSize())));
      attributes.add(new GaugeMetricInfo<>("getThreadPoolSizeActive", "Current number of active threads in the thread pool", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getThreadPool().getThreadPoolSizeActive())));
      attributes.add(new GaugeMetricInfo<>("getNumBatchesReceived", "Number of batches received (by the transport)", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumBatchesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumBatchesSent", "Number of batches sent (by the bundler)", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumBatchesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumBytesReceived", "Total number of bytes received (unicast + multicast)", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumBytesSent", "Total number of bytes sent (unicast + multicast bytes)", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastBytesReceived", "Number of multicast bytes received", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumMcastBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastBytesSent", "Number of multicast bytes sent", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumMcastBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastsReceived", "Total number of multicast messages received", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumMcastsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastsSent", "Number of multicast messages sent", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumMcastsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumMsgsReceived", "Number of messages received (mcasts and ucasts received)", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumMsgsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMsgsSent", "Number of messages sent (mcasts and ucasts sent)", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumSingleMsgsSent", "Number of single messages sent (by the bundler)", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumSingleMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastBytesReceived", "Number of unicast bytes received", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumUcastBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastBytesSent", "Number of unicast bytes sent", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumUcastBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastsReceived", "Number of unicast messages received", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumUcastsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastsSent", "Number of unicast messages sent", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumUcastsSent())));
      PROTOCOL_METADATA.put(org.jgroups.protocols.TCP.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TUNNEL>("getDifferentClusterMessages", "Number of messages from members in a different cluster", null, org.jgroups.protocols.TUNNEL::getDifferentClusterMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TUNNEL>("getDifferentVersionMessages", "Number of messages from members with a different JGroups version", null, org.jgroups.protocols.TUNNEL::getDifferentVersionMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TUNNEL>("getNumMcastMsgsReceived", "", null, org.jgroups.protocols.TUNNEL::getNumMcastMsgsReceived));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TUNNEL>("getNumMcastMsgsSent", "", null, org.jgroups.protocols.TUNNEL::getNumMcastMsgsSent));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TUNNEL>("getNumRejectedMsgs", "", null, org.jgroups.protocols.TUNNEL::getNumRejectedMsgs));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TUNNEL>("getNumTimerTasks", "Number of timer tasks queued up for execution", null, org.jgroups.protocols.TUNNEL::getNumTimerTasks));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TUNNEL>("getNumUcastMsgsReceived", "", null, org.jgroups.protocols.TUNNEL::getNumUcastMsgsReceived));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TUNNEL>("getNumUcastMsgsSent", "", null, org.jgroups.protocols.TUNNEL::getNumUcastMsgsSent));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TUNNEL>("getTimerThreads", "Number of threads currently in the pool", null, org.jgroups.protocols.TUNNEL::getTimerThreads));
      attributes.add(new GaugeMetricInfo<>("getLargestSize", "Largest number of threads in the thread pool", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getThreadPool().getLargestSize())));
      attributes.add(new GaugeMetricInfo<>("getThreadPoolSize", "Current number of threads in the thread pool", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getThreadPool().getThreadPoolSize())));
      attributes.add(new GaugeMetricInfo<>("getThreadPoolSizeActive", "Current number of active threads in the thread pool", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getThreadPool().getThreadPoolSizeActive())));
      attributes.add(new GaugeMetricInfo<>("getNumBatchesReceived", "Number of batches received (by the transport)", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumBatchesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumBatchesSent", "Number of batches sent (by the bundler)", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumBatchesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumBytesReceived", "Total number of bytes received (unicast + multicast)", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumBytesSent", "Total number of bytes sent (unicast + multicast bytes)", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastBytesReceived", "Number of multicast bytes received", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumMcastBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastBytesSent", "Number of multicast bytes sent", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumMcastBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastsReceived", "Total number of multicast messages received", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumMcastsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastsSent", "Number of multicast messages sent", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumMcastsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumMsgsReceived", "Number of messages received (mcasts and ucasts received)", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumMsgsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMsgsSent", "Number of messages sent (mcasts and ucasts sent)", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumSingleMsgsSent", "Number of single messages sent (by the bundler)", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumSingleMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastBytesReceived", "Number of unicast bytes received", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumUcastBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastBytesSent", "Number of unicast bytes sent", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumUcastBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastsReceived", "Number of unicast messages received", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumUcastsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastsSent", "Number of unicast messages sent", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumUcastsSent())));
      PROTOCOL_METADATA.put(org.jgroups.protocols.TUNNEL.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.SEQUENCER>("getForwardTableSize", "Number of messages in the forward-table", null, org.jgroups.protocols.SEQUENCER::getForwardTableSize));
      PROTOCOL_METADATA.put(org.jgroups.protocols.SEQUENCER.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.STATE>("getAverageStateSize", "", null, org.jgroups.protocols.pbcast.STATE::getAverageStateSize));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.STATE>("getNumberOfStateBytesSent", "", null, org.jgroups.protocols.pbcast.STATE::getNumberOfStateBytesSent));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.STATE>("getNumberOfStateRequests", "", null, org.jgroups.protocols.pbcast.STATE::getNumberOfStateRequests));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.STATE>("getThreadPoolCompletedTasks", "", null, org.jgroups.protocols.pbcast.STATE::getThreadPoolCompletedTasks));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.STATE>("getThreadPoolSize", "", null, org.jgroups.protocols.pbcast.STATE::getThreadPoolSize));
      PROTOCOL_METADATA.put(org.jgroups.protocols.pbcast.STATE.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.STATE_SOCK>("getAverageStateSize", "", null, org.jgroups.protocols.pbcast.STATE_SOCK::getAverageStateSize));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.STATE_SOCK>("getNumberOfStateBytesSent", "", null, org.jgroups.protocols.pbcast.STATE_SOCK::getNumberOfStateBytesSent));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.STATE_SOCK>("getNumberOfStateRequests", "", null, org.jgroups.protocols.pbcast.STATE_SOCK::getNumberOfStateRequests));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.STATE_SOCK>("getThreadPoolCompletedTasks", "", null, org.jgroups.protocols.pbcast.STATE_SOCK::getThreadPoolCompletedTasks));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.STATE_SOCK>("getThreadPoolSize", "", null, org.jgroups.protocols.pbcast.STATE_SOCK::getThreadPoolSize));
      PROTOCOL_METADATA.put(org.jgroups.protocols.pbcast.STATE_SOCK.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.SHARED_LOOPBACK>("getDifferentClusterMessages", "Number of messages from members in a different cluster", null, org.jgroups.protocols.SHARED_LOOPBACK::getDifferentClusterMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.SHARED_LOOPBACK>("getDifferentVersionMessages", "Number of messages from members with a different JGroups version", null, org.jgroups.protocols.SHARED_LOOPBACK::getDifferentVersionMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.SHARED_LOOPBACK>("getNumMcastMsgsReceived", "", null, org.jgroups.protocols.SHARED_LOOPBACK::getNumMcastMsgsReceived));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.SHARED_LOOPBACK>("getNumMcastMsgsSent", "", null, org.jgroups.protocols.SHARED_LOOPBACK::getNumMcastMsgsSent));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.SHARED_LOOPBACK>("getNumRejectedMsgs", "", null, org.jgroups.protocols.SHARED_LOOPBACK::getNumRejectedMsgs));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.SHARED_LOOPBACK>("getNumTimerTasks", "Number of timer tasks queued up for execution", null, org.jgroups.protocols.SHARED_LOOPBACK::getNumTimerTasks));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.SHARED_LOOPBACK>("getNumUcastMsgsReceived", "", null, org.jgroups.protocols.SHARED_LOOPBACK::getNumUcastMsgsReceived));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.SHARED_LOOPBACK>("getNumUcastMsgsSent", "", null, org.jgroups.protocols.SHARED_LOOPBACK::getNumUcastMsgsSent));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.SHARED_LOOPBACK>("getTimerThreads", "Number of threads currently in the pool", null, org.jgroups.protocols.SHARED_LOOPBACK::getTimerThreads));
      attributes.add(new GaugeMetricInfo<>("getLargestSize", "Largest number of threads in the thread pool", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getThreadPool().getLargestSize())));
      attributes.add(new GaugeMetricInfo<>("getThreadPoolSize", "Current number of threads in the thread pool", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getThreadPool().getThreadPoolSize())));
      attributes.add(new GaugeMetricInfo<>("getThreadPoolSizeActive", "Current number of active threads in the thread pool", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getThreadPool().getThreadPoolSizeActive())));
      attributes.add(new GaugeMetricInfo<>("getNumBatchesReceived", "Number of batches received (by the transport)", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumBatchesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumBatchesSent", "Number of batches sent (by the bundler)", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumBatchesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumBytesReceived", "Total number of bytes received (unicast + multicast)", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumBytesSent", "Total number of bytes sent (unicast + multicast bytes)", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastBytesReceived", "Number of multicast bytes received", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumMcastBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastBytesSent", "Number of multicast bytes sent", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumMcastBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastsReceived", "Total number of multicast messages received", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumMcastsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastsSent", "Number of multicast messages sent", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumMcastsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumMsgsReceived", "Number of messages received (mcasts and ucasts received)", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumMsgsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMsgsSent", "Number of messages sent (mcasts and ucasts sent)", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumSingleMsgsSent", "Number of single messages sent (by the bundler)", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumSingleMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastBytesReceived", "Number of unicast bytes received", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumUcastBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastBytesSent", "Number of unicast bytes sent", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumUcastBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastsReceived", "Number of unicast messages received", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumUcastsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastsSent", "Number of unicast messages sent", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumUcastsSent())));
      PROTOCOL_METADATA.put(org.jgroups.protocols.SHARED_LOOPBACK.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.MFC>("getAverageTimeBlocked", "Average time blocked (in ns) in flow control when trying to send a message", null, org.jgroups.protocols.MFC::getAverageTimeBlocked));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.MFC>("getNumberOfBlockings", "Number of times flow control blocks sender", null, org.jgroups.protocols.MFC::getNumberOfBlockings));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.MFC>("getNumberOfCreditRequestsReceived", "", null, org.jgroups.protocols.MFC::getNumberOfCreditRequestsReceived));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.MFC>("getNumberOfCreditRequestsSent", "", null, org.jgroups.protocols.MFC::getNumberOfCreditRequestsSent));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.MFC>("getNumberOfCreditResponsesReceived", "", null, org.jgroups.protocols.MFC::getNumberOfCreditResponsesReceived));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.MFC>("getNumberOfCreditResponsesSent", "", null, org.jgroups.protocols.MFC::getNumberOfCreditResponsesSent));
      PROTOCOL_METADATA.put(org.jgroups.protocols.MFC.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UFC>("getAverageTimeBlocked", "Average time blocked (in ms) in flow control when trying to send a message", null, org.jgroups.protocols.UFC::getAverageTimeBlocked));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UFC>("getNumberOfBlockings", "Number of times flow control blocks sender", null, org.jgroups.protocols.UFC::getNumberOfBlockings));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UFC>("getNumberOfCreditRequestsReceived", "", null, org.jgroups.protocols.UFC::getNumberOfCreditRequestsReceived));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UFC>("getNumberOfCreditRequestsSent", "", null, org.jgroups.protocols.UFC::getNumberOfCreditRequestsSent));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UFC>("getNumberOfCreditResponsesReceived", "", null, org.jgroups.protocols.UFC::getNumberOfCreditResponsesReceived));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UFC>("getNumberOfCreditResponsesSent", "", null, org.jgroups.protocols.UFC::getNumberOfCreditResponsesSent));
      PROTOCOL_METADATA.put(org.jgroups.protocols.UFC.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.STOMP>("getNumConnections", "Number of client connections", null, org.jgroups.protocols.STOMP::getNumConnections));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.STOMP>("getNumSubscriptions", "Number of subscriptions", null, org.jgroups.protocols.STOMP::getNumSubscriptions));
      PROTOCOL_METADATA.put(org.jgroups.protocols.STOMP.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.MERGE3>("getNumMergeEvents", "Number of times a MERGE event was sent up the stack", null, org.jgroups.protocols.MERGE3::getNumMergeEvents));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.MERGE3>("getViews", "Number of cached ViewIds", null, org.jgroups.protocols.MERGE3::getViews));
      PROTOCOL_METADATA.put(org.jgroups.protocols.MERGE3.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.RSVP>("getPendingRsvpRequests", "Number of pending RSVP requests", null, org.jgroups.protocols.RSVP::getPendingRsvpRequests));
      PROTOCOL_METADATA.put(org.jgroups.protocols.RSVP.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.NAKACK2>("getBecomeServerQueueSizeActual", "Actual size of the become_server_queue", null, org.jgroups.protocols.pbcast.NAKACK2::getBecomeServerQueueSizeActual));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.NAKACK2>("getCurrentSeqno", "", null, org.jgroups.protocols.pbcast.NAKACK2::getCurrentSeqno));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.NAKACK2>("getNonMemberMessages", "Number of messages from non-members", null, org.jgroups.protocols.pbcast.NAKACK2::getNonMemberMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.NAKACK2>("getNumMessagesReceived", "Number of messages received", null, org.jgroups.protocols.pbcast.NAKACK2::getNumMessagesReceived));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.NAKACK2>("getNumMessagesSent", "Number of messages sent", null, org.jgroups.protocols.pbcast.NAKACK2::getNumMessagesSent));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.NAKACK2>("getSizeOfAllMessages", "Returns the number of bytes of all messages in all retransmit buffers. To compute the size, Message.getLength() is used", null, org.jgroups.protocols.pbcast.NAKACK2::getSizeOfAllMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.NAKACK2>("getSizeOfAllMessagesInclHeaders", "Returns the number of bytes of all messages in all retransmit buffers. To compute the size, Message.size() is used", null, org.jgroups.protocols.pbcast.NAKACK2::getSizeOfAllMessagesInclHeaders));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.NAKACK2>("getXmitTableCapacity", "Capacity of the retransmit buffer. Computed as xmit_table_num_rows * xmit_table_msgs_per_row", null, org.jgroups.protocols.pbcast.NAKACK2::getXmitTableCapacity));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.NAKACK2>("getXmitTableMissingMessages", "Total number of missing (= not received) messages in all retransmit buffers", null, org.jgroups.protocols.pbcast.NAKACK2::getXmitTableMissingMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.NAKACK2>("getXmitTableNumCompactions", "Number of retransmit table compactions", null, org.jgroups.protocols.pbcast.NAKACK2::getXmitTableNumCompactions));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.NAKACK2>("getXmitTableNumCurrentRows", "Prints the number of rows currently allocated in the matrix. This value will not be lower than xmit_table_now_rows", null, org.jgroups.protocols.pbcast.NAKACK2::getXmitTableNumCurrentRows));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.NAKACK2>("getXmitTableNumMoves", "Number of retransmit table moves", null, org.jgroups.protocols.pbcast.NAKACK2::getXmitTableNumMoves));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.NAKACK2>("getXmitTableNumPurges", "Number of retransmit table purges", null, org.jgroups.protocols.pbcast.NAKACK2::getXmitTableNumPurges));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.NAKACK2>("getXmitTableNumResizes", "Number of retransmit table resizes", null, org.jgroups.protocols.pbcast.NAKACK2::getXmitTableNumResizes));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.pbcast.NAKACK2>("getXmitTableUndeliveredMsgs", "Total number of undelivered messages in all retransmit buffers", null, org.jgroups.protocols.pbcast.NAKACK2::getXmitTableUndeliveredMsgs));
      PROTOCOL_METADATA.put(org.jgroups.protocols.pbcast.NAKACK2.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.relay.RELAY2>("getAvgMsgsForwardingToLocalMbr", "The average number of messages / s for forwarding messages to a member in the same site", null, org.jgroups.protocols.relay.RELAY2::getAvgMsgsForwardingToLocalMbr));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.relay.RELAY2>("getAvgMsgsForwardingToSM", "The average number of messages / s for forwarding messages to the local SiteMaster", null, org.jgroups.protocols.relay.RELAY2::getAvgMsgsForwardingToSM));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.relay.RELAY2>("getAvgMsgsRelaying", "The average number of messages / s for relaying messages from this SiteMaster to remote SiteMasters", null, org.jgroups.protocols.relay.RELAY2::getAvgMsgsRelaying));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.relay.RELAY2>("getNumForwardedToLocalMbr", "Number of messages (received from a remote Sitemaster and) delivered by this SiteMaster to a local node", null, org.jgroups.protocols.relay.RELAY2::getNumForwardedToLocalMbr));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.relay.RELAY2>("getNumForwardedToSiteMaster", "Number of messages forwarded to the local SiteMaster", null, org.jgroups.protocols.relay.RELAY2::getNumForwardedToSiteMaster));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.relay.RELAY2>("getNumRelayed", "Number of messages sent by this SiteMaster to a remote SiteMaster", null, org.jgroups.protocols.relay.RELAY2::getNumRelayed));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.relay.RELAY2>("getNumberOfNoRouteErrors", "Number of 'no route to site X' errors", null, org.jgroups.protocols.relay.RELAY2::getNumberOfNoRouteErrors));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.relay.RELAY2>("getTimeForwardingToLocalMbr", "The total time (in ms) spent forwarding messages to a member in the same site", null, org.jgroups.protocols.relay.RELAY2::getTimeForwardingToLocalMbr));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.relay.RELAY2>("getTimeForwardingToSM", "The total time (in ms) spent forwarding messages to the local SiteMaster", null, org.jgroups.protocols.relay.RELAY2::getTimeForwardingToSM));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.relay.RELAY2>("getTimeRelaying", "The total time (ms) spent relaying messages from this SiteMaster to remote SiteMasters", null, org.jgroups.protocols.relay.RELAY2::getTimeRelaying));
      PROTOCOL_METADATA.put(org.jgroups.protocols.relay.RELAY2.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.relay.RELAY3>("getAvgMsgsForwardingToLocalMbr", "The average number of messages / s for forwarding messages to a member in the same site", null, org.jgroups.protocols.relay.RELAY3::getAvgMsgsForwardingToLocalMbr));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.relay.RELAY3>("getAvgMsgsForwardingToSM", "The average number of messages / s for forwarding messages to the local SiteMaster", null, org.jgroups.protocols.relay.RELAY3::getAvgMsgsForwardingToSM));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.relay.RELAY3>("getAvgMsgsRelaying", "The average number of messages / s for relaying messages from this SiteMaster to remote SiteMasters", null, org.jgroups.protocols.relay.RELAY3::getAvgMsgsRelaying));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.relay.RELAY3>("getNumForwardedToLocalMbr", "Number of messages (received from a remote Sitemaster and) delivered by this SiteMaster to a local node", null, org.jgroups.protocols.relay.RELAY3::getNumForwardedToLocalMbr));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.relay.RELAY3>("getNumForwardedToSiteMaster", "Number of messages forwarded to the local SiteMaster", null, org.jgroups.protocols.relay.RELAY3::getNumForwardedToSiteMaster));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.relay.RELAY3>("getNumRelayed", "Number of messages sent by this SiteMaster to a remote SiteMaster", null, org.jgroups.protocols.relay.RELAY3::getNumRelayed));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.relay.RELAY3>("getNumberOfNoRouteErrors", "Number of 'no route to site X' errors", null, org.jgroups.protocols.relay.RELAY3::getNumberOfNoRouteErrors));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.relay.RELAY3>("getTimeForwardingToLocalMbr", "The total time (in ms) spent forwarding messages to a member in the same site", null, org.jgroups.protocols.relay.RELAY3::getTimeForwardingToLocalMbr));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.relay.RELAY3>("getTimeForwardingToSM", "The total time (in ms) spent forwarding messages to the local SiteMaster", null, org.jgroups.protocols.relay.RELAY3::getTimeForwardingToSM));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.relay.RELAY3>("getTimeRelaying", "The total time (ms) spent relaying messages from this SiteMaster to remote SiteMasters", null, org.jgroups.protocols.relay.RELAY3::getTimeRelaying));
      PROTOCOL_METADATA.put(org.jgroups.protocols.relay.RELAY3.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST3>("getAgeOutCacheSize", "", null, org.jgroups.protocols.UNICAST3::getAgeOutCacheSize));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST3>("getNumAcksReceived", "Number of acks received", null, org.jgroups.protocols.UNICAST3::getNumAcksReceived));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST3>("getNumAcksSent", "Number of acks sent", null, org.jgroups.protocols.UNICAST3::getNumAcksSent));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST3>("getNumConnections", "Returns the total number of outgoing (send) and incoming (receive) connections", null, org.jgroups.protocols.UNICAST3::getNumConnections));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST3>("getNumLoopbacks", "Number of unicast messages to self looped back up", null, org.jgroups.protocols.UNICAST3::getNumLoopbacks));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST3>("getNumMessagesReceived", "", null, org.jgroups.protocols.UNICAST3::getNumMessagesReceived));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST3>("getNumMessagesSent", "", null, org.jgroups.protocols.UNICAST3::getNumMessagesSent));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST3>("getNumReceiveConnections", "Returns the number of incoming (receive) connections", null, org.jgroups.protocols.UNICAST3::getNumReceiveConnections));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST3>("getNumSendConnections", "Returns the number of outgoing (send) connections", null, org.jgroups.protocols.UNICAST3::getNumSendConnections));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST3>("getNumUnackedMessages", "", null, org.jgroups.protocols.UNICAST3::getNumUnackedMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST3>("getNumXmits", "Number of retransmitted messages", null, org.jgroups.protocols.UNICAST3::getNumXmits));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST3>("getTimestamper", "Next seqno issued by the timestamper", null, org.jgroups.protocols.UNICAST3::getTimestamper));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST3>("getXmitTableDeliverableMessages", "Total number of deliverable messages in all receive windows", null, org.jgroups.protocols.UNICAST3::getXmitTableDeliverableMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST3>("getXmitTableMissingMessages", "Total number of missing messages in all receive windows", null, org.jgroups.protocols.UNICAST3::getXmitTableMissingMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST3>("getXmitTableNumCompactions", "Number of compactions in all (receive and send) windows", null, org.jgroups.protocols.UNICAST3::getXmitTableNumCompactions));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST3>("getXmitTableNumMoves", "Number of moves in all (receive and send) windows", null, org.jgroups.protocols.UNICAST3::getXmitTableNumMoves));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST3>("getXmitTableNumPurges", "Number of purges in all (receive and send) windows", null, org.jgroups.protocols.UNICAST3::getXmitTableNumPurges));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST3>("getXmitTableNumResizes", "Number of resizes in all (receive and send) windows", null, org.jgroups.protocols.UNICAST3::getXmitTableNumResizes));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST3>("getXmitTableUndeliveredMessages", "Total number of undelivered messages in all receive windows", null, org.jgroups.protocols.UNICAST3::getXmitTableUndeliveredMessages));
      PROTOCOL_METADATA.put(org.jgroups.protocols.UNICAST3.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.PERF>("latencyInMs", "Average latency in ms", null, org.jgroups.protocols.PERF::latencyInMs));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.PERF>("latencyInNs", "Average latency in ns", null, org.jgroups.protocols.PERF::latencyInNs));
      PROTOCOL_METADATA.put(org.jgroups.protocols.PERF.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.SEQUENCER2>("getFwdQueueSize", "Number of messages in the forward-queue", null, org.jgroups.protocols.SEQUENCER2::getFwdQueueSize));
      PROTOCOL_METADATA.put(org.jgroups.protocols.SEQUENCER2.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TCP_NIO2>("getDifferentClusterMessages", "Number of messages from members in a different cluster", null, org.jgroups.protocols.TCP_NIO2::getDifferentClusterMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TCP_NIO2>("getDifferentVersionMessages", "Number of messages from members with a different JGroups version", null, org.jgroups.protocols.TCP_NIO2::getDifferentVersionMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TCP_NIO2>("getNumMcastMsgsReceived", "", null, org.jgroups.protocols.TCP_NIO2::getNumMcastMsgsReceived));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TCP_NIO2>("getNumMcastMsgsSent", "", null, org.jgroups.protocols.TCP_NIO2::getNumMcastMsgsSent));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TCP_NIO2>("getNumRejectedMsgs", "", null, org.jgroups.protocols.TCP_NIO2::getNumRejectedMsgs));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TCP_NIO2>("getNumTimerTasks", "Number of timer tasks queued up for execution", null, org.jgroups.protocols.TCP_NIO2::getNumTimerTasks));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TCP_NIO2>("getNumUcastMsgsReceived", "", null, org.jgroups.protocols.TCP_NIO2::getNumUcastMsgsReceived));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TCP_NIO2>("getNumUcastMsgsSent", "", null, org.jgroups.protocols.TCP_NIO2::getNumUcastMsgsSent));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TCP_NIO2>("getOpenConnections", "", null, org.jgroups.protocols.TCP_NIO2::getOpenConnections));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TCP_NIO2>("getTimerThreads", "Number of threads currently in the pool", null, org.jgroups.protocols.TCP_NIO2::getTimerThreads));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TCP_NIO2>("numPartialWrites", "Number of partial writes for all connections (not all bytes were written)", null, org.jgroups.protocols.TCP_NIO2::numPartialWrites));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.TCP_NIO2>("numSelects", "Number of times select() was called", null, org.jgroups.protocols.TCP_NIO2::numSelects));
      attributes.add(new GaugeMetricInfo<>("getLargestSize", "Largest number of threads in the thread pool", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getThreadPool().getLargestSize())));
      attributes.add(new GaugeMetricInfo<>("getThreadPoolSize", "Current number of threads in the thread pool", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getThreadPool().getThreadPoolSize())));
      attributes.add(new GaugeMetricInfo<>("getThreadPoolSizeActive", "Current number of active threads in the thread pool", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getThreadPool().getThreadPoolSizeActive())));
      attributes.add(new GaugeMetricInfo<>("getNumBatchesReceived", "Number of batches received (by the transport)", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumBatchesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumBatchesSent", "Number of batches sent (by the bundler)", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumBatchesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumBytesReceived", "Total number of bytes received (unicast + multicast)", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumBytesSent", "Total number of bytes sent (unicast + multicast bytes)", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastBytesReceived", "Number of multicast bytes received", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumMcastBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastBytesSent", "Number of multicast bytes sent", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumMcastBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastsReceived", "Total number of multicast messages received", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumMcastsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastsSent", "Number of multicast messages sent", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumMcastsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumMsgsReceived", "Number of messages received (mcasts and ucasts received)", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumMsgsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMsgsSent", "Number of messages sent (mcasts and ucasts sent)", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumSingleMsgsSent", "Number of single messages sent (by the bundler)", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumSingleMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastBytesReceived", "Number of unicast bytes received", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumUcastBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastBytesSent", "Number of unicast bytes sent", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumUcastBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastsReceived", "Number of unicast messages received", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumUcastsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastsSent", "Number of unicast messages sent", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumUcastsSent())));
      PROTOCOL_METADATA.put(org.jgroups.protocols.TCP_NIO2.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.FRAG3>("getNumberOfReceivedFragments", "Number of received fragments", null, org.jgroups.protocols.FRAG3::getNumberOfReceivedFragments));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.FRAG3>("getNumberOfSentFragments", "Number of sent fragments", null, org.jgroups.protocols.FRAG3::getNumberOfSentFragments));
      PROTOCOL_METADATA.put(org.jgroups.protocols.FRAG3.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UFC_NB>("getAverageTimeBlocked", "Average time blocked (in ms) in flow control when trying to send a message", null, org.jgroups.protocols.UFC_NB::getAverageTimeBlocked));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UFC_NB>("getNumberOfBlockings", "Number of times flow control blocks sender", null, org.jgroups.protocols.UFC_NB::getNumberOfBlockings));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UFC_NB>("getNumberOfCreditRequestsReceived", "", null, org.jgroups.protocols.UFC_NB::getNumberOfCreditRequestsReceived));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UFC_NB>("getNumberOfCreditRequestsSent", "", null, org.jgroups.protocols.UFC_NB::getNumberOfCreditRequestsSent));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UFC_NB>("getNumberOfCreditResponsesReceived", "", null, org.jgroups.protocols.UFC_NB::getNumberOfCreditResponsesReceived));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UFC_NB>("getNumberOfCreditResponsesSent", "", null, org.jgroups.protocols.UFC_NB::getNumberOfCreditResponsesSent));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UFC_NB>("getNumberOfQueuedMessages", "The number of messages currently queued due to insufficient credit", null, org.jgroups.protocols.UFC_NB::getNumberOfQueuedMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UFC_NB>("getNumberOfQueuings", "The number of times messages have been queued due to insufficient credits", null, org.jgroups.protocols.UFC_NB::getNumberOfQueuings));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UFC_NB>("getQueuedSize", "The total size of all currently queued messages for all destinations", null, org.jgroups.protocols.UFC_NB::getQueuedSize));
      PROTOCOL_METADATA.put(org.jgroups.protocols.UFC_NB.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.MFC_NB>("getAverageTimeBlocked", "Average time blocked (in ns) in flow control when trying to send a message", null, org.jgroups.protocols.MFC_NB::getAverageTimeBlocked));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.MFC_NB>("getNumberOfBlockings", "Number of times flow control blocks sender", null, org.jgroups.protocols.MFC_NB::getNumberOfBlockings));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.MFC_NB>("getNumberOfCreditRequestsReceived", "", null, org.jgroups.protocols.MFC_NB::getNumberOfCreditRequestsReceived));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.MFC_NB>("getNumberOfCreditRequestsSent", "", null, org.jgroups.protocols.MFC_NB::getNumberOfCreditRequestsSent));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.MFC_NB>("getNumberOfCreditResponsesReceived", "", null, org.jgroups.protocols.MFC_NB::getNumberOfCreditResponsesReceived));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.MFC_NB>("getNumberOfCreditResponsesSent", "", null, org.jgroups.protocols.MFC_NB::getNumberOfCreditResponsesSent));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.MFC_NB>("getNumberOfQueuedMessages", "The number of messages currently queued due to insufficient credit", null, org.jgroups.protocols.MFC_NB::getNumberOfQueuedMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.MFC_NB>("getNumberOfQueuings", "The number of times messages have been queued due to insufficient credits", null, org.jgroups.protocols.MFC_NB::getNumberOfQueuings));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.MFC_NB>("getQueuedSize", "The total size of all currently queued messages", null, org.jgroups.protocols.MFC_NB::getQueuedSize));
      PROTOCOL_METADATA.put(org.jgroups.protocols.MFC_NB.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.FRAG4>("getNumberOfReceivedFragments", "Number of received fragments", null, org.jgroups.protocols.FRAG4::getNumberOfReceivedFragments));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.FRAG4>("getNumberOfSentFragments", "Number of sent fragments", null, org.jgroups.protocols.FRAG4::getNumberOfSentFragments));
      PROTOCOL_METADATA.put(org.jgroups.protocols.FRAG4.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.FD_SOCK2>("getActualBindPort", "Actual port the server is listening on", null, org.jgroups.protocols.FD_SOCK2::getActualBindPort));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.FD_SOCK2>("getNumSuspectedMembers", "The number of currently suspected members", null, org.jgroups.protocols.FD_SOCK2::getNumSuspectedMembers));
      PROTOCOL_METADATA.put(org.jgroups.protocols.FD_SOCK2.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.BATCH>("avgBatchSize", "Average number of messages in an BatchMessage", null, org.jgroups.protocols.BATCH::avgBatchSize));
      PROTOCOL_METADATA.put(org.jgroups.protocols.BATCH.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.BATCH2>("avgBatchSize", "Average number of messages in an BatchMessage", null, org.jgroups.protocols.BATCH2::avgBatchSize));
      PROTOCOL_METADATA.put(org.jgroups.protocols.BATCH2.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.NAKACK3>("getBecomeServerQueueSizeActual", "Actual size of the become_server_queue", null, org.jgroups.protocols.NAKACK3::getBecomeServerQueueSizeActual));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.NAKACK3>("getCurrentSeqno", "", null, org.jgroups.protocols.NAKACK3::getCurrentSeqno));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.NAKACK3>("getNonMemberMessages", "Number of messages from non-members", null, org.jgroups.protocols.NAKACK3::getNonMemberMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.NAKACK3>("getSizeOfAllMessages", "Returns the number of bytes of all messages in all retransmit buffers. To compute the size, Message.getLength() is used", null, org.jgroups.protocols.NAKACK3::getSizeOfAllMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.NAKACK3>("getSizeOfAllMessagesInclHeaders", "Returns the number of bytes of all messages in all retransmit buffers. To compute the size, Message.size() is used", null, org.jgroups.protocols.NAKACK3::getSizeOfAllMessagesInclHeaders));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.NAKACK3>("getXmitTableCapacity", "Capacity of the retransmit buffer", null, org.jgroups.protocols.NAKACK3::getXmitTableCapacity));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.NAKACK3>("getXmitTableMissingMessages", "Total number of missing messages in all retransmit buffers", null, org.jgroups.protocols.NAKACK3::getXmitTableMissingMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.NAKACK3>("getXmitTableNumCompactions", "Number of retransmit table compactions", null, org.jgroups.protocols.NAKACK3::getXmitTableNumCompactions));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.NAKACK3>("getXmitTableNumCurrentRows", "Prints the number of rows currently allocated in the matrix. This value will not be lower than xmit_table_now_rows", null, org.jgroups.protocols.NAKACK3::getXmitTableNumCurrentRows));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.NAKACK3>("getXmitTableNumMoves", "Number of retransmit table moves", null, org.jgroups.protocols.NAKACK3::getXmitTableNumMoves));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.NAKACK3>("getXmitTableNumPurges", "Number of retransmit table purges", null, org.jgroups.protocols.NAKACK3::getXmitTableNumPurges));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.NAKACK3>("getXmitTableNumResizes", "Number of retransmit table resizes", null, org.jgroups.protocols.NAKACK3::getXmitTableNumResizes));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.NAKACK3>("getXmitTableUndeliveredMsgs", "Total number of undelivered messages in all retransmit buffers", null, org.jgroups.protocols.NAKACK3::getXmitTableUndeliveredMsgs));
      PROTOCOL_METADATA.put(org.jgroups.protocols.NAKACK3.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.NAKACK4>("getBecomeServerQueueSizeActual", "Actual size of the become_server_queue", null, org.jgroups.protocols.NAKACK4::getBecomeServerQueueSizeActual));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.NAKACK4>("getCurrentSeqno", "", null, org.jgroups.protocols.NAKACK4::getCurrentSeqno));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.NAKACK4>("getNonMemberMessages", "Number of messages from non-members", null, org.jgroups.protocols.NAKACK4::getNonMemberMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.NAKACK4>("getNumBlockings", "Number of times sender threads were blocked on a full send window", null, org.jgroups.protocols.NAKACK4::getNumBlockings));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.NAKACK4>("getNumDroppedMessages", "The number of received messages dropped due to full capacity of the buffer", null, org.jgroups.protocols.NAKACK4::getNumDroppedMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.NAKACK4>("getNumUnackedMessages", "", null, org.jgroups.protocols.NAKACK4::getNumUnackedMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.NAKACK4>("getSizeOfAllMessages", "Returns the number of bytes of all messages in all retransmit buffers. To compute the size, Message.getLength() is used", null, org.jgroups.protocols.NAKACK4::getSizeOfAllMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.NAKACK4>("getSizeOfAllMessagesInclHeaders", "Returns the number of bytes of all messages in all retransmit buffers. To compute the size, Message.size() is used", null, org.jgroups.protocols.NAKACK4::getSizeOfAllMessagesInclHeaders));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.NAKACK4>("getXmitTableCapacity", "Capacity of the retransmit buffer", null, org.jgroups.protocols.NAKACK4::getXmitTableCapacity));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.NAKACK4>("getXmitTableMissingMessages", "Total number of missing messages in all retransmit buffers", null, org.jgroups.protocols.NAKACK4::getXmitTableMissingMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.NAKACK4>("getXmitTableUndeliveredMsgs", "Total number of undelivered messages in all retransmit buffers", null, org.jgroups.protocols.NAKACK4::getXmitTableUndeliveredMsgs));
      PROTOCOL_METADATA.put(org.jgroups.protocols.NAKACK4.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST4>("getAgeOutCacheSize", "", null, org.jgroups.protocols.UNICAST4::getAgeOutCacheSize));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST4>("getNumBlockings", "Number of times sender threads were blocked on a full send window", null, org.jgroups.protocols.UNICAST4::getNumBlockings));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST4>("getNumConnections", "Returns the total number of outgoing (send) and incoming (receive) connections", null, org.jgroups.protocols.UNICAST4::getNumConnections));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST4>("getNumMessagesReceived", "", null, org.jgroups.protocols.UNICAST4::getNumMessagesReceived));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST4>("getNumMessagesSent", "", null, org.jgroups.protocols.UNICAST4::getNumMessagesSent));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST4>("getNumReceiveConnections", "Returns the number of incoming (receive) connections", null, org.jgroups.protocols.UNICAST4::getNumReceiveConnections));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST4>("getNumSendConnections", "Returns the number of outgoing (send) connections", null, org.jgroups.protocols.UNICAST4::getNumSendConnections));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST4>("getNumUnackedMessages", "", null, org.jgroups.protocols.UNICAST4::getNumUnackedMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST4>("getTimestamper", "Next seqno issued by the timestamper", null, org.jgroups.protocols.UNICAST4::getTimestamper));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST4>("getXmitTableDeliverableMessages", "Total number of deliverable messages in all receive windows", null, org.jgroups.protocols.UNICAST4::getXmitTableDeliverableMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST4>("getXmitTableMissingMessages", "Total number of missing messages in all receive windows", null, org.jgroups.protocols.UNICAST4::getXmitTableMissingMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.UNICAST4>("getXmitTableUndeliveredMessages", "Total number of undelivered messages in all receive windows", null, org.jgroups.protocols.UNICAST4::getXmitTableUndeliveredMessages));
      PROTOCOL_METADATA.put(org.jgroups.protocols.UNICAST4.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.FORK>("getForkStacks", "Number of fork-stacks", null, org.jgroups.protocols.FORK::getForkStacks));
      PROTOCOL_METADATA.put(org.jgroups.protocols.FORK.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.RED>("getDropRate", "Percentage of all messages that were dropped", null, org.jgroups.protocols.RED::getDropRate));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.RED>("getDroppedMessages", "", null, org.jgroups.protocols.RED::getDroppedMessages));
      attributes.add(new GaugeMetricInfo<org.jgroups.protocols.RED>("getTotalMessages", "", null, org.jgroups.protocols.RED::getTotalMessages));
      PROTOCOL_METADATA.put(org.jgroups.protocols.RED.class, attributes);
   }
}

