/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.commons.util.Util;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.AbstractRequest;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.SiteAddress;
import org.infinispan.remoting.transport.impl.RequestRepository;
import org.infinispan.util.logging.Log;

public class SingleSiteRequest<T>
extends AbstractRequest<T> {
    private final String site;
    private final AtomicBoolean completed = new AtomicBoolean();

    SingleSiteRequest(ResponseCollector<T> wrapper, long requestId, RequestRepository repository, String site) {
        super(requestId, wrapper, repository);
        this.site = site;
    }

    @Override
    public void onResponse(Address sender, Response response) {
        this.receiveResponse(sender, response);
    }

    @Override
    public boolean onNewView(Set<Address> members) {
        return false;
    }

    private void receiveResponse(Address sender, Response response) {
        try {
            if (this.completed.getAndSet(true)) {
                return;
            }
            Object result = this.responseCollector.addResponse(sender, response);
            if (result == null) {
                result = this.responseCollector.finish();
            }
            this.complete(result);
        }
        catch (Exception e) {
            this.completeExceptionally(e);
        }
    }

    @Override
    protected void onTimeout() {
        if (!this.completed.getAndSet(true)) {
            this.completeExceptionally(Log.CLUSTER.requestTimedOut(this.requestId, this.site, Util.prettyPrintTime((long)this.getTimeoutMs())));
        }
    }

    public void sitesUnreachable(String unreachableSite) {
        if (this.site.equals(unreachableSite)) {
            this.receiveResponse(new SiteAddress(this.site), CacheNotFoundResponse.INSTANCE);
        }
    }
}

