/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.container.versioning.InequalVersionComparisonResult;

@Immutable
public class SimpleClusteredVersion
implements IncrementableEntryVersion,
Serializable {
    private final int viewId;
    final long version;

    public SimpleClusteredVersion(int viewId, long version) {
        this.version = version;
        this.viewId = viewId;
    }

    @Override
    public InequalVersionComparisonResult compareTo(EntryVersion other) {
        if (other instanceof SimpleClusteredVersion) {
            SimpleClusteredVersion otherVersion = (SimpleClusteredVersion)other;
            if (this.viewId > otherVersion.viewId) {
                return InequalVersionComparisonResult.AFTER;
            }
            if (this.viewId < otherVersion.viewId) {
                return InequalVersionComparisonResult.BEFORE;
            }
            if (this.version > otherVersion.version) {
                return InequalVersionComparisonResult.AFTER;
            }
            if (this.version < otherVersion.version) {
                return InequalVersionComparisonResult.BEFORE;
            }
            return InequalVersionComparisonResult.EQUAL;
        }
        throw new IllegalArgumentException("I only know how to deal with SimpleClusteredVersions, not " + other.getClass().getName());
    }

    public String toString() {
        return "SimpleClusteredVersion{viewId=" + this.viewId + ", version=" + this.version + '}';
    }
}

