/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.xa.recovery.RecoveryAwareRemoteTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryInfoKey;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.transaction.xa.recovery.RecoveryManagerImpl;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@DefaultFactoryFor(classes={RecoveryManager.class})
public class RecoveryManagerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    private static final Log log = LogFactory.getLog(RecoveryManagerFactory.class);
    private static final long DEFAULT_EXPIRY = TimeUnit.HOURS.toMillis(6L);

    public <RecoveryManager> RecoveryManager construct(Class<RecoveryManager> componentType) {
        String cacheName;
        this.checkAsyncCache(this.configuration);
        boolean recoveryEnabled = this.configuration.isTransactionRecoveryEnabled();
        String string = cacheName = this.configuration.getName() == null ? "___defaultcache" : this.configuration.getName();
        if (recoveryEnabled) {
            String recoveryCacheName = this.configuration.getTransactionRecoveryCacheName();
            if (log.isTraceEnabled()) {
                log.tracef("Using recovery cache name %s", recoveryCacheName);
            }
            EmbeddedCacheManager cm = this.componentRegistry.getGlobalComponentRegistry().getComponent(EmbeddedCacheManager.class);
            boolean useDefaultCache = recoveryCacheName.equals("__recoveryInfoCacheName__");
            if (!useDefaultCache) {
                if (!cm.getCacheNames().contains(recoveryCacheName)) {
                    throw new ConfigurationException("Recovery cache (" + recoveryCacheName + ") does not exist!!");
                }
            } else if (!cm.getCacheNames().contains(recoveryCacheName)) {
                Configuration config = this.getDefaultRecoveryCacheConfig();
                cm.defineConfiguration(recoveryCacheName, config);
            }
            return (RecoveryManager)this.buildRecoveryManager(cacheName, recoveryCacheName, cm, useDefaultCache);
        }
        return null;
    }

    private void checkAsyncCache(Configuration configuration) {
        if (configuration.isTransactionRecoveryEnabled() && !configuration.getCacheMode().isSynchronous()) {
            throw new ConfigurationException("Recovery for async caches is not supported!");
        }
    }

    private Configuration getDefaultRecoveryCacheConfig() {
        Configuration config = new Configuration();
        config.fluent().transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        config.fluent().clustering().mode(Configuration.CacheMode.LOCAL);
        config.fluent().expiration().lifespan(DEFAULT_EXPIRY);
        config.fluent().recovery().disable();
        return config;
    }

    private RecoveryManager buildRecoveryManager(String cacheName, String recoveryCacheName, EmbeddedCacheManager cm, boolean isDefault) {
        Cache<RecoveryInfoKey, RecoveryAwareRemoteTransaction> recoveryCache;
        if (log.isTraceEnabled()) {
            log.tracef("About to obtain a reference to the recovery cache: %s", recoveryCacheName);
        }
        if ((recoveryCache = cm.getCache(recoveryCacheName)).getConfiguration().isTransactionalCache()) {
            throw new ConfigurationException("The recovery cache shouldn't be transactional.");
        }
        if (log.isTraceEnabled()) {
            log.tracef("Obtained a reference to the recovery cache: %s", recoveryCacheName);
        }
        return new RecoveryManagerImpl(recoveryCache, cacheName);
    }
}

