/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.CacheException;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.config.parsing.XmlConfigHelper;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.jmx.JmxUtil;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.remoting.InboundInvocationHandler;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.transport.AbstractTransport;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.CommandAwareRpcDispatcher;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelLookup;
import org.infinispan.remoting.transport.jgroups.JGroupsResponseFilterAdapter;
import org.infinispan.remoting.transport.jgroups.JGroupsTopologyAwareAddress;
import org.infinispan.remoting.transport.jgroups.MarshallerAdapter;
import org.infinispan.remoting.transport.jgroups.StateTransferMonitor;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.util.FileLookupFactory;
import org.infinispan.util.TypedProperties;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.MergeView;
import org.jgroups.View;
import org.jgroups.blocks.RspFilter;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.TopologyUUID;

public class JGroupsTransport
extends AbstractTransport
implements MembershipListener {
    public static final String CONFIGURATION_STRING = "configurationString";
    public static final String CONFIGURATION_XML = "configurationXml";
    public static final String CONFIGURATION_FILE = "configurationFile";
    public static final String CHANNEL_LOOKUP = "channelLookup";
    protected static final String DEFAULT_JGROUPS_CONFIGURATION_FILE = "jgroups-udp.xml";
    static final Log log = LogFactory.getLog(JGroupsTransport.class);
    static final boolean trace = log.isTraceEnabled();
    final ConcurrentMap<String, StateTransferMonitor> stateTransfersInProgress = new ConcurrentHashMap<String, StateTransferMonitor>();
    protected boolean startChannel = true;
    protected boolean stopChannel = true;
    private CommandAwareRpcDispatcher dispatcher;
    protected TypedProperties props;
    protected InboundInvocationHandler inboundInvocationHandler;
    protected StreamingMarshaller marshaller;
    protected ExecutorService asyncExecutor;
    protected CacheManagerNotifier notifier;
    private boolean globalStatsEnabled;
    private MBeanServer mbeanServer;
    private String domain;
    protected Channel channel;
    protected Address address;
    protected Address physicalAddress;
    protected volatile List<Address> members = null;
    protected volatile Address coordinator = null;
    protected volatile boolean isCoordinator = false;
    protected CountDownLatch channelConnectedLatch = new CountDownLatch(1);

    public JGroupsTransport(Channel channel) {
        this.channel = channel;
        if (channel == null) {
            throw new IllegalArgumentException("Cannot deal with a null channel!");
        }
        if (channel.isConnected()) {
            throw new IllegalArgumentException("Channel passed in cannot already be connected!");
        }
    }

    public JGroupsTransport() {
    }

    @Override
    public Log getLog() {
        return log;
    }

    @Override
    public void initialize(@ComponentName(value="org.infinispan.marshaller.global") StreamingMarshaller marshaller, ExecutorService asyncExecutor, InboundInvocationHandler inboundInvocationHandler, CacheManagerNotifier notifier) {
        this.marshaller = marshaller;
        this.asyncExecutor = asyncExecutor;
        this.inboundInvocationHandler = inboundInvocationHandler;
        this.notifier = notifier;
    }

    @Override
    public void start() {
        this.props = TypedProperties.toTypedProperties(this.configuration.getTransportProperties());
        if (log.isInfoEnabled()) {
            log.startingJGroupsChannel();
        }
        this.initChannelAndRPCDispatcher();
        this.startJGroupsChannelIfNeeded();
        this.waitForChannelToConnect();
    }

    protected void startJGroupsChannelIfNeeded() {
        if (this.startChannel) {
            String clusterName = this.configuration.getClusterName();
            try {
                this.channel.connect(clusterName);
            }
            catch (Exception e) {
                throw new CacheException("Unable to start JGroups Channel", e);
            }
            try {
                this.globalStatsEnabled = this.configuration.isExposeGlobalJmxStatistics();
                if (this.globalStatsEnabled) {
                    String groupName = String.format("type=channel,cluster=%s", ObjectName.quote(clusterName));
                    this.mbeanServer = JmxUtil.lookupMBeanServer(this.configuration);
                    this.domain = JmxUtil.buildJmxDomain(this.configuration, this.mbeanServer, groupName);
                    JmxConfigurator.registerChannel((JChannel)((JChannel)this.channel), (MBeanServer)this.mbeanServer, (String)this.domain, (String)clusterName, (boolean)true);
                }
            }
            catch (Exception e) {
                throw new CacheException("Channel connected, but unable to register MBeans", e);
            }
        }
        this.address = JGroupsTransport.fromJGroupsAddress(this.channel.getAddress());
        if (!this.startChannel) {
            this.viewAccepted(this.channel.getView());
        }
        if (log.isInfoEnabled()) {
            log.localAndPhysicalAddress(this.getAddress(), this.getPhysicalAddresses());
        }
    }

    @Override
    public int getViewId() {
        if (this.channel == null) {
            throw new CacheException("The cache has been stopped and invocations are not allowed!");
        }
        View view = this.channel.getView();
        if (view == null) {
            return -1;
        }
        return (int)view.getVid().getId();
    }

    @Override
    public void stop() {
        try {
            if (this.stopChannel && this.channel != null && this.channel.isOpen()) {
                log.disconnectAndCloseJGroups();
                if (this.globalStatsEnabled) {
                    JmxConfigurator.unregisterChannel((JChannel)((JChannel)this.channel), (MBeanServer)this.mbeanServer, (String)this.domain, (String)this.channel.getClusterName());
                }
                this.channel.disconnect();
                this.channel.close();
            }
        }
        catch (Exception toLog) {
            log.problemClosingChannel(toLog);
        }
        this.channel = null;
        if (this.dispatcher != null) {
            log.stoppingRpcDispatcher();
            this.dispatcher.stop();
        }
        this.members = Collections.emptyList();
        this.coordinator = null;
        this.isCoordinator = false;
        this.dispatcher = null;
    }

    protected void initChannel() {
        if (this.channel == null) {
            this.buildChannel();
            String transportNodeName = this.configuration.getTransportNodeName();
            if (transportNodeName != null && transportNodeName.length() > 0) {
                long range = 65534L;
                long randomInRange = (long)(Math.random() * (double)range % (double)range) + 1L;
                transportNodeName = transportNodeName + "-" + randomInRange;
                this.channel.setName(transportNodeName);
            }
        }
        this.channel.setDiscardOwnMessages(true);
        if (this.configuration.hasTopologyInfo()) {
            if (this.startChannel) {
                ((JChannel)this.channel).setAddressGenerator(new AddressGenerator(){

                    public org.jgroups.Address generateAddress() {
                        return TopologyUUID.randomUUID((String)JGroupsTransport.this.channel.getName(), (String)JGroupsTransport.this.configuration.getSiteId(), (String)JGroupsTransport.this.configuration.getRackId(), (String)JGroupsTransport.this.configuration.getMachineId());
                    }
                });
            } else if (this.channel.getAddress() instanceof TopologyUUID) {
                TopologyUUID topologyAddress = (TopologyUUID)this.channel.getAddress();
                if (!(this.configuration.getSiteId().equals(topologyAddress.getSiteId()) && this.configuration.getRackId().equals(topologyAddress.getRackId()) && this.configuration.getMachineId().equals(topologyAddress.getMachineId()))) {
                    throw new CacheException("Topology information does not match the one set by the provided JGroups channel");
                }
            } else {
                throw new CacheException("JGroups address does not contain topology coordinates");
            }
        }
    }

    private void initChannelAndRPCDispatcher() throws CacheException {
        this.initChannel();
        this.dispatcher = new CommandAwareRpcDispatcher(this.channel, this, this.asyncExecutor, this.inboundInvocationHandler);
        MarshallerAdapter adapter = new MarshallerAdapter(this.marshaller);
        this.dispatcher.setRequestMarshaller(adapter);
        this.dispatcher.setResponseMarshaller(adapter);
    }

    private void buildChannel() {
        if (this.props != null) {
            String cfg;
            if (this.props.containsKey(CHANNEL_LOOKUP)) {
                String channelLookupClassName = this.props.getProperty(CHANNEL_LOOKUP);
                try {
                    JGroupsChannelLookup lookup = (JGroupsChannelLookup)Util.getInstance(channelLookupClassName, this.configuration.getClassLoader());
                    this.channel = lookup.getJGroupsChannel(this.props);
                    this.startChannel = lookup.shouldStartAndConnect();
                    this.stopChannel = lookup.shouldStopAndDisconnect();
                }
                catch (ClassCastException e) {
                    log.wrongTypeForJGroupsChannelLookup(channelLookupClassName, e);
                    throw new CacheException(e);
                }
                catch (Exception e) {
                    log.errorInstantiatingJGroupsChannelLookup(channelLookupClassName, e);
                    throw new CacheException(e);
                }
                if (this.configuration.isStrictPeerToPeer() && !this.startChannel) {
                    log.warnStrictPeerToPeerWithInjectedChannel();
                }
            }
            if (this.channel == null && this.props.containsKey(CONFIGURATION_FILE)) {
                cfg = this.props.getProperty(CONFIGURATION_FILE);
                try {
                    this.channel = new JChannel(FileLookupFactory.newInstance().lookupFileLocation(cfg, this.configuration.getClassLoader()));
                }
                catch (Exception e) {
                    log.errorCreatingChannelFromConfigFile(cfg);
                    throw new CacheException(e);
                }
            }
            if (this.channel == null && this.props.containsKey(CONFIGURATION_XML)) {
                cfg = this.props.getProperty(CONFIGURATION_XML);
                try {
                    this.channel = new JChannel(XmlConfigHelper.stringToElement(cfg));
                }
                catch (Exception e) {
                    log.errorCreatingChannelFromXML(cfg);
                    throw new CacheException(e);
                }
            }
            if (this.channel == null && this.props.containsKey(CONFIGURATION_STRING)) {
                cfg = this.props.getProperty(CONFIGURATION_STRING);
                try {
                    this.channel = new JChannel(cfg);
                }
                catch (Exception e) {
                    log.errorCreatingChannelFromConfigString(cfg);
                    throw new CacheException(e);
                }
            }
        }
        if (this.channel == null) {
            log.unableToUseJGroupsPropertiesProvided(this.props);
            try {
                this.channel = new JChannel(FileLookupFactory.newInstance().lookupFileLocation(DEFAULT_JGROUPS_CONFIGURATION_FILE, this.configuration.getClassLoader()));
            }
            catch (Exception e) {
                throw new CacheException("Unable to start JGroups channel", e);
            }
        }
    }

    @Override
    public boolean isCoordinator() {
        return this.isCoordinator;
    }

    @Override
    public Address getCoordinator() {
        return this.coordinator;
    }

    public void waitForChannelToConnect() {
        if (this.channel == null) {
            return;
        }
        log.debug("Waiting on view being accepted");
        try {
            this.channelConnectedLatch.await();
        }
        catch (InterruptedException e) {
            log.interruptedWaitingForCoordinator(e);
        }
    }

    @Override
    public List<Address> getMembers() {
        return this.members != null ? this.members : Collections.emptyList();
    }

    @Override
    public boolean isMulticastCapable() {
        return this.channel.getProtocolStack().getTransport().supportsMulticasting();
    }

    @Override
    public Address getAddress() {
        if (this.address == null && this.channel != null) {
            this.address = JGroupsTransport.fromJGroupsAddress(this.channel.getAddress());
        }
        return this.address;
    }

    @Override
    public List<Address> getPhysicalAddresses() {
        if (this.physicalAddress == null && this.channel != null) {
            org.jgroups.Address addr = (org.jgroups.Address)this.channel.down(new Event(87, (Object)this.channel.getAddress()));
            this.physicalAddress = new JGroupsAddress(addr);
        }
        return Collections.singletonList(this.physicalAddress);
    }

    @Override
    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, boolean usePriorityQueue, ResponseFilter responseFilter, boolean supportReplay) throws Exception {
        boolean asyncMarshalling;
        if (recipients != null && recipients.isEmpty()) {
            log.trace("Destination list is empty: no need to send message");
            return Collections.emptyMap();
        }
        if (trace) {
            log.tracef("dests=%s, command=%s, mode=%s, timeout=%s", new Object[]{recipients, rpcCommand, mode, timeout});
        }
        if (mode.isSynchronous() && recipients != null && !this.getMembers().containsAll(recipients)) {
            if (mode == ResponseMode.SYNCHRONOUS) {
                throw new SuspectException("One or more nodes have left the cluster while replicating command " + rpcCommand);
            }
            recipients = new ArrayList<Address>(recipients);
            recipients.retainAll(this.getMembers());
        }
        boolean bl = asyncMarshalling = mode == ResponseMode.ASYNCHRONOUS;
        if (!(usePriorityQueue || ResponseMode.SYNCHRONOUS != mode && ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS != mode)) {
            usePriorityQueue = true;
        }
        boolean broadcast = recipients == null || recipients.size() == this.members.size();
        RspList rsps = this.dispatcher.invokeRemoteCommands(JGroupsTransport.toJGroupsAddressList(recipients), rpcCommand, JGroupsTransport.toJGroupsMode(mode), timeout, recipients != null, usePriorityQueue, this.toJGroupsFilter(responseFilter), supportReplay, asyncMarshalling, broadcast);
        if (mode.isAsynchronous()) {
            return Collections.emptyMap();
        }
        if (rsps == null) {
            return Collections.emptyMap();
        }
        HashMap<Address, Response> retval = new HashMap<Address, Response>(rsps.size());
        boolean ignoreLeavers = mode == ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS || mode == ResponseMode.WAIT_FOR_VALID_RESPONSE;
        boolean noValidResponses = true;
        for (Rsp rsp : rsps.values()) {
            noValidResponses &= this.parseResponseAndAddToResponseList(rsp.getValue(), rsp.getException(), retval, rsp.wasSuspected(), rsp.wasReceived(), JGroupsTransport.fromJGroupsAddress(rsp.getSender()), responseFilter != null, ignoreLeavers);
        }
        if (noValidResponses) {
            throw new TimeoutException("Timed out waiting for valid responses!");
        }
        return retval;
    }

    private static org.jgroups.blocks.ResponseMode toJGroupsMode(ResponseMode mode) {
        switch (mode) {
            case ASYNCHRONOUS: 
            case ASYNCHRONOUS_WITH_SYNC_MARSHALLING: {
                return org.jgroups.blocks.ResponseMode.GET_NONE;
            }
            case SYNCHRONOUS: 
            case SYNCHRONOUS_IGNORE_LEAVERS: {
                return org.jgroups.blocks.ResponseMode.GET_ALL;
            }
            case WAIT_FOR_VALID_RESPONSE: {
                return org.jgroups.blocks.ResponseMode.GET_FIRST;
            }
        }
        throw new CacheException("Unknown response mode " + (Object)((Object)mode));
    }

    private RspFilter toJGroupsFilter(ResponseFilter responseFilter) {
        return responseFilter == null ? null : new JGroupsResponseFilterAdapter(responseFilter);
    }

    public void viewAccepted(View newView) {
        boolean hasNotifier;
        log.debugf("New view accepted: %s", newView);
        List newMembers = newView.getMembers();
        if (newMembers == null || newMembers.isEmpty()) {
            log.debugf("Received null or empty member list from JGroups channel: " + newView, new Object[0]);
            return;
        }
        List<Address> oldMembers = this.members;
        this.members = JGroupsTransport.fromJGroupsAddressList(newMembers);
        this.coordinator = JGroupsTransport.fromJGroupsAddress(newView.getCreator());
        this.isCoordinator = this.coordinator != null && this.coordinator.equals(this.getAddress());
        this.channelConnectedLatch.countDown();
        boolean bl = hasNotifier = this.notifier != null;
        if (hasNotifier) {
            Notify n;
            if (newView instanceof MergeView) {
                if (log.isInfoEnabled()) {
                    log.receivedMergedView(newView);
                }
                n = new NotifyMerge();
            } else {
                if (log.isInfoEnabled()) {
                    log.receivedClusterView(newView);
                }
                n = new NotifyViewChange();
            }
            n.emitNotification(oldMembers, newView);
        }
    }

    public void suspect(org.jgroups.Address suspected_mbr) {
    }

    public void block() {
    }

    public void unblock() {
    }

    protected static org.jgroups.Address toJGroupsAddress(Address a) {
        return ((JGroupsAddress)a).address;
    }

    static Address fromJGroupsAddress(org.jgroups.Address addr) {
        if (addr instanceof TopologyUUID) {
            return new JGroupsTopologyAwareAddress((TopologyUUID)addr);
        }
        return new JGroupsAddress(addr);
    }

    private static List<org.jgroups.Address> toJGroupsAddressList(Collection<Address> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<org.jgroups.Address> retval = new LinkedList<org.jgroups.Address>();
        for (Address a : list) {
            retval.add(JGroupsTransport.toJGroupsAddress(a));
        }
        return retval;
    }

    private static List<Address> fromJGroupsAddressList(List<org.jgroups.Address> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Address> retval = new ArrayList<Address>(list.size());
        for (org.jgroups.Address a : list) {
            retval.add(JGroupsTransport.fromJGroupsAddress(a));
        }
        return Collections.unmodifiableList(retval);
    }

    public CommandAwareRpcDispatcher getCommandAwareRpcDispatcher() {
        return this.dispatcher;
    }

    public Channel getChannel() {
        return this.channel;
    }

    private class NotifyMerge
    implements Notify {
        private NotifyMerge() {
        }

        @Override
        public void emitNotification(List<Address> oldMembers, View newView) {
            MergeView mv = (MergeView)newView;
            Address address = JGroupsTransport.this.getAddress();
            int viewId = (int)newView.getVid().getId();
            JGroupsTransport.this.notifier.notifyMerge(JGroupsTransport.this.members, oldMembers, address, viewId, this.getSubgroups(mv.getSubgroups()));
        }

        private List<List<Address>> getSubgroups(List<View> subviews) {
            ArrayList<List<Address>> l = new ArrayList<List<Address>>(subviews.size());
            for (View v : subviews) {
                l.add(JGroupsTransport.fromJGroupsAddressList(v.getMembers()));
            }
            return l;
        }
    }

    private class NotifyViewChange
    implements Notify {
        private NotifyViewChange() {
        }

        @Override
        public void emitNotification(List<Address> oldMembers, View newView) {
            JGroupsTransport.this.notifier.notifyViewChange(JGroupsTransport.this.members, oldMembers, JGroupsTransport.this.getAddress(), (int)newView.getVid().getId());
        }
    }

    private static interface Notify {
        public void emitNotification(List<Address> var1, View var2);
    }
}

