/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.remoting.ReplicationQueue;

public class AsyncConfiguration {
    private final boolean asyncMarshalling;
    private final ReplicationQueue replicationQueue;
    private final long replicationQueueInterval;
    private final int replicationQueueMaxElements;
    private final boolean useReplicationQueue;

    AsyncConfiguration(boolean asyncMarshalling, ReplicationQueue replicationQueue, long replicationQueueInterval, int replicationQueueMaxElements, boolean useReplicationQueue) {
        this.asyncMarshalling = asyncMarshalling;
        this.replicationQueue = replicationQueue;
        this.replicationQueueInterval = replicationQueueInterval;
        this.replicationQueueMaxElements = replicationQueueMaxElements;
        this.useReplicationQueue = useReplicationQueue;
    }

    public boolean asyncMarshalling() {
        return this.asyncMarshalling;
    }

    public ReplicationQueue replQueue() {
        return this.replicationQueue;
    }

    public long replQueueInterval() {
        return this.replicationQueueInterval;
    }

    public int replQueueMaxElements() {
        return this.replicationQueueMaxElements;
    }

    public boolean useReplQueue() {
        return this.useReplicationQueue;
    }

    public String toString() {
        return "AsyncConfiguration{asyncMarshalling=" + this.asyncMarshalling + ", replicationQueue=" + this.replicationQueue + ", replicationQueueInterval=" + this.replicationQueueInterval + ", replicationQueueMaxElements=" + this.replicationQueueMaxElements + ", useReplicationQueue=" + this.useReplicationQueue + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsyncConfiguration that = (AsyncConfiguration)o;
        if (this.asyncMarshalling != that.asyncMarshalling) {
            return false;
        }
        if (this.replicationQueueInterval != that.replicationQueueInterval) {
            return false;
        }
        if (this.replicationQueueMaxElements != that.replicationQueueMaxElements) {
            return false;
        }
        if (this.useReplicationQueue != that.useReplicationQueue) {
            return false;
        }
        return !(this.replicationQueue != null ? !this.replicationQueue.equals(that.replicationQueue) : that.replicationQueue != null);
    }

    public int hashCode() {
        int result = this.asyncMarshalling ? 1 : 0;
        result = 31 * result + (this.replicationQueue != null ? this.replicationQueue.hashCode() : 0);
        result = 31 * result + (int)(this.replicationQueueInterval ^ this.replicationQueueInterval >>> 32);
        result = 31 * result + this.replicationQueueMaxElements;
        result = 31 * result + (this.useReplicationQueue ? 1 : 0);
        return result;
    }
}

