/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.util.HashSet;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.AbstractComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.jmx.AbstractJmxRegistration;
import org.infinispan.jmx.CacheManagerJmxRegistration;
import org.infinispan.jmx.ComponentsJmxRegistration;
import org.infinispan.jmx.JmxDomainConflictException;
import org.infinispan.jmx.JmxUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@SurvivesRestarts
public class CacheJmxRegistration
extends AbstractJmxRegistration {
    private static final Log log = LogFactory.getLog(CacheJmxRegistration.class);
    public static final String CACHE_JMX_GROUP = "type=Cache";
    private AdvancedCache<?, ?> cache;
    private Set<AbstractComponentRegistry.Component> nonCacheComponents;
    private boolean needToUnregister = false;

    @Inject
    public void initialize(Cache<?, ?> cache, GlobalConfiguration globalConfig) {
        this.cache = cache.getAdvancedCache();
        this.globalConfig = globalConfig;
    }

    @Start(priority=14)
    public void start() {
        if (this.cache == null) {
            throw new IllegalStateException("The cache should had been injected before a call to this method");
        }
        Set<AbstractComponentRegistry.Component> components = this.cache.getComponentRegistry().getRegisteredComponents();
        this.nonCacheComponents = this.getNonCacheComponents(components);
        if (this.registerMBeans(components, this.cache.getCacheManager().getCacheManagerConfiguration())) {
            this.needToUnregister = true;
            log.mbeansSuccessfullyRegistered();
        } else if (this.cache.getName().equals("___defaultcache")) {
            log.unableToRegisterMBeans();
        } else {
            log.unableToRegisterMBeans(this.cache.getName());
        }
    }

    @Stop
    public void stop() {
        if (this.cache == null) {
            return;
        }
        Configuration config = this.cache.getCacheConfiguration();
        if (this.needToUnregister) {
            try {
                this.unregisterMBeans(this.nonCacheComponents);
                this.needToUnregister = false;
            }
            catch (Exception e) {
                log.problemsUnregisteringMBeans(e);
            }
        }
    }

    public void unregisterCacheMBean() {
        if (this.mBeanServer != null) {
            String groupName = "type=Cache," + this.getCacheJmxName() + ",manager=" + ObjectName.quote(this.globalConfig.globalJmxStatistics().cacheManagerName());
            String pattern = this.jmxDomain + ":" + groupName + ",*";
            try {
                Set<ObjectName> names = this.mBeanServer.queryNames(new ObjectName(pattern), null);
                for (ObjectName name : names) {
                    this.mBeanServer.unregisterMBean(name);
                }
            }
            catch (MBeanRegistrationException e) {
                log.unableToUnregisterMBeanWithPattern(pattern, e);
            }
            catch (InstanceNotFoundException e) {
            }
            catch (MalformedObjectNameException e) {
                String message = "Malformed pattern " + pattern;
                throw new CacheException(message, e);
            }
        }
    }

    @Override
    protected ComponentsJmxRegistration buildRegistrar(Set<AbstractComponentRegistry.Component> components) {
        String groupName = "type=Cache," + ComponentsJmxRegistration.NAME_KEY + "=" + ObjectName.quote(this.cache.getName() + "(" + this.cache.getConfiguration().getCacheModeString().toLowerCase() + ")") + ",manager=" + ObjectName.quote(this.globalConfig.globalJmxStatistics().cacheManagerName());
        ComponentsJmxRegistration registrar = new ComponentsJmxRegistration(this.mBeanServer, components, groupName);
        this.updateDomain(registrar, this.cache.getComponentRegistry().getGlobalComponentRegistry(), this.mBeanServer, groupName);
        return registrar;
    }

    private String getCacheJmxName() {
        return ComponentsJmxRegistration.NAME_KEY + "=" + ObjectName.quote(this.cache.getName() + "(" + this.cache.getCacheConfiguration().clustering().cacheModeString().toLowerCase() + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDomain(ComponentsJmxRegistration registrar, GlobalComponentRegistry componentRegistry, MBeanServer mBeanServer, String groupName) {
        CacheManagerJmxRegistration managerJmxReg = componentRegistry.getComponent(CacheManagerJmxRegistration.class);
        if (!this.globalConfig.globalJmxStatistics().enabled() && this.jmxDomain == null) {
            String tmpJmxDomain = JmxUtil.buildJmxDomain(this.globalConfig, mBeanServer, groupName);
            CacheManagerJmxRegistration cacheManagerJmxRegistration = managerJmxReg;
            synchronized (cacheManagerJmxRegistration) {
                if (managerJmxReg.jmxDomain == null) {
                    if (!tmpJmxDomain.equals(this.globalConfig.globalJmxStatistics().domain()) && !this.globalConfig.globalJmxStatistics().allowDuplicateDomains()) {
                        log.cacheManagerAlreadyRegistered(this.globalConfig.globalJmxStatistics().domain());
                        throw new JmxDomainConflictException(String.format("Domain already registered %s", this.globalConfig.globalJmxStatistics().domain()));
                    }
                    managerJmxReg.jmxDomain = tmpJmxDomain;
                }
                this.jmxDomain = managerJmxReg.jmxDomain;
            }
        } else {
            this.jmxDomain = managerJmxReg.jmxDomain == null ? this.globalConfig.globalJmxStatistics().domain() : managerJmxReg.jmxDomain;
        }
        registrar.setJmxDomain(this.jmxDomain);
    }

    protected Set<AbstractComponentRegistry.Component> getNonCacheComponents(Set<AbstractComponentRegistry.Component> components) {
        HashSet<AbstractComponentRegistry.Component> componentsExceptCache = new HashSet<AbstractComponentRegistry.Component>(64);
        for (AbstractComponentRegistry.Component component : components) {
            String name = component.getName();
            if (name.equals(Cache.class.getName()) || name.equals(AdvancedCache.class.getName())) continue;
            componentsExceptCache.add(component);
        }
        return componentsExceptCache;
    }
}

