/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.Set;
import org.infinispan.InvalidCacheUsageException;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.RepeatableReadEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.locking.AbstractTxLockingInterceptor;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class OptimisticLockingInterceptor
extends AbstractTxLockingInterceptor {
    private LockAcquisitionVisitor lockAcquisitionVisitor;
    private boolean needToMarkReads;
    private static final Log log = LogFactory.getLog(OptimisticLockingInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Start
    public void start() {
        if (this.cacheConfiguration.clustering().cacheMode() == CacheMode.LOCAL && this.cacheConfiguration.locking().writeSkewCheck() && this.cacheConfiguration.locking().isolationLevel() == IsolationLevel.REPEATABLE_READ && !this.cacheConfiguration.unsafe().unreliableReturnValues()) {
            this.lockAcquisitionVisitor = new LocalWriteSkewCheckingLockAcquisitionVisitor();
            this.needToMarkReads = true;
        } else {
            this.lockAcquisitionVisitor = new LockAcquisitionVisitor();
            this.needToMarkReads = false;
        }
    }

    private void markKeyAsRead(InvocationContext ctx, AbstractDataCommand command, boolean forceRead) {
        if (this.needToMarkReads && ctx.isInTxScope() && (forceRead || !command.hasFlag(Flag.IGNORE_RETURN_VALUES))) {
            TxInvocationContext tctx = (TxInvocationContext)ctx;
            ((AbstractCacheTransaction)tctx.getCacheTransaction()).addReadKey(command.getKey());
        }
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!command.hasModifications() || command.writesToASingleKey()) {
            log.trace("Not using lock reordering as we have a single key.");
            this.acquireLocksVisitingCommands(ctx, command);
        } else {
            boolean hasClear;
            Object[] orderedKeys = command.getAffectedKeysToLock(true);
            boolean bl = hasClear = orderedKeys == null;
            if (hasClear) {
                log.trace("Not using lock reordering as the prepare contains a clear command.");
                this.acquireLocksVisitingCommands(ctx, command);
            } else {
                log.tracef("Using lock reordering, order is: %s", orderedKeys);
                this.acquireAllLocks(ctx, orderedKeys);
            }
        }
        return this.invokeNextAndCommitIf1Pc(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (command.hasFlag(Flag.PUT_FOR_EXTERNAL_READ)) {
            return super.visitPutKeyValueCommand(ctx, command);
        }
        try {
            this.markKeyAsRead(ctx, command, command.isConditional());
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        this.markKeyAsRead(ctx, command, true);
        return super.visitGetKeyValueCommand(ctx, command);
    }

    @Override
    public Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        this.markKeyAsRead(ctx, command, true);
        return super.visitGetCacheEntryCommand(ctx, command);
    }

    @Override
    public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        try {
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        try {
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        try {
            this.markKeyAsRead(ctx, command, command.isConditional());
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        try {
            this.markKeyAsRead(ctx, command, command.isConditional());
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        try {
            for (Object key : this.dataContainer.keySet()) {
                this.entryFactory.wrapEntryForClear(ctx, key);
            }
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        throw new InvalidCacheUsageException("Explicit locking is not allowed with optimistic caches!");
    }

    private void performLocalWriteSkewCheck(TxInvocationContext ctx, Object key) {
        CacheEntry ce = ctx.lookupEntry(key);
        if (ce instanceof RepeatableReadEntry && ((AbstractCacheTransaction)ctx.getCacheTransaction()).keyRead(key)) {
            if (log.isTraceEnabled()) {
                log.tracef("Performing local write skew check for key %s", key);
            }
            ((RepeatableReadEntry)ce).performLocalWriteSkewCheck(this.dataContainer, true);
        } else if (log.isTraceEnabled()) {
            log.tracef("*Not* performing local write skew check for key %s", key);
        }
    }

    private void acquireAllLocks(TxInvocationContext ctx, Object[] orderedKeys) throws InterruptedException {
        long lockTimeout = this.cacheConfiguration.locking().lockAcquisitionTimeout();
        for (Object key : orderedKeys) {
            this.lockAndRegisterBackupLock(ctx, key, lockTimeout, false);
            this.performLocalWriteSkewCheck(ctx, key);
            ctx.addAffectedKey(key);
        }
    }

    private void acquireLocksVisitingCommands(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        for (WriteCommand wc : command.getModifications()) {
            wc.acceptVisitor(ctx, this.lockAcquisitionVisitor);
        }
    }

    private class LocalWriteSkewCheckingLockAcquisitionVisitor
    extends LockAcquisitionVisitor {
        private LocalWriteSkewCheckingLockAcquisitionVisitor() {
        }

        @Override
        protected void performWriteSkewCheck(TxInvocationContext ctx, Object key) {
            OptimisticLockingInterceptor.this.performLocalWriteSkewCheck(ctx, key);
        }
    }

    private class LockAcquisitionVisitor
    extends AbstractVisitor {
        private LockAcquisitionVisitor() {
        }

        protected void performWriteSkewCheck(TxInvocationContext ctx, Object key) {
        }

        @Override
        public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
            return this.visitMultiKeyCommand(ctx, command, OptimisticLockingInterceptor.this.dataContainer.keySet());
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            return this.visitMultiKeyCommand(ctx, command, command.getMap().keySet());
        }

        private Object visitMultiKeyCommand(InvocationContext ctx, FlagAffectedCommand command, Set<Object> keys) throws Throwable {
            TxInvocationContext txC = (TxInvocationContext)ctx;
            boolean skipLocking = OptimisticLockingInterceptor.this.hasSkipLocking(command);
            long lockTimeout = OptimisticLockingInterceptor.this.getLockAcquisitionTimeout(command, skipLocking);
            for (Object key : keys) {
                this.lockAndRecord(txC, skipLocking, lockTimeout, key);
            }
            return null;
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            return this.visitSingleKeyCommand(ctx, command);
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            return this.visitSingleKeyCommand(ctx, command);
        }

        private Object visitSingleKeyCommand(InvocationContext ctx, AbstractDataCommand command) throws InterruptedException {
            TxInvocationContext txC = (TxInvocationContext)ctx;
            boolean skipLocking = OptimisticLockingInterceptor.this.hasSkipLocking(command);
            long lockTimeout = OptimisticLockingInterceptor.this.getLockAcquisitionTimeout(command, skipLocking);
            this.lockAndRecord(txC, skipLocking, lockTimeout, command.getKey());
            return null;
        }

        private void lockAndRecord(TxInvocationContext txC, boolean skipLocking, long lockTimeout, Object key) throws InterruptedException {
            OptimisticLockingInterceptor.this.lockAndRegisterBackupLock(txC, key, lockTimeout, skipLocking);
            this.performWriteSkewCheck(txC, key);
            txC.addAffectedKey(key);
        }

        @Override
        public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
            if (OptimisticLockingInterceptor.this.cdl.localNodeIsOwner(command.getKey())) {
                Object[] compositeKeys = command.getCompositeKeys();
                TxInvocationContext txC = (TxInvocationContext)ctx;
                boolean skipLocking = OptimisticLockingInterceptor.this.hasSkipLocking(command);
                long lockTimeout = OptimisticLockingInterceptor.this.getLockAcquisitionTimeout(command, skipLocking);
                for (Object key : compositeKeys) {
                    this.performWriteSkewCheck(txC, key);
                    OptimisticLockingInterceptor.this.lockAndRegisterBackupLock(txC, key, lockTimeout, skipLocking);
                    txC.addAffectedKey(key);
                }
            }
            return null;
        }

        @Override
        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            return this.visitSingleKeyCommand(ctx, command);
        }
    }
}

