/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CommandAckCollector;

public class PrimaryAckCommand
extends BaseRpcCommand {
    public static final int COMMAND_ID = 73;
    private transient CommandAckCollector commandAckCollector;
    private long id;
    private boolean success;
    private Object value;
    private Address[] waitFor;

    public PrimaryAckCommand() {
        super(null);
    }

    public PrimaryAckCommand(ByteString cacheName) {
        super(cacheName);
    }

    public PrimaryAckCommand(ByteString cacheName, long id, boolean success, Object value, Address[] waitFor) {
        super(cacheName);
        this.id = id;
        this.success = success;
        this.value = value;
        this.waitFor = waitFor;
    }

    public void setCommandAckCollector(CommandAckCollector commandAckCollector) {
        this.commandAckCollector = commandAckCollector;
    }

    public void ack() {
        this.commandAckCollector.primaryAck(this.id, this.getOrigin(), this.value, this.success, this.waitFor);
    }

    @Override
    public byte getCommandId() {
        return 73;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeLong(this.id);
        output.writeBoolean(this.success);
        output.writeObject(this.value);
        if (this.success) {
            MarshallUtil.marshallArray((Object[])this.waitFor, (ObjectOutput)output);
        }
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.id = input.readLong();
        this.success = input.readBoolean();
        this.value = input.readObject();
        if (this.success) {
            this.waitFor = (Address[])MarshallUtil.unmarshallArray((ObjectInput)input, Address[]::new);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("PrimaryAckCommand{");
        sb.append("id=").append(this.id);
        sb.append(", success=").append(this.success);
        sb.append(", value=").append(Util.toStr((Object)this.value));
        sb.append(", waitFor=").append(Arrays.toString(this.waitFor));
        sb.append('}');
        return sb.toString();
    }
}

