/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.IdentityAttributeCopier;
import org.infinispan.commons.configuration.attributes.Matchable;
import org.infinispan.configuration.cache.RecoveryConfiguration;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.TransactionProtocol;
import org.infinispan.transaction.lookup.GenericTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionSynchronizationRegistryLookup;

public class TransactionConfiguration
implements Matchable<TransactionConfiguration> {
    public static final AttributeDefinition<Boolean> AUTO_COMMIT = AttributeDefinition.builder((String)"auto-commit", (Object)true).immutable().build();
    public static final AttributeDefinition<Long> CACHE_STOP_TIMEOUT = AttributeDefinition.builder((String)"stop-timeout", (Object)TimeUnit.SECONDS.toMillis(30L)).build();
    public static final AttributeDefinition<LockingMode> LOCKING_MODE = AttributeDefinition.builder((String)"locking", (Object)((Object)LockingMode.OPTIMISTIC)).build();
    public static final AttributeDefinition<TransactionManagerLookup> TRANSACTION_MANAGER_LOOKUP = AttributeDefinition.builder((String)"transaction-manager-lookup", (Object)GenericTransactionManagerLookup.INSTANCE).copier(IdentityAttributeCopier.INSTANCE).autoPersist(false).build();
    public static final AttributeDefinition<TransactionSynchronizationRegistryLookup> TRANSACTION_SYNCHRONIZATION_REGISTRY_LOOKUP = AttributeDefinition.builder((String)"transaction-synchronization-registry-lookup", null, TransactionSynchronizationRegistryLookup.class).copier(IdentityAttributeCopier.INSTANCE).autoPersist(false).build();
    public static final AttributeDefinition<TransactionMode> TRANSACTION_MODE = AttributeDefinition.builder((String)"mode", (Object)((Object)TransactionMode.NON_TRANSACTIONAL)).immutable().autoPersist(false).build();
    public static final AttributeDefinition<Boolean> USE_SYNCHRONIZATION = AttributeDefinition.builder((String)"synchronization", (Object)false).immutable().autoPersist(false).build();
    public static final AttributeDefinition<Boolean> USE_1_PC_FOR_AUTO_COMMIT_TRANSACTIONS = AttributeDefinition.builder((String)"single-phase-auto-commit", (Object)false).build();
    public static final AttributeDefinition<Long> REAPER_WAKE_UP_INTERVAL = AttributeDefinition.builder((String)"reaper-wake-up-interval", (Object)30000L).immutable().xmlName("reaper-interval").build();
    public static final AttributeDefinition<Long> COMPLETED_TX_TIMEOUT = AttributeDefinition.builder((String)"complete-timeout", (Object)60000L).immutable().build();
    public static final AttributeDefinition<TransactionProtocol> TRANSACTION_PROTOCOL = AttributeDefinition.builder((String)"transaction-protocol", (Object)((Object)TransactionProtocol.DEFAULT)).immutable().xmlName("protocol").build();
    public static final AttributeDefinition<Boolean> NOTIFICATIONS = AttributeDefinition.builder((String)"notifications", (Object)true).immutable().build();
    private final Attribute<Boolean> autoCommit;
    private final Attribute<Long> cacheStopTimeout;
    private final Attribute<LockingMode> lockingMode;
    private final Attribute<TransactionManagerLookup> transactionManagerLookup;
    private final Attribute<TransactionSynchronizationRegistryLookup> transactionSynchronizationRegistryLookup;
    private final Attribute<TransactionMode> transactionMode;
    private final Attribute<Boolean> useSynchronization;
    private final Attribute<Boolean> use1PcForAutoCommitTransactions;
    private final Attribute<Long> reaperWakeUpInterval;
    private final Attribute<Long> completedTxTimeout;
    private final Attribute<TransactionProtocol> transactionProtocol;
    private final Attribute<Boolean> notifications;
    private final AttributeSet attributes;
    private final RecoveryConfiguration recovery;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(TransactionConfiguration.class, new AttributeDefinition[]{AUTO_COMMIT, CACHE_STOP_TIMEOUT, LOCKING_MODE, TRANSACTION_MANAGER_LOOKUP, TRANSACTION_SYNCHRONIZATION_REGISTRY_LOOKUP, TRANSACTION_MODE, USE_SYNCHRONIZATION, USE_1_PC_FOR_AUTO_COMMIT_TRANSACTIONS, REAPER_WAKE_UP_INTERVAL, COMPLETED_TX_TIMEOUT, TRANSACTION_PROTOCOL, NOTIFICATIONS});
    }

    TransactionConfiguration(AttributeSet attributes, RecoveryConfiguration recovery) {
        this.attributes = attributes.checkProtection();
        this.autoCommit = attributes.attribute(AUTO_COMMIT);
        this.cacheStopTimeout = attributes.attribute(CACHE_STOP_TIMEOUT);
        this.lockingMode = attributes.attribute(LOCKING_MODE);
        this.transactionManagerLookup = attributes.attribute(TRANSACTION_MANAGER_LOOKUP);
        this.transactionSynchronizationRegistryLookup = attributes.attribute(TRANSACTION_SYNCHRONIZATION_REGISTRY_LOOKUP);
        this.transactionMode = attributes.attribute(TRANSACTION_MODE);
        this.useSynchronization = attributes.attribute(USE_SYNCHRONIZATION);
        this.use1PcForAutoCommitTransactions = attributes.attribute(USE_1_PC_FOR_AUTO_COMMIT_TRANSACTIONS);
        this.reaperWakeUpInterval = attributes.attribute(REAPER_WAKE_UP_INTERVAL);
        this.completedTxTimeout = attributes.attribute(COMPLETED_TX_TIMEOUT);
        this.transactionProtocol = attributes.attribute(TRANSACTION_PROTOCOL);
        this.notifications = attributes.attribute(NOTIFICATIONS);
        this.recovery = recovery;
    }

    public boolean autoCommit() {
        return (Boolean)this.autoCommit.get();
    }

    public TransactionConfiguration cacheStopTimeout(long l) {
        this.cacheStopTimeout.set((Object)l);
        return this;
    }

    public long cacheStopTimeout() {
        return (Long)this.cacheStopTimeout.get();
    }

    public LockingMode lockingMode() {
        return (LockingMode)((Object)this.lockingMode.get());
    }

    public TransactionConfiguration lockingMode(LockingMode lockingMode) {
        this.lockingMode.set((Object)lockingMode);
        return this;
    }

    @Deprecated
    public boolean syncCommitPhase() {
        return true;
    }

    @Deprecated
    public TransactionConfiguration syncCommitPhase(boolean b) {
        return this;
    }

    @Deprecated
    public boolean syncRollbackPhase() {
        return true;
    }

    @Deprecated
    public TransactionConfiguration syncRollbackPhase(boolean b) {
        return this;
    }

    public TransactionManagerLookup transactionManagerLookup() {
        return (TransactionManagerLookup)this.transactionManagerLookup.get();
    }

    @Deprecated
    public TransactionConfiguration transactionManagerLookup(TransactionManagerLookup transactionManagerLookup) {
        this.transactionManagerLookup.set((Object)transactionManagerLookup);
        return this;
    }

    public TransactionSynchronizationRegistryLookup transactionSynchronizationRegistryLookup() {
        return (TransactionSynchronizationRegistryLookup)this.transactionSynchronizationRegistryLookup.get();
    }

    public TransactionMode transactionMode() {
        return (TransactionMode)((Object)this.transactionMode.get());
    }

    public boolean useSynchronization() {
        return (Boolean)this.useSynchronization.get();
    }

    public RecoveryConfiguration recovery() {
        return this.recovery;
    }

    public long reaperWakeUpInterval() {
        return (Long)this.reaperWakeUpInterval.get();
    }

    public long completedTxTimeout() {
        return (Long)this.completedTxTimeout.get();
    }

    public boolean use1PcForAutoCommitTransactions() {
        return (Boolean)this.use1PcForAutoCommitTransactions.get();
    }

    public TransactionProtocol transactionProtocol() {
        return (TransactionProtocol)((Object)this.transactionProtocol.get());
    }

    public boolean notifications() {
        return (Boolean)this.notifications.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "TransactionConfiguration [attributes=" + this.attributes + ", recovery=" + this.recovery + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransactionConfiguration other = (TransactionConfiguration)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals((Object)other.attributes)) {
            return false;
        }
        return !(this.recovery == null ? other.recovery != null : !this.recovery.equals(other.recovery));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.recovery == null ? 0 : this.recovery.hashCode());
        return result;
    }
}

