/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.core;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.persistence.spi.PersistenceException;

public class MarshalledEntryImpl<K, V>
implements MarshalledEntry<K, V> {
    private ByteBuffer keyBytes;
    private ByteBuffer valueBytes;
    private ByteBuffer metadataBytes;
    private transient K key;
    private transient V value;
    private transient InternalMetadata metadata;
    private final transient StreamingMarshaller marshaller;

    public MarshalledEntryImpl(ByteBuffer key, ByteBuffer valueBytes, ByteBuffer metadataBytes, StreamingMarshaller marshaller) {
        this.keyBytes = key;
        this.valueBytes = valueBytes;
        this.metadataBytes = metadataBytes;
        this.marshaller = marshaller;
    }

    public MarshalledEntryImpl(K key, ByteBuffer valueBytes, ByteBuffer metadataBytes, StreamingMarshaller marshaller) {
        this.key = key;
        this.valueBytes = valueBytes;
        this.metadataBytes = metadataBytes;
        this.marshaller = marshaller;
    }

    public MarshalledEntryImpl(K key, V value, InternalMetadata im, StreamingMarshaller sm) {
        this.key = key;
        this.value = value;
        this.metadata = im;
        this.marshaller = sm;
    }

    @Override
    public K getKey() {
        if (this.key == null) {
            if (this.keyBytes == null) {
                return null;
            }
            this.key = this.unmarshall(this.keyBytes);
        }
        return this.key;
    }

    @Override
    public V getValue() {
        if (this.value == null) {
            if (this.valueBytes == null) {
                return null;
            }
            this.value = this.unmarshall(this.valueBytes);
        }
        return this.value;
    }

    @Override
    public InternalMetadata getMetadata() {
        if (this.metadata == null) {
            if (this.metadataBytes == null) {
                return null;
            }
            this.metadata = (InternalMetadata)this.unmarshall(this.metadataBytes);
        }
        return this.metadata;
    }

    @Override
    public ByteBuffer getKeyBytes() {
        if (this.keyBytes == null) {
            if (this.key == null) {
                return null;
            }
            this.keyBytes = this.marshall(this.key);
        }
        return this.keyBytes;
    }

    @Override
    public ByteBuffer getValueBytes() {
        if (this.valueBytes == null) {
            if (this.value == null) {
                return null;
            }
            this.valueBytes = this.marshall(this.value);
        }
        return this.valueBytes;
    }

    @Override
    public ByteBuffer getMetadataBytes() {
        if (this.metadataBytes == null) {
            if (this.metadata == null) {
                return null;
            }
            this.metadataBytes = this.marshall(this.metadata);
        }
        return this.metadataBytes;
    }

    private ByteBuffer marshall(Object obj) {
        try {
            return this.marshaller.objectToBuffer(obj);
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    private <T> T unmarshall(ByteBuffer buf) {
        try {
            return (T)this.marshaller.objectFromByteBuffer(buf.getBuf(), buf.getOffset(), buf.getLength());
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MarshalledEntryImpl)) {
            return false;
        }
        MarshalledEntryImpl that = (MarshalledEntryImpl)o;
        if (this.getKeyBytes() != null ? !this.getKeyBytes().equals(that.getKeyBytes()) : that.getKeyBytes() != null) {
            return false;
        }
        if (this.getMetadataBytes() != null ? !this.getMetadataBytes().equals(that.getMetadataBytes()) : that.getMetadataBytes() != null) {
            return false;
        }
        return !(this.getValueBytes() != null ? !this.getValueBytes().equals(that.getValueBytes()) : that.getValueBytes() != null);
    }

    public int hashCode() {
        int result = this.getKeyBytes() != null ? this.getKeyBytes().hashCode() : 0;
        result = 31 * result + (this.getValueBytes() != null ? this.getValueBytes().hashCode() : 0);
        result = 31 * result + (this.getMetadataBytes() != null ? this.getMetadataBytes().hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("MarshalledEntryImpl{").append("keyBytes=").append(this.keyBytes).append(", valueBytes=").append(this.valueBytes).append(", metadataBytes=").append(this.metadataBytes).append(", key=").append(this.key);
        if (this.key == null && this.keyBytes != null && this.marshaller != null) {
            sb.append('/').append(this.unmarshall(this.keyBytes));
        }
        sb.append(", value=").append(this.value);
        if (this.value == null && this.valueBytes != null && this.marshaller != null) {
            sb.append('/').append(this.unmarshall(this.valueBytes));
        }
        sb.append(", metadata=").append(this.metadata);
        if (this.metadata == null && this.metadataBytes != null && this.marshaller != null) {
            sb.append('/').append(this.unmarshall(this.metadataBytes));
        }
        sb.append(", marshaller=").append(this.marshaller).append('}');
        return sb.toString();
    }

    public static class Externalizer
    extends AbstractExternalizer<MarshalledEntryImpl> {
        private static final long serialVersionUID = -5291318076267612501L;
        private final StreamingMarshaller marshaller;

        public Externalizer(StreamingMarshaller marshaller) {
            this.marshaller = marshaller;
        }

        public void writeObject(ObjectOutput output, MarshalledEntryImpl me) throws IOException {
            output.writeObject(me.getKeyBytes());
            output.writeObject(me.getValueBytes());
            output.writeObject(me.getMetadataBytes());
        }

        public MarshalledEntryImpl readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            ByteBuffer keyBytes = (ByteBuffer)input.readObject();
            ByteBuffer valueBytes = (ByteBuffer)input.readObject();
            ByteBuffer metadataBytes = (ByteBuffer)input.readObject();
            return new MarshalledEntryImpl(keyBytes, valueBytes, metadataBytes, this.marshaller);
        }

        public Integer getId() {
            return 62;
        }

        public Set<Class<? extends MarshalledEntryImpl>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{MarshalledEntryImpl.class});
        }
    }
}

