/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.configuration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.infinispan.api.configuration.Configuration;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.util.Features;
import org.infinispan.hotrod.configuration.ClientIntelligence;
import org.infinispan.hotrod.configuration.ClusterConfiguration;
import org.infinispan.hotrod.configuration.ConnectionPoolConfiguration;
import org.infinispan.hotrod.configuration.ExecutorFactoryConfiguration;
import org.infinispan.hotrod.configuration.FailoverRequestBalancingStrategy;
import org.infinispan.hotrod.configuration.ProtocolVersion;
import org.infinispan.hotrod.configuration.RemoteCacheConfiguration;
import org.infinispan.hotrod.configuration.RemoteCacheConfigurationBuilder;
import org.infinispan.hotrod.configuration.SecurityConfiguration;
import org.infinispan.hotrod.configuration.ServerConfiguration;
import org.infinispan.hotrod.configuration.StatisticsConfiguration;
import org.infinispan.hotrod.configuration.TransportFactory;
import org.infinispan.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.hotrod.impl.logging.Log;
import org.infinispan.protostream.SerializationContextInitializer;

public class HotRodConfiguration
extends ConfigurationElement<HotRodConfiguration>
implements Configuration {
    static final AttributeDefinition<String[]> ALLOW_LIST = AttributeDefinition.builder((String)"allow_list", (Object)new String[0], String[].class).immutable().build();
    static final AttributeDefinition<Integer> BATCH_SIZE = AttributeDefinition.builder((String)"batch_size", (Object)10000, Integer.class).build();
    static final AttributeDefinition<ClientIntelligence> CLIENT_INTELLIGENCE = AttributeDefinition.builder((String)"client_intelligence", (Object)((Object)ClientIntelligence.getDefault()), ClientIntelligence.class).immutable().build();
    static final AttributeDefinition<Integer> CONNECT_TIMEOUT = AttributeDefinition.builder((String)"connect_timeout", (Object)10000, Integer.class).build();
    static final AttributeDefinition<Class[]> CONSISTENT_HASH_IMPL = AttributeDefinition.builder((String)"hash_function_impl", ConsistentHash.DEFAULT, Class[].class).immutable().build();
    static final AttributeDefinition<Integer> DNS_RESOLVER_MIN_TTL = AttributeDefinition.builder((String)"dns_resolver_min_ttl", (Object)0).build();
    static final AttributeDefinition<Integer> DNS_RESOLVER_MAX_TTL = AttributeDefinition.builder((String)"dns_resolver_max_ttl", (Object)Integer.MAX_VALUE).build();
    static final AttributeDefinition<Integer> DNS_RESOLVER_NEGATIVE_TTL = AttributeDefinition.builder((String)"dns_resolver_negative_ttl", (Object)0).build();
    static final AttributeDefinition<Boolean> FORCE_RETURN_VALUES = AttributeDefinition.builder((String)"force_return_values", (Object)false, Boolean.class).build();
    static final AttributeDefinition<Marshaller> MARSHALLER = AttributeDefinition.builder((String)"marshaller", null, Marshaller.class).immutable().initializer(ProtoStreamMarshaller::new).build();
    static final AttributeDefinition<Class> MARSHALLER_CLASS = AttributeDefinition.builder((String)"marshaller_class", ProtoStreamMarshaller.class, Class.class).immutable().build();
    static final AttributeDefinition<Integer> MAX_RETRIES = AttributeDefinition.builder((String)"max_retries", (Object)60000, Integer.class).validator(v -> {
        if (v < 0) {
            throw Log.HOTROD.invalidMaxRetries((int)v);
        }
    }).build();
    static final AttributeDefinition<Integer> SOCKET_TIMEOUT = AttributeDefinition.builder((String)"socket_timeout", (Object)60000, Integer.class).build();
    static final AttributeDefinition<Boolean> TCP_KEEPALIVE = AttributeDefinition.builder((String)"tcp_keepalive", (Object)true, Boolean.class).build();
    static final AttributeDefinition<Boolean> TCP_NODELAY = AttributeDefinition.builder((String)"tcp_no_delay", (Object)true, Boolean.class).build();
    static final AttributeDefinition<Long> TRANSACTION_TIMEOUT = AttributeDefinition.builder((String)"transaction_timeout", (Object)60000L, Long.class).build();
    static final AttributeDefinition<String> URI = AttributeDefinition.builder((String)"uri", null, String.class).immutable().build();
    static final AttributeDefinition<ProtocolVersion> VERSION = AttributeDefinition.builder((String)"version", (Object)((Object)ProtocolVersion.PROTOCOL_VERSION_AUTO), ProtocolVersion.class).build();
    private final ExecutorFactoryConfiguration asyncExecutorFactory;
    private final Supplier<FailoverRequestBalancingStrategy> balancingStrategyFactory;
    private final ConnectionPoolConfiguration connectionPool;
    private final List<ServerConfiguration> servers;
    private final SecurityConfiguration security;
    private final List<ClusterConfiguration> clusters;
    private final ClassAllowList classAllowList;
    private final StatisticsConfiguration statistics;
    private final Features features;
    private final List<SerializationContextInitializer> contextInitializers;
    private final Map<String, RemoteCacheConfiguration> remoteCaches;
    private final TransportFactory transportFactory;
    private final boolean tracingPropagationEnabled;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(HotRodConfiguration.class, new AttributeDefinition[]{ALLOW_LIST, BATCH_SIZE, CLIENT_INTELLIGENCE, CONNECT_TIMEOUT, CONSISTENT_HASH_IMPL, DNS_RESOLVER_MIN_TTL, DNS_RESOLVER_MAX_TTL, DNS_RESOLVER_NEGATIVE_TTL, FORCE_RETURN_VALUES, MARSHALLER, MARSHALLER_CLASS, MAX_RETRIES, SOCKET_TIMEOUT, TCP_KEEPALIVE, TCP_NODELAY, TRANSACTION_TIMEOUT, URI, VERSION});
    }

    HotRodConfiguration(AttributeSet attributes, ExecutorFactoryConfiguration asyncExecutorFactory, Supplier<FailoverRequestBalancingStrategy> balancingStrategyFactory, ConnectionPoolConfiguration connectionPool, List<ServerConfiguration> servers, SecurityConfiguration security, List<ClusterConfiguration> clusters, StatisticsConfiguration statistics, Features features, List<SerializationContextInitializer> contextInitializers, Map<String, RemoteCacheConfiguration> remoteCaches, TransportFactory transportFactory, boolean tracingPropagationEnabled) {
        super("", attributes, new ConfigurationElement[0]);
        this.asyncExecutorFactory = asyncExecutorFactory;
        this.balancingStrategyFactory = balancingStrategyFactory;
        this.connectionPool = connectionPool;
        this.servers = Collections.unmodifiableList(servers);
        this.security = security;
        this.clusters = clusters;
        this.classAllowList = new ClassAllowList(Arrays.asList((String[])attributes.attribute(ALLOW_LIST).get()));
        this.statistics = statistics;
        this.features = features;
        this.contextInitializers = contextInitializers;
        this.remoteCaches = remoteCaches;
        this.transportFactory = transportFactory;
        this.tracingPropagationEnabled = tracingPropagationEnabled;
    }

    public ExecutorFactoryConfiguration asyncExecutorFactory() {
        return this.asyncExecutorFactory;
    }

    public Supplier<FailoverRequestBalancingStrategy> balancingStrategyFactory() {
        return this.balancingStrategyFactory;
    }

    public ClientIntelligence clientIntelligence() {
        return (ClientIntelligence)((Object)this.attributes.attribute(CLIENT_INTELLIGENCE).get());
    }

    public ConnectionPoolConfiguration connectionPool() {
        return this.connectionPool;
    }

    public int connectionTimeout() {
        return (Integer)this.attributes.attribute(CONNECT_TIMEOUT).get();
    }

    public Class<? extends ConsistentHash>[] consistentHashImpl() {
        Class[] classes = (Class[])this.attributes.attribute(CONSISTENT_HASH_IMPL).get();
        return Arrays.copyOf(classes, classes.length);
    }

    public Class<? extends ConsistentHash> consistentHashImpl(int version) {
        return ((Class[])this.attributes.attribute(CONSISTENT_HASH_IMPL).get())[version - 1];
    }

    public int dnsResolverMinTTL() {
        return (Integer)this.attributes.attribute(DNS_RESOLVER_MIN_TTL).get();
    }

    public int dnsResolverMaxTTL() {
        return (Integer)this.attributes.attribute(DNS_RESOLVER_MAX_TTL).get();
    }

    public int dnsResolverNegativeTTL() {
        return (Integer)this.attributes.attribute(DNS_RESOLVER_NEGATIVE_TTL).get();
    }

    public boolean forceReturnValues() {
        return (Boolean)this.attributes.attribute(FORCE_RETURN_VALUES).get();
    }

    public Marshaller marshaller() {
        return (Marshaller)this.attributes.attribute(MARSHALLER).get();
    }

    public Class<? extends Marshaller> marshallerClass() {
        return (Class)this.attributes.attribute(MARSHALLER_CLASS).get();
    }

    public ProtocolVersion version() {
        return (ProtocolVersion)((Object)this.attributes.attribute(VERSION).get());
    }

    public List<ServerConfiguration> servers() {
        return this.servers;
    }

    public List<ClusterConfiguration> clusters() {
        return this.clusters;
    }

    public int socketTimeout() {
        return (Integer)this.attributes.attribute(SOCKET_TIMEOUT).get();
    }

    public SecurityConfiguration security() {
        return this.security;
    }

    public boolean tcpNoDelay() {
        return (Boolean)this.attributes.attribute(TCP_NODELAY).get();
    }

    public boolean tcpKeepAlive() {
        return (Boolean)this.attributes.attribute(TCP_KEEPALIVE).get();
    }

    public int maxRetries() {
        return (Integer)this.attributes.attribute(MAX_RETRIES).get();
    }

    public String[] serialAllowList() {
        return (String[])this.attributes.attribute(ALLOW_LIST).get();
    }

    public ClassAllowList getClassAllowList() {
        return this.classAllowList;
    }

    public int batchSize() {
        return (Integer)this.attributes.attribute(BATCH_SIZE).get();
    }

    public Map<String, RemoteCacheConfiguration> remoteCaches() {
        return Collections.unmodifiableMap(this.remoteCaches);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteCacheConfiguration addRemoteCache(String name, Consumer<RemoteCacheConfigurationBuilder> builderConsumer) {
        Map<String, RemoteCacheConfiguration> map = this.remoteCaches;
        synchronized (map) {
            if (this.remoteCaches.containsKey(name)) {
                throw Log.HOTROD.duplicateCacheConfiguration(name);
            }
            RemoteCacheConfigurationBuilder builder = new RemoteCacheConfigurationBuilder(null, name);
            builderConsumer.accept(builder);
            builder.validate();
            RemoteCacheConfiguration configuration = builder.create();
            this.remoteCaches.put(name, configuration);
            return configuration;
        }
    }

    public void removeRemoteCache(String name) {
        this.remoteCaches.remove(name);
    }

    public StatisticsConfiguration statistics() {
        return this.statistics;
    }

    public long transactionTimeout() {
        return (Long)this.attributes.attribute(TRANSACTION_TIMEOUT).get();
    }

    public Features features() {
        return this.features;
    }

    public List<SerializationContextInitializer> getContextInitializers() {
        return this.contextInitializers;
    }

    public TransportFactory transportFactory() {
        return this.transportFactory;
    }

    public boolean tracingPropagationEnabled() {
        return this.tracingPropagationEnabled;
    }
}

