/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.multimap;

import java.util.Collection;
import java.util.concurrent.CompletionStage;
import org.infinispan.api.common.CacheEntryCollection;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.commons.marshall.AdaptiveBufferSizePredictor;
import org.infinispan.commons.marshall.BufferSizePredictor;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.hotrod.exceptions.RemoteCacheManagerNotStartedException;
import org.infinispan.hotrod.impl.HotRodTransport;
import org.infinispan.hotrod.impl.cache.RemoteCacheImpl;
import org.infinispan.hotrod.impl.logging.Log;
import org.infinispan.hotrod.impl.logging.LogFactory;
import org.infinispan.hotrod.impl.multimap.operations.ContainsEntryMultimapOperation;
import org.infinispan.hotrod.impl.multimap.operations.ContainsKeyMultimapOperation;
import org.infinispan.hotrod.impl.multimap.operations.ContainsValueMultimapOperation;
import org.infinispan.hotrod.impl.multimap.operations.GetKeyMultimapOperation;
import org.infinispan.hotrod.impl.multimap.operations.GetKeyWithMetadataMultimapOperation;
import org.infinispan.hotrod.impl.multimap.operations.MultimapOperationsFactory;
import org.infinispan.hotrod.impl.multimap.operations.PutKeyValueMultimapOperation;
import org.infinispan.hotrod.impl.multimap.operations.RemoveEntryMultimapOperation;
import org.infinispan.hotrod.impl.multimap.operations.RemoveKeyMultimapOperation;
import org.infinispan.hotrod.marshall.MarshallerUtil;
import org.infinispan.hotrod.multimap.RemoteMultimapCache;

public class RemoteMultimapCacheImpl<K, V>
implements RemoteMultimapCache<K, V> {
    private static final Log log = LogFactory.getLog(RemoteMultimapCacheImpl.class, Log.class);
    private final RemoteCacheImpl<K, Collection<V>> cache;
    private final HotRodTransport hotRodTransport;
    private MultimapOperationsFactory operationsFactory;
    private Marshaller marshaller;
    private final BufferSizePredictor keySizePredictor = new AdaptiveBufferSizePredictor();
    private final BufferSizePredictor valueSizePredictor = new AdaptiveBufferSizePredictor();
    private final boolean supportsDuplicates;

    public void init() {
        this.operationsFactory = new MultimapOperationsFactory(this.hotRodTransport.getChannelFactory(), this.cache.getName(), this.hotRodTransport.getConfiguration(), this.hotRodTransport.getCodec(), this.cache.getDataFormat(), this.cache.getClientStatistics());
        this.marshaller = this.hotRodTransport.getMarshaller();
    }

    public RemoteMultimapCacheImpl(HotRodTransport hotRodTransport, RemoteCacheImpl<K, Collection<V>> cache) {
        this(hotRodTransport, cache, false);
    }

    public RemoteMultimapCacheImpl(HotRodTransport hotRodTransport, RemoteCacheImpl<K, Collection<V>> cache, boolean supportsDuplicates) {
        if (log.isTraceEnabled()) {
            log.tracef("Creating multimap remote cache: %s", cache.getName());
        }
        this.cache = cache;
        this.hotRodTransport = hotRodTransport;
        this.supportsDuplicates = supportsDuplicates;
    }

    @Override
    public CompletionStage<Void> put(K key, V value, CacheWriteOptions options) {
        if (log.isTraceEnabled()) {
            log.tracef("About to add (K,V): (%s, %s) %s", key, value, options);
        }
        this.assertRemoteCacheManagerIsStarted();
        K objectKey = this.isObjectStorage() ? key : null;
        byte[] marshallKey = MarshallerUtil.obj2bytes(this.marshaller, key, this.keySizePredictor);
        byte[] marshallValue = MarshallerUtil.obj2bytes(this.marshaller, value, this.valueSizePredictor);
        PutKeyValueMultimapOperation<K> op = this.operationsFactory.newPutKeyValueOperation(objectKey, marshallKey, marshallValue, CacheWriteOptions.DEFAULT, this.supportsDuplicates);
        return op.execute();
    }

    @Override
    public CompletionStage<Collection<V>> get(K key, CacheOptions options) {
        if (log.isTraceEnabled()) {
            log.tracef("About to call get (K): (%s)", key);
        }
        this.assertRemoteCacheManagerIsStarted();
        K objectKey = this.isObjectStorage() ? key : null;
        byte[] marshallKey = MarshallerUtil.obj2bytes(this.marshaller, key, this.keySizePredictor);
        GetKeyMultimapOperation gco = this.operationsFactory.newGetKeyMultimapOperation(objectKey, marshallKey, options, this.supportsDuplicates);
        return gco.execute();
    }

    @Override
    public CompletionStage<CacheEntryCollection<K, V>> getWithMetadata(K key, CacheOptions options) {
        if (log.isTraceEnabled()) {
            log.tracef("About to call getWithMetadata (K): (%s)", key);
        }
        this.assertRemoteCacheManagerIsStarted();
        K objectKey = this.isObjectStorage() ? key : null;
        byte[] marshallKey = MarshallerUtil.obj2bytes(this.marshaller, key, this.keySizePredictor);
        GetKeyWithMetadataMultimapOperation operation = this.operationsFactory.newGetKeyWithMetadataMultimapOperation(objectKey, marshallKey, options, this.supportsDuplicates);
        return operation.execute();
    }

    @Override
    public CompletionStage<Boolean> remove(K key, CacheOptions options) {
        if (log.isTraceEnabled()) {
            log.tracef("About to remove (K): (%s)", key);
        }
        this.assertRemoteCacheManagerIsStarted();
        K objectKey = this.isObjectStorage() ? key : null;
        byte[] marshallKey = MarshallerUtil.obj2bytes(this.marshaller, key, this.keySizePredictor);
        RemoveKeyMultimapOperation<K> removeOperation = this.operationsFactory.newRemoveKeyOperation(objectKey, marshallKey, options, this.supportsDuplicates);
        return removeOperation.execute();
    }

    @Override
    public CompletionStage<Boolean> remove(K key, V value, CacheOptions options) {
        if (log.isTraceEnabled()) {
            log.tracef("About to remove (K,V): (%s, %s)", key, value);
        }
        this.assertRemoteCacheManagerIsStarted();
        K objectKey = this.isObjectStorage() ? key : null;
        byte[] marshallKey = MarshallerUtil.obj2bytes(this.marshaller, key, this.keySizePredictor);
        byte[] marshallValue = MarshallerUtil.obj2bytes(this.marshaller, value, this.valueSizePredictor);
        RemoveEntryMultimapOperation<K> removeOperation = this.operationsFactory.newRemoveEntryOperation(objectKey, marshallKey, marshallValue, options, this.supportsDuplicates);
        return removeOperation.execute();
    }

    @Override
    public CompletionStage<Boolean> containsKey(K key, CacheOptions options) {
        if (log.isTraceEnabled()) {
            log.tracef("About to call contains (K): (%s)", key);
        }
        this.assertRemoteCacheManagerIsStarted();
        K objectKey = this.isObjectStorage() ? key : null;
        byte[] marshallKey = MarshallerUtil.obj2bytes(this.marshaller, key, this.keySizePredictor);
        ContainsKeyMultimapOperation<K> containsKeyOperation = this.operationsFactory.newContainsKeyOperation(objectKey, marshallKey, options, this.supportsDuplicates);
        return containsKeyOperation.execute();
    }

    @Override
    public CompletionStage<Boolean> containsValue(V value, CacheOptions options) {
        if (log.isTraceEnabled()) {
            log.tracef("About to call contains (V): (%s)", value);
        }
        this.assertRemoteCacheManagerIsStarted();
        byte[] marshallValue = MarshallerUtil.obj2bytes(this.marshaller, value, this.valueSizePredictor);
        ContainsValueMultimapOperation containsValueOperation = this.operationsFactory.newContainsValueOperation(marshallValue, options, this.supportsDuplicates);
        return containsValueOperation.execute();
    }

    @Override
    public CompletionStage<Boolean> containsEntry(K key, V value, CacheOptions options) {
        if (log.isTraceEnabled()) {
            log.tracef("About to call contais(K,V): (%s, %s)", key, value);
        }
        this.assertRemoteCacheManagerIsStarted();
        K objectKey = this.isObjectStorage() ? key : null;
        byte[] marshallKey = MarshallerUtil.obj2bytes(this.marshaller, key, this.keySizePredictor);
        byte[] marshallValue = MarshallerUtil.obj2bytes(this.marshaller, value, this.valueSizePredictor);
        ContainsEntryMultimapOperation<K> containsOperation = this.operationsFactory.newContainsEntryOperation(objectKey, marshallKey, marshallValue, options, this.supportsDuplicates);
        return containsOperation.execute();
    }

    @Override
    public CompletionStage<Long> size(CacheOptions options) {
        if (log.isTraceEnabled()) {
            log.trace("About to call size");
        }
        this.assertRemoteCacheManagerIsStarted();
        return this.operationsFactory.newSizeOperation(this.supportsDuplicates).execute();
    }

    @Override
    public boolean supportsDuplicates() {
        return this.supportsDuplicates;
    }

    private void assertRemoteCacheManagerIsStarted() {
        if (!this.hotRodTransport.isStarted()) {
            String message = "Cannot perform operations on a multimap cache associated with an unstarted RemoteMultimapCacheManager.";
            if (log.isInfoEnabled()) {
                log.unstartedRemoteCacheManager();
            }
            throw new RemoteCacheManagerNotStartedException(message);
        }
    }

    private boolean isObjectStorage() {
        return this.cache.isObjectStorage();
    }
}

