/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.configuration;

import java.util.Map;
import java.util.Properties;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.hotrod.configuration.AbstractConfigurationChildBuilder;
import org.infinispan.hotrod.configuration.ExhaustedAction;
import org.infinispan.hotrod.configuration.HotRodConfigurationBuilder;
import org.infinispan.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.hotrod.configuration.NearCacheFactory;
import org.infinispan.hotrod.configuration.NearCacheMode;
import org.infinispan.hotrod.impl.logging.Log;

public class NearCacheConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<NearCacheConfiguration> {
    private final AttributeSet attributes = NearCacheConfiguration.attributeDefinitionSet();

    NearCacheConfigurationBuilder(HotRodConfigurationBuilder builder) {
        super(builder);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public NearCacheConfigurationBuilder maxEntries(int maxEntries) {
        this.attributes.attribute(NearCacheConfiguration.MAX_ENTRIES).set((Object)maxEntries);
        return this;
    }

    public NearCacheConfigurationBuilder bloomFilter(boolean enable) {
        this.attributes.attribute(NearCacheConfiguration.BLOOM_FILTER).set((Object)enable);
        return this;
    }

    public NearCacheConfigurationBuilder mode(NearCacheMode mode) {
        this.attributes.attribute(NearCacheConfiguration.MODE).set((Object)mode);
        return this;
    }

    public NearCacheConfigurationBuilder nearCacheFactory(NearCacheFactory factory) {
        this.attributes.attribute(NearCacheConfiguration.FACTORY).set((Object)factory);
        return this;
    }

    public void validate() {
        if (((NearCacheMode)((Object)this.attributes.attribute(NearCacheConfiguration.MODE).get())).enabled()) {
            if (this.attributes.attribute(NearCacheConfiguration.MAX_ENTRIES).isNull()) {
                throw Log.HOTROD.nearCacheMaxEntriesUndefined();
            }
            int maxEntries = (Integer)this.attributes.attribute(NearCacheConfiguration.MAX_ENTRIES).get();
            boolean bloomFilter = (Boolean)this.attributes.attribute(NearCacheConfiguration.BLOOM_FILTER).get();
            if (maxEntries < 0 && bloomFilter) {
                throw Log.HOTROD.nearCacheMaxEntriesPositiveWithBloom(maxEntries);
            }
            if (bloomFilter) {
                int maxActive = this.connectionPool().maxActive();
                ExhaustedAction exhaustedAction = this.connectionPool().exhaustedAction();
                if (maxActive != 1 || exhaustedAction != ExhaustedAction.WAIT) {
                    throw Log.HOTROD.bloomFilterRequiresMaxActiveOneAndWait(maxEntries, exhaustedAction);
                }
            }
        }
    }

    public NearCacheConfiguration create() {
        return new NearCacheConfiguration(this.attributes.protect());
    }

    public NearCacheConfigurationBuilder read(NearCacheConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    @Override
    public HotRodConfigurationBuilder withProperties(Properties properties) {
        TypedProperties typed = TypedProperties.toTypedProperties((Map)properties);
        if (typed.containsKey((Object)"infinispan.client.hotrod.near_cache.max_entries")) {
            this.maxEntries(typed.getIntProperty("infinispan.client.hotrod.near_cache.max_entries", -1));
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.near_cache.mode")) {
            this.mode(NearCacheMode.valueOf(typed.getProperty("infinispan.client.hotrod.near_cache.mode")));
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.near_cache.bloom_filter")) {
            this.bloomFilter(typed.getBooleanProperty("infinispan.client.hotrod.near_cache.bloom_filter", false));
        }
        return this.builder;
    }
}

