/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.cache;

import jakarta.transaction.TransactionManager;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import org.infinispan.api.async.AsyncCacheEntryProcessor;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.api.common.CacheEntryVersion;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.api.common.events.cache.CacheEntryEvent;
import org.infinispan.api.common.events.cache.CacheEntryEventType;
import org.infinispan.api.common.events.cache.CacheListenerOptions;
import org.infinispan.api.common.process.CacheEntryProcessorResult;
import org.infinispan.api.common.process.CacheProcessorOptions;
import org.infinispan.api.configuration.CacheConfiguration;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.HotRodTransport;
import org.infinispan.hotrod.impl.cache.RemoteQuery;
import org.infinispan.hotrod.impl.operations.CacheOperationsFactory;
import org.infinispan.hotrod.impl.operations.RetryAwareCompletionStage;
import org.reactivestreams.Publisher;

public interface RemoteCache<K, V>
extends AutoCloseable {
    public CompletionStage<CacheConfiguration> configuration();

    public HotRodTransport getHotRodTransport();

    public CacheOperationsFactory getOperationsFactory();

    public CompletionStage<V> get(K var1, CacheOptions var2);

    public K keyAsObjectIfNeeded(Object var1);

    public byte[] keyToBytes(Object var1);

    public byte[] valueToBytes(Object var1);

    public CompletionStage<CacheEntry<K, V>> getEntry(K var1, CacheOptions var2);

    public RetryAwareCompletionStage<CacheEntry<K, V>> getEntry(K var1, CacheOptions var2, SocketAddress var3);

    public CompletionStage<CacheEntry<K, V>> putIfAbsent(K var1, V var2, CacheWriteOptions var3);

    public CompletionStage<Boolean> setIfAbsent(K var1, V var2, CacheWriteOptions var3);

    public CompletionStage<CacheEntry<K, V>> put(K var1, V var2, CacheWriteOptions var3);

    public CompletionStage<Void> set(K var1, V var2, CacheWriteOptions var3);

    public CompletionStage<Boolean> replace(K var1, V var2, CacheEntryVersion var3, CacheWriteOptions var4);

    public CompletionStage<CacheEntry<K, V>> getOrReplaceEntry(K var1, V var2, CacheEntryVersion var3, CacheWriteOptions var4);

    public CompletionStage<Boolean> remove(K var1, CacheOptions var2);

    public CompletionStage<Boolean> remove(K var1, CacheEntryVersion var2, CacheOptions var3);

    public CompletionStage<CacheEntry<K, V>> getAndRemove(K var1, CacheOptions var2);

    public Flow.Publisher<K> keys(CacheOptions var1);

    public Flow.Publisher<CacheEntry<K, V>> entries(CacheOptions var1);

    public CompletionStage<Void> putAll(Map<K, V> var1, CacheWriteOptions var2);

    public CompletionStage<Void> putAll(Flow.Publisher<CacheEntry<K, V>> var1, CacheWriteOptions var2);

    public Flow.Publisher<CacheEntry<K, V>> getAll(Set<K> var1, CacheOptions var2);

    public Flow.Publisher<CacheEntry<K, V>> getAll(CacheOptions var1, K[] var2);

    public Flow.Publisher<K> removeAll(Set<K> var1, CacheWriteOptions var2);

    public Flow.Publisher<K> removeAll(Flow.Publisher<K> var1, CacheWriteOptions var2);

    public Flow.Publisher<CacheEntry<K, V>> getAndRemoveAll(Set<K> var1, CacheWriteOptions var2);

    public Flow.Publisher<CacheEntry<K, V>> getAndRemoveAll(Flow.Publisher<K> var1, CacheWriteOptions var2);

    public CompletionStage<Long> estimateSize(CacheOptions var1);

    public CompletionStage<Void> clear(CacheOptions var1);

    public Flow.Publisher<CacheEntryEvent<K, V>> listen(CacheListenerOptions var1, CacheEntryEventType[] var2);

    public <T> Flow.Publisher<CacheEntryProcessorResult<K, T>> process(Set<K> var1, AsyncCacheEntryProcessor<K, V, T> var2, CacheOptions var3);

    public <T> Flow.Publisher<CacheEntryProcessorResult<K, T>> processAll(AsyncCacheEntryProcessor<K, V, T> var1, CacheProcessorOptions var2);

    default public CloseableIterator<CacheEntry<Object, Object>> retrieveEntries(String filterConverterFactory, Set<Integer> segments, int batchSize) {
        return this.retrieveEntries(filterConverterFactory, null, segments, batchSize);
    }

    public CloseableIterator<CacheEntry<Object, Object>> retrieveEntries(String var1, Object[] var2, Set<Integer> var3, int var4);

    public <T, U> RemoteCache<T, U> withDataFormat(DataFormat var1);

    public void resolveStorage(boolean var1);

    public CompletionStage<Void> updateBloomFilter();

    public SocketAddress addNearCacheListener(Object var1, int var2);

    public String getName();

    public DataFormat getDataFormat();

    public <E> Publisher<CacheEntry<K, E>> publishEntries(String var1, Object[] var2, Set<Integer> var3, int var4);

    public CloseableIterator<CacheEntry<Object, Object>> retrieveEntriesByQuery(RemoteQuery var1, Set<Integer> var2, int var3);

    public <E> Publisher<CacheEntry<K, E>> publishEntriesByQuery(RemoteQuery var1, Set<Integer> var2, int var3);

    public CloseableIterator<CacheEntry<Object, Object>> retrieveEntriesWithMetadata(Set<Integer> var1, int var2);

    public Publisher<CacheEntry<K, V>> publishEntriesWithMetadata(Set<Integer> var1, int var2);

    public TransactionManager getTransactionManager();

    public boolean isTransactional();
}

