/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.protocol;

import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.api.common.CacheEntryExpiration;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.events.cache.CacheEntryEventType;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.MediaTypeIds;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IteratorMapper;
import org.infinispan.counter.api.CounterState;
import org.infinispan.hotrod.configuration.ClientIntelligence;
import org.infinispan.hotrod.event.ClientEvent;
import org.infinispan.hotrod.event.ClientListener;
import org.infinispan.hotrod.event.impl.AbstractClientEvent;
import org.infinispan.hotrod.event.impl.CreatedEventImpl;
import org.infinispan.hotrod.event.impl.CustomEventImpl;
import org.infinispan.hotrod.event.impl.ExpiredEventImpl;
import org.infinispan.hotrod.event.impl.ModifiedEventImpl;
import org.infinispan.hotrod.event.impl.RemovedEventImpl;
import org.infinispan.hotrod.exceptions.HotRodClientException;
import org.infinispan.hotrod.exceptions.RemoteIllegalLifecycleStateException;
import org.infinispan.hotrod.exceptions.RemoteNodeSuspectException;
import org.infinispan.hotrod.impl.ClientTopology;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.TimeUnitParam;
import org.infinispan.hotrod.impl.cache.RemoteCache;
import org.infinispan.hotrod.impl.counter.HotRodCounterEvent;
import org.infinispan.hotrod.impl.logging.Log;
import org.infinispan.hotrod.impl.logging.LogFactory;
import org.infinispan.hotrod.impl.operations.AbstractKeyOperation;
import org.infinispan.hotrod.impl.operations.CacheOperationsFactory;
import org.infinispan.hotrod.impl.operations.PingResponse;
import org.infinispan.hotrod.impl.protocol.Codec;
import org.infinispan.hotrod.impl.protocol.CodecUtils;
import org.infinispan.hotrod.impl.protocol.HeaderParams;
import org.infinispan.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.hotrod.impl.transport.netty.ChannelFactory;

public class Codec40
implements Codec,
HotRodConstants {
    private static final Log log = LogFactory.getLog(Codec.class, Log.class);
    public static final String EMPTY_VALUE_CONVERTER = "org.infinispan.server.hotrod.HotRodServer$ToEmptyBytesKeyValueFilterConverter";

    @Override
    public HeaderParams writeHeader(ByteBuf buf, HeaderParams params) {
        HeaderParams headerParams = this.writeHeader(buf, params, (byte)40);
        this.writeDataTypes(buf, params.dataFormat);
        this.writeOtherParams(buf, params.otherParams);
        return headerParams;
    }

    protected void writeDataTypes(ByteBuf buf, DataFormat dataFormat) {
        MediaType keyType = null;
        MediaType valueType = null;
        if (dataFormat != null) {
            keyType = dataFormat.getKeyType();
            valueType = dataFormat.getValueType();
        }
        this.writeMediaType(buf, keyType);
        this.writeMediaType(buf, valueType);
    }

    private void writeMediaType(ByteBuf buf, MediaType mediaType) {
        if (mediaType == null) {
            buf.writeByte(0);
        } else {
            Short id = MediaTypeIds.getId((MediaType)mediaType);
            if (id != null) {
                buf.writeByte(1);
                ByteBufUtil.writeVInt(buf, id.shortValue());
            } else {
                buf.writeByte(2);
                ByteBufUtil.writeString(buf, mediaType.toString());
            }
            Map parameters = mediaType.getParameters();
            ByteBufUtil.writeVInt(buf, parameters.size());
            parameters.forEach((key, value) -> {
                ByteBufUtil.writeString(buf, key);
                ByteBufUtil.writeString(buf, value);
            });
        }
    }

    private void writeOtherParams(ByteBuf buf, Map<String, byte[]> parameters) {
        if (parameters == null) {
            ByteBufUtil.writeVInt(buf, 0);
            return;
        }
        ByteBufUtil.writeVInt(buf, parameters.size());
        parameters.forEach((key, value) -> {
            ByteBufUtil.writeString(buf, key);
            ByteBufUtil.writeArray(buf, value);
        });
    }

    @Override
    public void writeClientListenerInterests(ByteBuf buf, EnumSet<CacheEntryEventType> types) {
        byte listenerInterests = 0;
        if (types.contains(CacheEntryEventType.CREATED)) {
            listenerInterests = (byte)(listenerInterests | 1);
        }
        if (types.contains(CacheEntryEventType.UPDATED)) {
            listenerInterests = (byte)(listenerInterests | 2);
        }
        if (types.contains(CacheEntryEventType.REMOVED)) {
            listenerInterests = (byte)(listenerInterests | 4);
        }
        if (types.contains(CacheEntryEventType.EXPIRED)) {
            listenerInterests = (byte)(listenerInterests | 8);
        }
        ByteBufUtil.writeVInt(buf, listenerInterests);
    }

    @Override
    public void writeClientListenerParams(ByteBuf buf, ClientListener clientListener, byte[][] filterFactoryParams, byte[][] converterFactoryParams) {
        buf.writeByte((int)((short)(clientListener.includeCurrentState() ? 1 : 0)));
        this.writeNamedFactory(buf, clientListener.filterFactoryName(), filterFactoryParams);
        this.writeNamedFactory(buf, clientListener.converterFactoryName(), converterFactoryParams);
        buf.writeByte((int)((short)(clientListener.useRawData() ? 1 : 0)));
    }

    @Override
    public void writeExpirationParams(ByteBuf buf, CacheEntryExpiration.Impl expiration) {
        Duration maxIdle;
        byte timeUnits = TimeUnitParam.encodeTimeUnits(expiration);
        buf.writeByte((int)timeUnits);
        Duration lifespan = expiration.rawLifespan();
        if (lifespan != null && lifespan != Duration.ZERO) {
            ByteBufUtil.writeVLong(buf, lifespan.toSeconds());
        }
        if ((maxIdle = expiration.rawMaxIdle()) != null && lifespan != Duration.ZERO) {
            ByteBufUtil.writeVLong(buf, maxIdle.toSeconds());
        }
    }

    @Override
    public void writeBloomFilter(ByteBuf buf, int bloomFilterBits) {
        ByteBufUtil.writeVInt(buf, bloomFilterBits);
    }

    @Override
    public int estimateExpirationSize(CacheEntryExpiration.Impl expiration) {
        int lifespanSeconds = this.durationToSeconds(expiration.rawLifespan());
        int maxIdleSeconds = this.durationToSeconds(expiration.rawMaxIdle());
        return 1 + (lifespanSeconds > 0 ? ByteBufUtil.estimateVLongSize(lifespanSeconds) : 0) + (maxIdleSeconds > 0 ? ByteBufUtil.estimateVLongSize(maxIdleSeconds) : 0);
    }

    private int durationToSeconds(Duration duration) {
        return duration == null ? 0 : (int)duration.toSeconds();
    }

    private void writeNamedFactory(ByteBuf buf, String factoryName, byte[][] params) {
        ByteBufUtil.writeString(buf, factoryName);
        if (!factoryName.isEmpty()) {
            if (params != null) {
                buf.writeByte((int)((short)params.length));
                for (byte[] param : params) {
                    ByteBufUtil.writeArray(buf, param);
                }
            } else {
                buf.writeByte(0);
            }
        }
    }

    protected HeaderParams writeHeader(ByteBuf buf, HeaderParams params, byte version) {
        byte clientIntel;
        ClientTopology clientTopology = params.clientTopology.get();
        buf.writeByte(160);
        ByteBufUtil.writeVLong(buf, params.messageId);
        buf.writeByte((int)version);
        buf.writeByte((int)params.opCode);
        ByteBufUtil.writeArray(buf, params.cacheName);
        ByteBufUtil.writeVInt(buf, params.flags);
        params.clientIntelligence = clientIntel = clientTopology.getClientIntelligence().getValue();
        buf.writeByte((int)clientIntel);
        int topologyId = clientTopology.getTopologyId();
        ByteBufUtil.writeVInt(buf, topologyId);
        if (log.isTraceEnabled()) {
            log.tracef("[%s] Wrote header for messageId=%d. Operation code: %#04x(%s). Flags: %#x. Topology id: %s", new Object[]{new String(params.cacheName), params.messageId, params.opCode, HotRodConstants.Names.of(params.opCode), params.flags, topologyId});
        }
        return params;
    }

    @Override
    public int estimateHeaderSize(HeaderParams params) {
        return 1 + ByteBufUtil.estimateVLongSize(params.messageId) + 1 + 1 + ByteBufUtil.estimateArraySize(params.cacheName) + ByteBufUtil.estimateVIntSize(params.flags) + 1 + 1 + ByteBufUtil.estimateVIntSize(params.getClientTopology().get().getTopologyId());
    }

    @Override
    public long readMessageId(ByteBuf buf) {
        short magic = buf.readUnsignedByte();
        if (magic != 161) {
            if (log.isTraceEnabled()) {
                log.tracef("Socket dump: %s", ByteBufUtil.limitedHexDump(buf));
            }
            throw Log.HOTROD.invalidMagicNumber((short)161, magic);
        }
        return ByteBufUtil.readVLong(buf);
    }

    @Override
    public short readOpCode(ByteBuf buf) {
        return buf.readUnsignedByte();
    }

    @Override
    public short readHeader(ByteBuf buf, double receivedOpCode, HeaderParams params, ChannelFactory channelFactory, SocketAddress serverAddress) {
        short status = buf.readUnsignedByte();
        this.readNewTopologyIfPresent(buf, params, channelFactory);
        if (receivedOpCode != (double)params.opRespCode) {
            if (receivedOpCode == 80.0) {
                this.checkForErrorsInResponseStatus(buf, params, status, serverAddress);
            }
            throw Log.HOTROD.invalidResponse(new String(params.cacheName), params.opRespCode, receivedOpCode);
        }
        return status;
    }

    private static CounterState decodeOldState(short encoded) {
        switch (encoded & 3) {
            case 0: {
                return CounterState.VALID;
            }
            case 1: {
                return CounterState.LOWER_BOUND_REACHED;
            }
            case 2: {
                return CounterState.UPPER_BOUND_REACHED;
            }
        }
        throw new IllegalStateException();
    }

    private static CounterState decodeNewState(short encoded) {
        switch (encoded & 0xC) {
            case 0: {
                return CounterState.VALID;
            }
            case 4: {
                return CounterState.LOWER_BOUND_REACHED;
            }
            case 8: {
                return CounterState.UPPER_BOUND_REACHED;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public HotRodCounterEvent readCounterEvent(ByteBuf buf) {
        short status = buf.readByte();
        assert (status == 0);
        short topology = buf.readByte();
        assert (topology == 0);
        String counterName = ByteBufUtil.readString(buf);
        byte[] listenerId = ByteBufUtil.readArray(buf);
        short encodedCounterState = buf.readByte();
        long oldValue = buf.readLong();
        long newValue = buf.readLong();
        return new HotRodCounterEvent(listenerId, counterName, oldValue, Codec40.decodeOldState(encodedCounterState), newValue, Codec40.decodeNewState(encodedCounterState));
    }

    @Override
    public <K> CloseableIterator<K> keyIterator(RemoteCache<K, ?> remoteCache, CacheOperationsFactory cacheOperationsFactory, CacheOptions options, IntSet segments, int batchSize) {
        return new IteratorMapper(remoteCache.retrieveEntries(EMPTY_VALUE_CONVERTER, (Set<Integer>)segments, batchSize), e -> e.key());
    }

    @Override
    public <K, V> CloseableIterator<CacheEntry<K, V>> entryIterator(RemoteCache<K, V> remoteCache, IntSet segments, int batchSize) {
        return this.castEntryIterator(remoteCache.retrieveEntries(null, (Set<Integer>)segments, batchSize));
    }

    protected <K, V> CloseableIterator<CacheEntry<K, V>> castEntryIterator(CloseableIterator iterator) {
        return iterator;
    }

    @Override
    public boolean isObjectStorageHinted(PingResponse pingResponse) {
        return pingResponse.isObjectStorage();
    }

    @Override
    public AbstractClientEvent readCacheEvent(ByteBuf buf, Function<byte[], DataFormat> listenerDataFormat, short eventTypeId, ClassAllowList allowList, SocketAddress serverAddress) {
        ClientEvent.Type eventType;
        short status = buf.readUnsignedByte();
        buf.readUnsignedByte();
        switch (eventTypeId) {
            case 96: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED;
                break;
            }
            case 97: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED;
                break;
            }
            case 98: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED;
                break;
            }
            case 99: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_EXPIRED;
                break;
            }
            case 80: {
                this.checkForErrorsInResponseStatus(buf, null, status, serverAddress);
            }
            default: {
                throw Log.HOTROD.unknownEvent(eventTypeId);
            }
        }
        byte[] listenerId = ByteBufUtil.readArray(buf);
        short isCustom = buf.readUnsignedByte();
        boolean isRetried = buf.readUnsignedByte() == 1;
        DataFormat dataFormat = listenerDataFormat.apply(listenerId);
        if (isCustom == 1) {
            Object eventData = dataFormat.valueToObj(ByteBufUtil.readArray(buf), allowList);
            return this.createCustomEvent(listenerId, eventData, eventType, isRetried);
        }
        if (isCustom == 2) {
            return this.createCustomEvent(listenerId, ByteBufUtil.readArray(buf), eventType, isRetried);
        }
        switch (eventType) {
            case CLIENT_CACHE_ENTRY_CREATED: {
                Object createdKey = dataFormat.keyToObj(ByteBufUtil.readArray(buf), allowList);
                long createdDataVersion = buf.readLong();
                return this.createCreatedEvent(listenerId, createdKey, createdDataVersion, isRetried);
            }
            case CLIENT_CACHE_ENTRY_MODIFIED: {
                Object modifiedKey = dataFormat.keyToObj(ByteBufUtil.readArray(buf), allowList);
                long modifiedDataVersion = buf.readLong();
                return this.createModifiedEvent(listenerId, modifiedKey, modifiedDataVersion, isRetried);
            }
            case CLIENT_CACHE_ENTRY_REMOVED: {
                Object removedKey = dataFormat.keyToObj(ByteBufUtil.readArray(buf), allowList);
                return this.createRemovedEvent(listenerId, removedKey, isRetried);
            }
            case CLIENT_CACHE_ENTRY_EXPIRED: {
                Object expiredKey = dataFormat.keyToObj(ByteBufUtil.readArray(buf), allowList);
                return this.createExpiredEvent(listenerId, expiredKey);
            }
        }
        throw Log.HOTROD.unknownEvent(eventTypeId);
    }

    protected AbstractClientEvent createExpiredEvent(byte[] listenerId, Object key) {
        return new ExpiredEventImpl<Object>(listenerId, key);
    }

    @Override
    public <K, V> CacheEntry<K, V> returnPossiblePrevValue(K key, ByteBuf buf, short status, DataFormat dataFormat, int flags, ClassAllowList allowList, Marshaller marshaller) {
        if (HotRodConstants.hasPrevious(status)) {
            return AbstractKeyOperation.readEntry(buf, key, dataFormat, allowList);
        }
        return null;
    }

    protected AbstractClientEvent createRemovedEvent(byte[] listenerId, Object key, boolean isRetried) {
        return new RemovedEventImpl<Object>(listenerId, key, isRetried);
    }

    protected AbstractClientEvent createModifiedEvent(byte[] listenerId, Object key, long dataVersion, boolean isRetried) {
        return new ModifiedEventImpl<Object>(listenerId, key, dataVersion, isRetried);
    }

    protected AbstractClientEvent createCreatedEvent(byte[] listenerId, Object key, long dataVersion, boolean isRetried) {
        return new CreatedEventImpl<Object>(listenerId, key, dataVersion, isRetried);
    }

    protected AbstractClientEvent createCustomEvent(byte[] listenerId, Object eventData, ClientEvent.Type eventType, boolean isRetried) {
        return new CustomEventImpl<Object>(listenerId, eventData, isRetried, eventType);
    }

    protected void checkForErrorsInResponseStatus(ByteBuf buf, HeaderParams params, short status, SocketAddress serverAddress) {
        if (log.isTraceEnabled()) {
            log.tracef("[%s] Received operation status: %#x", new String(params.cacheName), status);
        }
        try {
            switch (status) {
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: {
                    String msgFromServer = ByteBufUtil.readString(buf);
                    if (status == 134 && log.isTraceEnabled()) {
                        log.tracef("Server-side timeout performing operation: %s", msgFromServer);
                    } else {
                        Log.HOTROD.errorFromServer(msgFromServer);
                    }
                    throw new HotRodClientException(msgFromServer, params.messageId, status);
                }
                case 136: {
                    String msgFromServer = ByteBufUtil.readString(buf);
                    throw new RemoteIllegalLifecycleStateException(msgFromServer, params.messageId, status, serverAddress);
                }
                case 135: {
                    String msgFromServer = ByteBufUtil.readString(buf);
                    if (log.isTraceEnabled()) {
                        log.tracef("[%s] A remote node was suspected while executing messageId=%d. Check if retry possible. Message from server: %s", new String(params.cacheName), params.messageId, msgFromServer);
                    }
                    throw new RemoteNodeSuspectException(msgFromServer, params.messageId, status);
                }
            }
            throw new IllegalStateException(String.format("Unknown status: %#04x", status));
        }
        catch (Throwable throwable) {
            switch (status) {
                default: 
            }
            throw throwable;
        }
    }

    protected void readNewTopologyIfPresent(ByteBuf buf, HeaderParams params, ChannelFactory channelFactory) {
        short topologyChangeByte = buf.readUnsignedByte();
        if (topologyChangeByte == 1) {
            this.readNewTopologyAndHash(buf, params, channelFactory);
        }
    }

    protected void readNewTopologyAndHash(ByteBuf buf, HeaderParams params, ChannelFactory channelFactory) {
        SocketAddress[][] segmentOwners;
        short hashFunctionVersion;
        int newTopologyId = ByteBufUtil.readVInt(buf);
        InetSocketAddress[] addresses = this.readTopology(buf);
        if (params.clientIntelligence == ClientIntelligence.HASH_DISTRIBUTION_AWARE.getValue()) {
            hashFunctionVersion = buf.readUnsignedByte();
            int numSegments = ByteBufUtil.readVInt(buf);
            segmentOwners = new SocketAddress[numSegments][];
            if (hashFunctionVersion > 0) {
                for (int i = 0; i < numSegments; ++i) {
                    int numOwners = buf.readUnsignedByte();
                    segmentOwners[i] = new SocketAddress[numOwners];
                    for (int j = 0; j < numOwners; ++j) {
                        int memberIndex = ByteBufUtil.readVInt(buf);
                        segmentOwners[i][j] = addresses[memberIndex];
                    }
                }
            }
        } else {
            hashFunctionVersion = -1;
            segmentOwners = null;
        }
        channelFactory.receiveTopology(params.cacheName, params.topologyAge, newTopologyId, addresses, segmentOwners, hashFunctionVersion);
    }

    private InetSocketAddress[] readTopology(ByteBuf buf) {
        int clusterSize = ByteBufUtil.readVInt(buf);
        InetSocketAddress[] addresses = new InetSocketAddress[clusterSize];
        for (int i = 0; i < clusterSize; ++i) {
            String host = ByteBufUtil.readString(buf);
            int port = buf.readUnsignedShort();
            addresses[i] = InetSocketAddress.createUnresolved(host, port);
        }
        return addresses;
    }

    @Override
    public void writeIteratorStartOperation(ByteBuf buf, IntSet segments, String filterConverterFactory, int batchSize, boolean metadata, byte[][] filterParameters) {
        if (segments == null) {
            ByteBufUtil.writeSignedVInt(buf, -1);
        } else {
            BitSet bitSet = new BitSet();
            segments.forEach(bitSet::set);
            ByteBufUtil.writeOptionalArray(buf, bitSet.toByteArray());
        }
        ByteBufUtil.writeOptionalString(buf, filterConverterFactory);
        if (filterConverterFactory != null) {
            if (filterParameters != null && filterParameters.length > 0) {
                buf.writeByte(filterParameters.length);
                Arrays.stream(filterParameters).forEach(param -> ByteBufUtil.writeArray(buf, param));
            } else {
                buf.writeByte(0);
            }
        }
        ByteBufUtil.writeVInt(buf, batchSize);
        buf.writeByte(metadata ? 1 : 0);
    }

    @Override
    public int readProjectionSize(ByteBuf buf) {
        return ByteBufUtil.readVInt(buf);
    }

    @Override
    public short readMeta(ByteBuf buf) {
        return buf.readUnsignedByte();
    }

    @Override
    public boolean allowOperationsAndEvents() {
        return true;
    }

    @Override
    public MediaType readKeyType(ByteBuf buf) {
        return CodecUtils.readMediaType(buf);
    }

    @Override
    public MediaType readValueType(ByteBuf buf) {
        return CodecUtils.readMediaType(buf);
    }

    @Override
    public int estimateSizeMultimapSupportsDuplicated() {
        return 1;
    }

    @Override
    public void writeMultimapSupportDuplicates(ByteBuf buf, boolean supportsDuplicates) {
        buf.writeByte(supportsDuplicates ? 1 : 0);
    }
}

