/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl;

import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.transaction.xa.Xid;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.hotrod.exceptions.HotRodClientException;
import org.infinispan.hotrod.exceptions.TransportException;
import org.infinispan.hotrod.impl.logging.Log;
import org.infinispan.hotrod.impl.operations.CacheOperationsFactory;
import org.infinispan.hotrod.impl.transaction.operations.PrepareTransactionOperation;

public class Util {
    private static final long BIG_DELAY_NANOS = TimeUnit.DAYS.toNanos(1L);
    private static final Xid DUMMY_XID = new Xid(){

        @Override
        public int getFormatId() {
            return 0;
        }

        @Override
        public byte[] getGlobalTransactionId() {
            return new byte[]{1};
        }

        @Override
        public byte[] getBranchQualifier() {
            return new byte[]{1};
        }
    };

    private Util() {
    }

    public static <T> T await(CompletionStage<T> cf) {
        return Util.await(cf.toCompletableFuture());
    }

    public static <T> T await(CompletableFuture<T> cf) {
        try {
            return cf.get(BIG_DELAY_NANOS, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new HotRodClientException(e);
        }
        catch (ExecutionException e) {
            throw Util.rewrap(e);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T await(CompletableFuture<T> cf, long timeoutMillis) {
        try {
            return cf.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new HotRodClientException(e);
        }
        catch (ExecutionException e) {
            throw Util.rewrap(e);
        }
        catch (TimeoutException e) {
            cf.cancel(false);
            throw new TransportException(new SocketTimeoutException(), null);
        }
    }

    protected static RuntimeException rewrap(ExecutionException e) {
        Throwable cause = e.getCause();
        if (cause instanceof HotRodClientException) {
            cause.setStackTrace(e.getStackTrace());
            return (HotRodClientException)cause;
        }
        if (cause instanceof CacheException) {
            return new CacheException(cause);
        }
        return new TransportException(cause, null);
    }

    public static CompletionStage<Boolean> checkTransactionSupport(String cacheName, CacheOperationsFactory factory) {
        PrepareTransactionOperation op = factory.newPrepareTransactionOperation(DUMMY_XID, true, Collections.emptyList(), false, 60000L);
        return op.execute().handle((integer, throwable) -> {
            if (throwable != null) {
                Log.HOTROD.invalidTxServerConfig(cacheName, (Throwable)throwable);
            }
            return throwable == null;
        });
    }

    public static WrappedByteArray wrapBytes(byte[] cacheName) {
        WrappedByteArray wrappedCacheName = cacheName == null || cacheName.length == 0 ? WrappedByteArray.EMPTY_BYTES : new WrappedByteArray(cacheName);
        return wrappedCacheName;
    }
}

