/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.cache;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.infinispan.api.common.CacheEntryExpiration;
import org.infinispan.api.common.CacheEntryMetadata;
import org.infinispan.api.common.CacheEntryVersion;

public class CacheEntryMetadataImpl
implements CacheEntryMetadata {
    private final long creation;
    private final long lastAccess;
    private final CacheEntryVersion version;
    private final CacheEntryExpiration expiration;

    public CacheEntryMetadataImpl() {
        this(-1L, -1L, null, null);
    }

    public CacheEntryMetadataImpl(long creation, long lastAccess, CacheEntryExpiration expiration, CacheEntryVersion version) {
        this.creation = creation;
        this.lastAccess = lastAccess;
        this.expiration = expiration;
        this.version = version;
    }

    public Optional<Instant> creationTime() {
        return this.creation < 0L ? Optional.empty() : Optional.of(Instant.ofEpochMilli(this.creation));
    }

    public Optional<Instant> lastAccessTime() {
        return this.lastAccess < 0L ? Optional.empty() : Optional.of(Instant.ofEpochMilli(this.lastAccess));
    }

    public CacheEntryExpiration expiration() {
        return this.expiration;
    }

    public CacheEntryVersion version() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheEntryMetadataImpl that = (CacheEntryMetadataImpl)o;
        return this.creation == that.creation && this.lastAccess == that.lastAccess && Objects.equals(this.version, that.version) && Objects.equals(this.expiration, that.expiration);
    }

    public int hashCode() {
        return Objects.hash(this.creation, this.lastAccess, this.version, this.expiration);
    }

    public String toString() {
        return "CacheEntryMetadataImpl{creation=" + this.creation + ", lastAccess=" + this.lastAccess + ", version=" + String.valueOf(this.version) + ", expiration=" + String.valueOf(this.expiration) + "}";
    }
}

