/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Set;
import org.infinispan.api.common.CacheEntryExpiration;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.hotrod.exceptions.InvalidResponseException;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.operations.StatsAffectingRetryingOperation;
import org.infinispan.hotrod.impl.protocol.Codec;
import org.infinispan.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public class PutAllOperation
extends StatsAffectingRetryingOperation<Void> {
    protected final Map<byte[], byte[]> map;

    public PutAllOperation(OperationContext operationContext, Map<byte[], byte[]> map, CacheWriteOptions options, DataFormat dataFormat) {
        super(operationContext, (short)45, (short)46, (CacheOptions)options, dataFormat);
        this.map = map;
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.scheduleRead(channel);
        Codec codec = this.operationContext.getCodec();
        CacheEntryExpiration.Impl expiration = (CacheEntryExpiration.Impl)((CacheWriteOptions)this.options).expiration();
        int bufSize = codec.estimateHeaderSize(this.header) + ByteBufUtil.estimateVIntSize(this.map.size()) + codec.estimateExpirationSize(expiration);
        for (Map.Entry<byte[], byte[]> entry : this.map.entrySet()) {
            bufSize += ByteBufUtil.estimateArraySize(entry.getKey());
            bufSize += ByteBufUtil.estimateArraySize(entry.getValue());
        }
        ByteBuf buf = channel.alloc().buffer(bufSize);
        codec.writeHeader(buf, this.header);
        codec.writeExpirationParams(buf, expiration);
        ByteBufUtil.writeVInt(buf, this.map.size());
        for (Map.Entry<byte[], byte[]> entry : this.map.entrySet()) {
            ByteBufUtil.writeArray(buf, entry.getKey());
            ByteBufUtil.writeArray(buf, entry.getValue());
        }
        channel.writeAndFlush((Object)buf);
    }

    @Override
    protected void fetchChannelAndInvoke(int retryCount, Set<SocketAddress> failedServers) {
        this.operationContext.getChannelFactory().fetchChannelAndInvoke(this.map.keySet().iterator().next(), failedServers, this.operationContext.getCacheNameBytes(), this);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (HotRodConstants.isSuccess(status)) {
            this.statsDataStore(this.map.size());
            this.complete(null);
            return;
        }
        throw new InvalidResponseException("Unexpected response status: " + Integer.toHexString(status));
    }
}

