/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.logging.LogFactory;
import org.infinispan.hotrod.impl.operations.AbstractPutIfAbsentOperation;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.operations.PrivateHotRodFlag;
import org.infinispan.hotrod.impl.protocol.HotRodConstants;
import org.jboss.logging.BasicLogger;

public class PutIfAbsentOperation<K, V>
extends AbstractPutIfAbsentOperation<K, CacheEntry<K, V>> {
    private static final BasicLogger log = LogFactory.getLog(PutIfAbsentOperation.class);

    public PutIfAbsentOperation(OperationContext operationContext, K key, byte[] keyBytes, byte[] value, CacheWriteOptions options, DataFormat dataFormat) {
        super(operationContext, key, keyBytes, value, options, dataFormat);
    }

    @Override
    void completeResponseExistent(ByteBuf buf, short status) {
        CacheEntry prevValue = this.returnPossiblePrevValue(buf, status);
        if (HotRodConstants.hasPrevious(status)) {
            this.statsDataRead(true);
        }
        if (log.isTraceEnabled()) {
            log.tracef("Returning from putIfAbsent: %s", prevValue);
        }
        this.complete(prevValue);
    }

    @Override
    void completeResponseNotExistent(ByteBuf buf, short status) {
        if (log.isTraceEnabled()) {
            log.tracef("Returning from putIfAbsent created new entry", new Object[0]);
        }
        this.statsDataStore();
        this.complete(null);
    }

    @Override
    protected int flags() {
        return super.flags() | PrivateHotRodFlag.FORCE_RETURN_VALUE.getFlagInt();
    }
}

