/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.transport.netty;

import io.netty.channel.epoll.Epoll;
import org.infinispan.hotrod.impl.logging.Log;

final class EPollAvailable {
    private static final String USE_EPOLL_PROPERTY = "infinispan.server.channel.epoll";
    private static final boolean IS_LINUX = System.getProperty("os.name").toLowerCase().startsWith("linux");
    private static final boolean EPOLL_DISABLED = System.getProperty("infinispan.server.channel.epoll", "true").equalsIgnoreCase("false");
    static final boolean USE_NATIVE_EPOLL = EPollAvailable.useNativeEpoll();

    EPollAvailable() {
    }

    private static boolean useNativeEpoll() {
        block4: {
            try {
                Class.forName("io.netty.channel.epoll.Epoll", true, EPollAvailable.class.getClassLoader());
                if (Epoll.isAvailable()) {
                    return !EPOLL_DISABLED && IS_LINUX;
                }
                if (IS_LINUX) {
                    Log.HOTROD.epollNotAvailable(Epoll.unavailabilityCause().toString());
                }
            }
            catch (ClassNotFoundException e) {
                if (!IS_LINUX) break block4;
                Log.HOTROD.epollNotAvailable(e.getMessage());
            }
        }
        return false;
    }
}

