/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.Xid;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.commons.util.IntSet;
import org.infinispan.hotrod.configuration.HotRodConfiguration;
import org.infinispan.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.cache.CacheTopologyInfo;
import org.infinispan.hotrod.impl.cache.ClientStatistics;
import org.infinispan.hotrod.impl.cache.RemoteCache;
import org.infinispan.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.hotrod.impl.iteration.KeyTracker;
import org.infinispan.hotrod.impl.operations.AddBloomNearCacheClientListenerOperation;
import org.infinispan.hotrod.impl.operations.AddClientListenerOperation;
import org.infinispan.hotrod.impl.operations.AdminOperation;
import org.infinispan.hotrod.impl.operations.AuthMechListOperation;
import org.infinispan.hotrod.impl.operations.AuthOperation;
import org.infinispan.hotrod.impl.operations.BulkGetKeysOperation;
import org.infinispan.hotrod.impl.operations.ClearOperation;
import org.infinispan.hotrod.impl.operations.ContainsKeyOperation;
import org.infinispan.hotrod.impl.operations.ExecuteOperation;
import org.infinispan.hotrod.impl.operations.FaultTolerantPingOperation;
import org.infinispan.hotrod.impl.operations.GetAllParallelOperation;
import org.infinispan.hotrod.impl.operations.GetAndRemoveOperation;
import org.infinispan.hotrod.impl.operations.GetOperation;
import org.infinispan.hotrod.impl.operations.GetStreamOperation;
import org.infinispan.hotrod.impl.operations.GetWithMetadataOperation;
import org.infinispan.hotrod.impl.operations.IterationEndOperation;
import org.infinispan.hotrod.impl.operations.IterationNextOperation;
import org.infinispan.hotrod.impl.operations.IterationStartOperation;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.operations.PingOperation;
import org.infinispan.hotrod.impl.operations.PutAllParallelOperation;
import org.infinispan.hotrod.impl.operations.PutIfAbsentOperation;
import org.infinispan.hotrod.impl.operations.PutOperation;
import org.infinispan.hotrod.impl.operations.PutStreamOperation;
import org.infinispan.hotrod.impl.operations.QueryOperation;
import org.infinispan.hotrod.impl.operations.RemoveClientListenerOperation;
import org.infinispan.hotrod.impl.operations.RemoveIfUnmodifiedOperation;
import org.infinispan.hotrod.impl.operations.RemoveOperation;
import org.infinispan.hotrod.impl.operations.ReplaceIfUnmodifiedOperation;
import org.infinispan.hotrod.impl.operations.ReplaceOperation;
import org.infinispan.hotrod.impl.operations.SetIfAbsentOperation;
import org.infinispan.hotrod.impl.operations.SetOperation;
import org.infinispan.hotrod.impl.operations.SizeOperation;
import org.infinispan.hotrod.impl.operations.StatsOperation;
import org.infinispan.hotrod.impl.operations.UpdateBloomFilterOperation;
import org.infinispan.hotrod.impl.protocol.Codec;
import org.infinispan.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.hotrod.impl.query.RemoteQuery;
import org.infinispan.hotrod.impl.transaction.entry.Modification;
import org.infinispan.hotrod.impl.transaction.operations.PrepareTransactionOperation;
import org.infinispan.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.hotrod.telemetry.impl.TelemetryService;

public class CacheOperationsFactory
implements HotRodConstants {
    private final ThreadLocal<Integer> flagsMap = new ThreadLocal();
    private final OperationContext cacheContext;
    private final OperationContext defaultContext;

    public CacheOperationsFactory(ChannelFactory channelFactory, String cacheName, Codec codec, ClientListenerNotifier listenerNotifier, HotRodConfiguration configuration, ClientStatistics clientStatistics) {
        TelemetryService telemetryService = TelemetryService.INSTANCE;
        this.cacheContext = new OperationContext(channelFactory, codec, listenerNotifier, configuration, clientStatistics, telemetryService, cacheName);
        this.defaultContext = new OperationContext(channelFactory, codec, listenerNotifier, configuration, clientStatistics, telemetryService, null);
    }

    public CacheOperationsFactory(ChannelFactory channelFactory, Codec codec, ClientListenerNotifier listenerNotifier, HotRodConfiguration configuration) {
        this(channelFactory, null, codec, listenerNotifier, configuration, null);
    }

    public OperationContext getDefaultContext() {
        return this.defaultContext;
    }

    public OperationContext getCacheContext() {
        return this.cacheContext;
    }

    public Codec getCodec() {
        return this.cacheContext.getCodec();
    }

    public void setCodec(Codec codec) {
        this.cacheContext.setCodec(codec);
        this.defaultContext.setCodec(codec);
    }

    public <K, V> GetOperation<K, V> newGetKeyOperation(K key, byte[] keyBytes, CacheOptions options, DataFormat dataFormat) {
        return new GetOperation(this.cacheContext, key, keyBytes, options, dataFormat);
    }

    public <K, V> GetAllParallelOperation<K, V> newGetAllOperation(Set<byte[]> keys, CacheOptions options, DataFormat dataFormat) {
        return new GetAllParallelOperation(this.cacheContext, keys, options, dataFormat);
    }

    public <K, V> GetAndRemoveOperation<K, V> newGetAndRemoveOperation(K key, byte[] keyBytes, CacheOptions options, DataFormat dataFormat) {
        return new GetAndRemoveOperation(this.cacheContext, key, keyBytes, options, dataFormat);
    }

    public <K> RemoveOperation<K> newRemoveOperation(K key, byte[] keyBytes, CacheOptions options, DataFormat dataFormat) {
        return new RemoveOperation<K>(this.cacheContext, key, keyBytes, options, dataFormat);
    }

    public <K, V> RemoveIfUnmodifiedOperation<K, V> newRemoveIfUnmodifiedOperation(K key, byte[] keyBytes, long version, CacheOptions options, DataFormat dataFormat) {
        return new RemoveIfUnmodifiedOperation(this.cacheContext, key, keyBytes, version, options, dataFormat);
    }

    public <K, V> ReplaceIfUnmodifiedOperation<K, V> newReplaceIfUnmodifiedOperation(K key, byte[] keyBytes, byte[] value, long version, CacheWriteOptions options, DataFormat dataFormat) {
        return new ReplaceIfUnmodifiedOperation(this.cacheContext, key, keyBytes, value, version, options, dataFormat);
    }

    public <K, V> GetWithMetadataOperation<K, V> newGetWithMetadataOperation(K key, byte[] keyBytes, CacheOptions options, DataFormat dataFormat) {
        return this.newGetWithMetadataOperation(key, keyBytes, options, dataFormat, null);
    }

    public <K, V> GetWithMetadataOperation<K, V> newGetWithMetadataOperation(K key, byte[] keyBytes, CacheOptions options, DataFormat dataFormat, SocketAddress listenerServer) {
        return new GetWithMetadataOperation(this.cacheContext, key, keyBytes, options, dataFormat, listenerServer);
    }

    public StatsOperation newStatsOperation(CacheOptions options) {
        return new StatsOperation(this.cacheContext, options);
    }

    public <K, V> PutOperation<K, V> newPutKeyValueOperation(K key, byte[] keyBytes, byte[] value, CacheWriteOptions options, DataFormat dataFormat) {
        return new PutOperation(this.cacheContext, key, keyBytes, value, options, dataFormat);
    }

    public <K> SetOperation<K> newSetKeyValueOperation(K key, byte[] keyBytes, byte[] value, CacheWriteOptions options, DataFormat dataFormat) {
        return new SetOperation<K>(this.cacheContext, key, keyBytes, value, options, dataFormat);
    }

    public PutAllParallelOperation newPutAllOperation(Map<byte[], byte[]> map, CacheWriteOptions options, DataFormat dataFormat) {
        return new PutAllParallelOperation(this.cacheContext, map, options, dataFormat);
    }

    public <K, V> PutIfAbsentOperation<K, V> newPutIfAbsentOperation(K key, byte[] keyBytes, byte[] value, CacheWriteOptions options, DataFormat dataFormat) {
        return new PutIfAbsentOperation(this.cacheContext, key, keyBytes, value, options, dataFormat);
    }

    public <K> SetIfAbsentOperation<K> newSetIfAbsentOperation(K key, byte[] keyBytes, byte[] value, CacheWriteOptions options, DataFormat dataFormat) {
        return new SetIfAbsentOperation<K>(this.cacheContext, key, keyBytes, value, options, dataFormat);
    }

    public <K, V> ReplaceOperation<K, V> newReplaceOperation(K key, byte[] keyBytes, byte[] value, CacheWriteOptions options, DataFormat dataFormat) {
        return new ReplaceOperation(this.cacheContext, key, keyBytes, value, options, dataFormat);
    }

    public ContainsKeyOperation newContainsKeyOperation(Object key, byte[] keyBytes, CacheOptions options, DataFormat dataFormat) {
        return new ContainsKeyOperation<Object>(this.cacheContext, key, keyBytes, options, dataFormat);
    }

    public ClearOperation newClearOperation() {
        return new ClearOperation(this.cacheContext, CacheOptions.DEFAULT);
    }

    public <K> BulkGetKeysOperation<K> newBulkGetKeysOperation(int scope, CacheOptions options, DataFormat dataFormat) {
        return new BulkGetKeysOperation(this.cacheContext, options, scope, dataFormat);
    }

    public AddClientListenerOperation newAddClientListenerOperation(Object listener, CacheOptions options, DataFormat dataFormat) {
        return new AddClientListenerOperation(this.cacheContext, options, listener, null, null, dataFormat, null);
    }

    public AddClientListenerOperation newAddClientListenerOperation(Object listener, byte[][] filterFactoryParams, byte[][] converterFactoryParams, CacheOptions options, DataFormat dataFormat) {
        return new AddClientListenerOperation(this.cacheContext, options, listener, filterFactoryParams, converterFactoryParams, dataFormat, null);
    }

    public RemoveClientListenerOperation newRemoveClientListenerOperation(Object listener, CacheOptions options) {
        return new RemoveClientListenerOperation(this.cacheContext, options, listener);
    }

    public AddBloomNearCacheClientListenerOperation newAddNearCacheListenerOperation(Object listener, CacheOptions options, DataFormat dataFormat, int bloomFilterBits, RemoteCache<?, ?> remoteCache) {
        return new AddBloomNearCacheClientListenerOperation(this.cacheContext, options, listener, dataFormat, bloomFilterBits, remoteCache);
    }

    public UpdateBloomFilterOperation newUpdateBloomFilterOperation(CacheOptions options, SocketAddress address, byte[] bloomBytes) {
        return new UpdateBloomFilterOperation(this.cacheContext, options, address, bloomBytes);
    }

    public PingOperation newPingOperation(boolean releaseChannel) {
        return new PingOperation(this.cacheContext, releaseChannel);
    }

    public FaultTolerantPingOperation newFaultTolerantPingOperation() {
        return new FaultTolerantPingOperation(this.cacheContext, CacheOptions.DEFAULT);
    }

    public QueryOperation newQueryOperation(RemoteQuery remoteQuery, CacheOptions options, DataFormat dataFormat, boolean withHitCount) {
        return new QueryOperation(this.cacheContext, options, remoteQuery, dataFormat, withHitCount);
    }

    public SizeOperation newSizeOperation(CacheOptions options) {
        return new SizeOperation(this.cacheContext, options);
    }

    public <T> ExecuteOperation<T> newExecuteOperation(String taskName, Map<String, byte[]> marshalledParams, Object key, CacheOptions options, DataFormat dataFormat) {
        return new ExecuteOperation(this.cacheContext, options, taskName, marshalledParams, key, dataFormat);
    }

    public AdminOperation newAdminOperation(String taskName, Map<String, byte[]> marshalledParams, CacheOptions options) {
        return new AdminOperation(this.cacheContext, options, taskName, marshalledParams);
    }

    public CacheTopologyInfo getCacheTopologyInfo() {
        return this.cacheContext.getChannelFactory().getCacheTopologyInfo(this.cacheContext.getCacheNameBytes());
    }

    public Map<SocketAddress, Set<Integer>> getPrimarySegmentsByAddress() {
        return this.cacheContext.getChannelFactory().getPrimarySegmentsByAddress(this.cacheContext.getCacheNameBytes());
    }

    public ConsistentHash getConsistentHash() {
        return this.cacheContext.getChannelFactory().getConsistentHash(this.cacheContext.getCacheNameBytes());
    }

    public int getTopologyId() {
        return this.cacheContext.getClientTopology().get().getTopologyId();
    }

    public IterationStartOperation newIterationStartOperation(String filterConverterFactory, byte[][] filterParameters, IntSet segments, int batchSize, boolean metadata, CacheOptions options, DataFormat dataFormat, SocketAddress targetAddress) {
        return new IterationStartOperation(this.cacheContext, options, filterConverterFactory, filterParameters, segments, batchSize, metadata, dataFormat, targetAddress);
    }

    public IterationEndOperation newIterationEndOperation(byte[] iterationId, CacheOptions options, Channel channel) {
        return new IterationEndOperation(this.cacheContext, options, iterationId, channel);
    }

    public <K, E> IterationNextOperation<K, E> newIterationNextOperation(byte[] iterationId, Channel channel, KeyTracker segmentKeyTracker, CacheOptions options, DataFormat dataFormat) {
        return new IterationNextOperation(this.cacheContext, options, iterationId, channel, segmentKeyTracker, dataFormat);
    }

    public <K> GetStreamOperation<K> newGetStreamOperation(K key, byte[] keyBytes, int offset, CacheOptions options) {
        return new GetStreamOperation<K>(this.cacheContext, key, keyBytes, offset, options);
    }

    public <K> PutStreamOperation<K> newPutStreamOperation(K key, byte[] keyBytes, long version, CacheWriteOptions options) {
        return new PutStreamOperation<K>(this.cacheContext, key, keyBytes, options, version);
    }

    public <K> PutStreamOperation<K> newPutStreamOperation(K key, byte[] keyBytes, CacheWriteOptions options) {
        return new PutStreamOperation<K>(this.cacheContext, key, keyBytes, options, 0L);
    }

    public <K> PutStreamOperation<K> newPutIfAbsentStreamOperation(K key, byte[] keyBytes, CacheWriteOptions options) {
        return new PutStreamOperation<K>(this.cacheContext, key, keyBytes, options, -1L);
    }

    public AuthMechListOperation newAuthMechListOperation(Channel channel) {
        return new AuthMechListOperation(this.cacheContext, channel);
    }

    public AuthOperation newAuthOperation(Channel channel, String saslMechanism, byte[] response) {
        return new AuthOperation(this.cacheContext, channel, saslMechanism, response);
    }

    public PrepareTransactionOperation newPrepareTransactionOperation(Xid xid, boolean onePhaseCommit, List<Modification> modifications, boolean recoverable, long timeoutMs) {
        return new PrepareTransactionOperation(this.cacheContext, xid, onePhaseCommit, modifications, recoverable, timeoutMs);
    }
}

