/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.DecoderException;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.hotrod.impl.logging.Log;
import org.infinispan.hotrod.impl.logging.LogFactory;
import org.infinispan.hotrod.impl.operations.HotRodOperation;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.operations.PingResponse;
import org.infinispan.hotrod.impl.transport.netty.ChannelOperation;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public class PingOperation
extends HotRodOperation<PingResponse>
implements ChannelOperation {
    private static final Log log = LogFactory.getLog(PingOperation.class);
    private final boolean releaseChannel;

    public PingOperation(OperationContext operationContext, boolean releaseChannel) {
        this(operationContext, 23, 24, releaseChannel);
    }

    protected PingOperation(OperationContext operationContext, short requestCode, short responseCode, boolean releaseChannel) {
        super(operationContext, requestCode, responseCode, CacheOptions.DEFAULT);
        this.releaseChannel = releaseChannel;
    }

    @Override
    public void invoke(Channel channel) {
        this.sendHeaderAndRead(channel);
        if (this.releaseChannel) {
            this.releaseChannel(channel);
        }
    }

    @Override
    public void cancel(SocketAddress address, Throwable cause) {
        this.completeExceptionally(cause);
    }

    @Override
    public CompletableFuture<PingResponse> execute() {
        throw new UnsupportedOperationException("Cannot execute directly");
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        throw new IllegalStateException("Ping response not called manually.");
    }

    @Override
    public void exceptionCaught(Channel channel, Throwable cause) {
        while (cause instanceof DecoderException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        PingResponse pingResponse = new PingResponse(cause);
        if (pingResponse.isCacheNotFound()) {
            this.complete(pingResponse);
        } else {
            super.exceptionCaught(channel, cause);
        }
    }
}

