/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.reactive.client.impl;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.infinispan.api.client.listener.ClientKeyValueStoreListener;
import org.infinispan.api.reactive.KeyValueEntry;
import org.infinispan.api.reactive.KeyValueStore;
import org.infinispan.api.reactive.WriteResult;
import org.infinispan.api.reactive.client.impl.ContinuousQueryPublisherImpl;
import org.infinispan.api.reactive.client.impl.QueryPublisherImpl;
import org.infinispan.api.reactive.client.impl.listener.ClientListenerImpl;
import org.infinispan.api.reactive.listener.KeyValueStoreListener;
import org.infinispan.api.reactive.query.QueryRequest;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.query.api.continuous.ContinuousQuery;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.reactivestreams.Publisher;

public class KeyValueStoreImpl<K, V>
implements KeyValueStore<K, V> {
    protected final RemoteCache<K, V> cache;
    protected RemoteCache<K, V> cacheReturnValues;

    public KeyValueStoreImpl(RemoteCache<K, V> cache, RemoteCache<K, V> cacheReturnValues) {
        this.cache = cache;
        this.cacheReturnValues = cacheReturnValues;
    }

    public CompletionStage<V> get(K key) {
        return this.cache.getAsync(key);
    }

    public CompletionStage<Boolean> insert(K key, V value) {
        return this.cacheReturnValues.putIfAbsentAsync(key, value).thenApply(v -> v == null);
    }

    public CompletionStage<Void> save(K key, V value) {
        return this.cache.putAsync(key, value).thenApply(v -> null);
    }

    public CompletionStage<Void> delete(K key) {
        return this.cache.removeAsync(key).thenApply(v -> null);
    }

    public Publisher<K> keys() {
        UnicastProcessor processor = UnicastProcessor.create();
        this.cache.keySet().iterator().forEachRemaining(k -> processor.onNext(k));
        return processor;
    }

    public Publisher<? extends Map.Entry<K, V>> entries() {
        UnicastProcessor processor = UnicastProcessor.create();
        this.cache.entrySet().iterator().forEachRemaining(e -> processor.onNext(e));
        return processor;
    }

    public Publisher<WriteResult<K>> saveMany(Publisher<Map.Entry<K, V>> pairs) {
        UnicastProcessor unicastProcessor = UnicastProcessor.create();
        Flowable entryFlowable = Flowable.fromPublisher(pairs);
        entryFlowable.subscribe(e -> this.cache.putAsync(e.getKey(), e.getValue()).whenComplete((r, ex) -> unicastProcessor.onNext((Object)new WriteResult(e.getKey(), ex))));
        return unicastProcessor;
    }

    public CompletionStage<Long> estimateSize() {
        return this.cache.sizeAsync();
    }

    public CompletionStage<Void> clear() {
        return this.cache.clearAsync();
    }

    public Publisher<KeyValueEntry<K, V>> find(String ickleQuery) {
        QueryFactory queryFactory = Search.getQueryFactory(this.cache);
        Query query = queryFactory.create(ickleQuery);
        return new QueryPublisherImpl<KeyValueEntry<K, V>>(query, this.cache.getRemoteCacheManager().getAsyncExecutorService());
    }

    public Publisher<KeyValueEntry<K, V>> find(QueryRequest queryRequest) {
        QueryFactory queryFactory = Search.getQueryFactory(this.cache);
        Query query = queryFactory.create(queryRequest.getIckleQuery());
        query.setParameters(queryRequest.getParams());
        query.startOffset(queryRequest.skip());
        query.maxResults(queryRequest.limit());
        return new QueryPublisherImpl<KeyValueEntry<K, V>>(query, this.cache.getRemoteCacheManager().getAsyncExecutorService());
    }

    public Publisher<KeyValueEntry<K, V>> findContinuously(String ickleQuery) {
        ContinuousQuery continuousQuery = Search.getContinuousQuery(this.cache);
        QueryFactory queryFactory = Search.getQueryFactory(this.cache);
        Query query = queryFactory.create(ickleQuery);
        return new ContinuousQueryPublisherImpl(query, continuousQuery, true, true, true);
    }

    public <T> Publisher<KeyValueEntry<K, T>> findContinuously(QueryRequest queryRequest) {
        ContinuousQuery continuousQuery = Search.getContinuousQuery(this.cache);
        QueryFactory queryFactory = Search.getQueryFactory(this.cache);
        Query query = queryFactory.create(queryRequest.getIckleQuery()).setParameters(queryRequest.getParams());
        query.startOffset(queryRequest.skip());
        return new ContinuousQueryPublisherImpl(query, continuousQuery, queryRequest.isCreated(), queryRequest.isUpdated(), queryRequest.isDeleted());
    }

    public Publisher<KeyValueEntry<K, V>> listen(KeyValueStoreListener listener) {
        return new ClientListenerImpl(this.cache, (ClientKeyValueStoreListener)listener);
    }
}

