/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing.infinispan;

import java.util.Map;
import org.infinispan.api.annotations.indexing.option.Structure;
import org.infinispan.api.annotations.indexing.option.TermVector;
import org.infinispan.protostream.descriptors.AnnotationElement;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.query.remote.impl.indexing.FieldMapping;
import org.infinispan.query.remote.impl.indexing.infinispan.InfinispanAnnotations;

public final class InfinispanMetadataCreator {
    public static FieldMapping fieldMapping(FieldDescriptor fieldDescriptor, Map<String, AnnotationElement.Annotation> annotations) {
        AnnotationElement.Annotation fieldAnnotation = annotations.get("Basic");
        if (fieldAnnotation != null) {
            return InfinispanMetadataCreator.basic(fieldDescriptor, fieldAnnotation);
        }
        fieldAnnotation = annotations.get("Keyword");
        if (fieldAnnotation != null) {
            return InfinispanMetadataCreator.keyword(fieldDescriptor, fieldAnnotation);
        }
        fieldAnnotation = annotations.get("Text");
        if (fieldAnnotation != null) {
            return InfinispanMetadataCreator.text(fieldDescriptor, fieldAnnotation);
        }
        fieldAnnotation = annotations.get("Decimal");
        if (fieldAnnotation != null) {
            return InfinispanMetadataCreator.decimal(fieldDescriptor, fieldAnnotation);
        }
        fieldAnnotation = annotations.get("Embedded");
        if (fieldAnnotation != null) {
            return InfinispanMetadataCreator.embedded(fieldDescriptor, fieldAnnotation);
        }
        return null;
    }

    private static FieldMapping basic(FieldDescriptor fieldDescriptor, AnnotationElement.Annotation fieldAnnotation) {
        String name = InfinispanMetadataCreator.name(fieldDescriptor, fieldAnnotation);
        String indexNullAs = InfinispanMetadataCreator.indexNullAs(fieldAnnotation);
        Boolean searchable = (Boolean)fieldAnnotation.getAttributeValue("searchable").getValue();
        Boolean projectable = (Boolean)fieldAnnotation.getAttributeValue("projectable").getValue();
        Boolean aggregable = (Boolean)fieldAnnotation.getAttributeValue("aggregable").getValue();
        Boolean sortable = (Boolean)fieldAnnotation.getAttributeValue("sortable").getValue();
        return new FieldMapping(name, searchable, projectable, aggregable, sortable, null, null, indexNullAs, fieldDescriptor);
    }

    private static FieldMapping keyword(FieldDescriptor fieldDescriptor, AnnotationElement.Annotation fieldAnnotation) {
        String name = InfinispanMetadataCreator.name(fieldDescriptor, fieldAnnotation);
        String indexNullAs = InfinispanMetadataCreator.indexNullAs(fieldAnnotation);
        Boolean searchable = (Boolean)fieldAnnotation.getAttributeValue("searchable").getValue();
        Boolean projectable = (Boolean)fieldAnnotation.getAttributeValue("projectable").getValue();
        Boolean aggregable = (Boolean)fieldAnnotation.getAttributeValue("aggregable").getValue();
        Boolean sortable = (Boolean)fieldAnnotation.getAttributeValue("sortable").getValue();
        String normalizer = (String)fieldAnnotation.getAttributeValue("normalizer").getValue();
        if ("".equals(normalizer)) {
            normalizer = null;
        }
        Boolean norms = (Boolean)fieldAnnotation.getAttributeValue("norms").getValue();
        return new FieldMapping(name, searchable, projectable, aggregable, sortable, null, normalizer, indexNullAs, norms, null, null, null, null, null, fieldDescriptor);
    }

    private static FieldMapping text(FieldDescriptor fieldDescriptor, AnnotationElement.Annotation fieldAnnotation) {
        String name = InfinispanMetadataCreator.name(fieldDescriptor, fieldAnnotation);
        Boolean searchable = (Boolean)fieldAnnotation.getAttributeValue("searchable").getValue();
        Boolean projectable = (Boolean)fieldAnnotation.getAttributeValue("projectable").getValue();
        String analyzer = (String)fieldAnnotation.getAttributeValue("analyzer").getValue();
        String searchAnalyzer = (String)fieldAnnotation.getAttributeValue("searchAnalyzer").getValue();
        if ("".equals(searchAnalyzer)) {
            searchAnalyzer = null;
        }
        Boolean norms = (Boolean)fieldAnnotation.getAttributeValue("norms").getValue();
        TermVector termVector = InfinispanAnnotations.termVector((String)fieldAnnotation.getAttributeValue("termVector").getValue());
        return new FieldMapping(name, searchable, projectable, false, false, analyzer, null, null, norms, searchAnalyzer, termVector, null, null, null, fieldDescriptor);
    }

    private static FieldMapping decimal(FieldDescriptor fieldDescriptor, AnnotationElement.Annotation fieldAnnotation) {
        String name = InfinispanMetadataCreator.name(fieldDescriptor, fieldAnnotation);
        String indexNullAs = InfinispanMetadataCreator.indexNullAs(fieldAnnotation);
        Boolean searchable = (Boolean)fieldAnnotation.getAttributeValue("searchable").getValue();
        Boolean projectable = (Boolean)fieldAnnotation.getAttributeValue("projectable").getValue();
        Boolean aggregable = (Boolean)fieldAnnotation.getAttributeValue("aggregable").getValue();
        Boolean sortable = (Boolean)fieldAnnotation.getAttributeValue("sortable").getValue();
        Integer decimalScale = (Integer)fieldAnnotation.getAttributeValue("decimalScale").getValue();
        return new FieldMapping(name, searchable, projectable, aggregable, sortable, null, null, indexNullAs, null, null, null, decimalScale, null, null, fieldDescriptor);
    }

    private static FieldMapping embedded(FieldDescriptor fieldDescriptor, AnnotationElement.Annotation fieldAnnotation) {
        String name = InfinispanMetadataCreator.name(fieldDescriptor, fieldAnnotation);
        Integer includeDepth = (Integer)fieldAnnotation.getAttributeValue("includeDepth").getValue();
        Structure structure = InfinispanAnnotations.structure((String)fieldAnnotation.getAttributeValue("structure").getValue());
        return new FieldMapping(name, true, false, false, false, null, null, null, null, null, null, null, includeDepth, structure, fieldDescriptor);
    }

    private static String name(FieldDescriptor fieldDescriptor, AnnotationElement.Annotation fieldAnnotation) {
        String name = (String)fieldAnnotation.getAttributeValue("name").getValue();
        if (name == null) {
            name = fieldDescriptor.getName();
        }
        return name;
    }

    private static String indexNullAs(AnnotationElement.Annotation fieldAnnotation) {
        String indexNullAs = (String)fieldAnnotation.getAttributeValue("indexNullAs").getValue();
        if ("__Infinispan_indexNullAs_doNotIndexNull".equals(indexNullAs)) {
            indexNullAs = null;
        }
        return indexNullAs;
    }
}

