/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.mapping;

import java.util.Set;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.TypeBinder;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionEntityLoader;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.ProgrammaticMappingConfigurationContext;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.remote.impl.indexing.ProtobufEntityConverter;
import org.infinispan.query.remote.impl.mapping.model.ProtobufBootstrapIntrospector;
import org.infinispan.query.remote.impl.mapping.reference.GlobalReferenceHolder;
import org.infinispan.query.remote.impl.mapping.typebridge.ProtobufMessageBinder;
import org.infinispan.search.mapper.mapping.EntityConverter;
import org.infinispan.search.mapper.mapping.SearchMappingBuilder;
import org.infinispan.search.mapper.mapping.SearchMappingCommonBuilding;

public final class SerializationContextSearchMapping {
    private SerializationContextSearchMapping() {
    }

    public static SearchMappingBuilder createBuilder(SearchMappingCommonBuilding commonBuilding, PojoSelectionEntityLoader<?> entityLoader, Set<String> indexedEntityTypes, SerializationContext serializationContext) {
        GlobalReferenceHolder globalReferenceHolder = new GlobalReferenceHolder(serializationContext.getGenericDescriptors());
        ProtobufBootstrapIntrospector introspector = new ProtobufBootstrapIntrospector(globalReferenceHolder);
        SearchMappingBuilder builder = commonBuilding.builder((PojoBootstrapIntrospector)introspector);
        builder.setEntityLoader(entityLoader);
        builder.setEntityConverter((EntityConverter)new ProtobufEntityConverter(serializationContext, globalReferenceHolder));
        ProgrammaticMappingConfigurationContext programmaticMapping = builder.programmaticMapping();
        boolean existIndexedEntities = false;
        for (GlobalReferenceHolder.RootMessageInfo rootMessage : globalReferenceHolder.getRootMessages()) {
            String fullName = rootMessage.getFullName();
            if (!indexedEntityTypes.contains(fullName)) continue;
            existIndexedEntities = true;
            programmaticMapping.type(fullName).binder((TypeBinder)new ProtobufMessageBinder(globalReferenceHolder, fullName)).indexed().index(rootMessage.getIndexName());
            builder.addEntityType(byte[].class, fullName);
        }
        return existIndexedEntities ? builder : null;
    }
}

