/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.backup.resources;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.Security;
import org.infinispan.security.actions.GetCacheComponentRegistryAction;
import org.infinispan.security.actions.GetCacheConfigurationFromManagerAction;
import org.infinispan.security.actions.GetCacheManagerConfigurationAction;
import org.infinispan.security.actions.GetClusterExecutorAction;
import org.infinispan.security.actions.GetGlobalComponentRegistryAction;
import org.infinispan.security.actions.GetOrCreateCacheAction;
import org.infinispan.security.actions.GetOrCreateTemplateAction;
import org.infinispan.security.actions.GetUnwrappedCacheAction;
import org.infinispan.security.impl.Authorizer;

final class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return (T)Security.doPrivileged(action);
    }

    static GlobalConfiguration getGlobalConfiguration(EmbeddedCacheManager cacheManager) {
        GetCacheManagerConfigurationAction action = new GetCacheManagerConfigurationAction(cacheManager);
        return (GlobalConfiguration)SecurityActions.doPrivileged(action);
    }

    static GlobalComponentRegistry getGlobalComponentRegistry(EmbeddedCacheManager cacheManager) {
        GetGlobalComponentRegistryAction action = new GetGlobalComponentRegistryAction(cacheManager);
        return (GlobalComponentRegistry)SecurityActions.doPrivileged(action);
    }

    static void checkPermission(EmbeddedCacheManager cacheManager, AuthorizationPermission permission) {
        Authorizer authorizer = (Authorizer)SecurityActions.getGlobalComponentRegistry(cacheManager).getComponent(Authorizer.class);
        authorizer.checkPermission(cacheManager.getSubject(), permission);
    }

    static Configuration getCacheConfiguration(EmbeddedCacheManager cm, String cacheName) {
        GetCacheConfigurationFromManagerAction action = new GetCacheConfigurationFromManagerAction(cm, cacheName);
        return (Configuration)SecurityActions.doPrivileged(action);
    }

    static <K, V> AdvancedCache<K, V> getUnwrappedCache(Cache<K, V> cache) {
        GetUnwrappedCacheAction action = new GetUnwrappedCacheAction(cache);
        return (AdvancedCache)SecurityActions.doPrivileged(action);
    }

    static Cache<?, ?> getOrCreateCache(EmbeddedCacheManager cm, String cacheName, Configuration cfg) {
        GetOrCreateCacheAction action = new GetOrCreateCacheAction(cm, cacheName, cfg);
        return (Cache)SecurityActions.doPrivileged(action);
    }

    static Configuration getOrCreateTemplate(EmbeddedCacheManager cm, String configName, Configuration cfg) {
        GetOrCreateTemplateAction action = new GetOrCreateTemplateAction(cm, configName, cfg);
        return (Configuration)SecurityActions.doPrivileged(action);
    }

    static ComponentRegistry getComponentRegistry(AdvancedCache<?, ?> cache) {
        GetCacheComponentRegistryAction action = new GetCacheComponentRegistryAction(cache);
        return (ComponentRegistry)SecurityActions.doPrivileged(action);
    }

    static ClusterExecutor getClusterExecutor(EmbeddedCacheManager embeddedCacheManager) {
        return (ClusterExecutor)SecurityActions.doPrivileged(new GetClusterExecutorAction(embeddedCacheManager));
    }
}

