/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFutureListener;
import io.netty.channel.group.ChannelMatcher;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.SingleThreadEventExecutor;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Log4J2LoggerFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.GuardedBy;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.transport.NativeTransport;
import org.infinispan.server.core.transport.NettyTransportConnectionStats;
import org.infinispan.server.core.transport.SecurityActions;
import org.infinispan.server.core.transport.Transport;

@MBean(objectName="Transport", description="Transport component manages read and write operations to/from server.")
public class NettyTransport
implements Transport {
    private static final Log log = (Log)LogFactory.getLog(NettyTransport.class, Log.class);
    private static final boolean isLog4jAvailable = NettyTransport.isIsLog4jAvailable();
    private final DefaultThreadFactory masterThreadFactory;
    private final DefaultThreadFactory ioThreadFactory;
    private ChannelInitializer<Channel> handler;
    private final InetSocketAddress address;
    private final ProtocolServerConfiguration configuration;
    private final ChannelGroup serverChannels;
    private final EmbeddedCacheManager cacheManager;
    final ChannelGroup acceptedChannels;
    private EventLoopGroup masterGroup;
    private EventLoopGroup ioGroup;
    private final NettyTransportConnectionStats connectionStats;
    private int nettyPort = -1;
    private boolean running;

    private static boolean isIsLog4jAvailable() {
        try {
            Util.loadClassStrict((String)"org.apache.logging.log4j.Logger", (ClassLoader)Thread.currentThread().getContextClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public NettyTransport(InetSocketAddress address, ProtocolServerConfiguration configuration, String threadNamePrefix, EmbeddedCacheManager cacheManager) {
        this.address = address;
        this.configuration = configuration;
        this.masterThreadFactory = new DefaultThreadFactory(threadNamePrefix + "-ServerMaster");
        this.ioThreadFactory = new DefaultThreadFactory(threadNamePrefix + "-ServerIO");
        this.serverChannels = new DefaultChannelGroup(threadNamePrefix + "-Channels", (EventExecutor)ImmediateEventExecutor.INSTANCE);
        this.acceptedChannels = new DefaultChannelGroup(threadNamePrefix + "-Accepted", (EventExecutor)ImmediateEventExecutor.INSTANCE);
        this.cacheManager = cacheManager;
        this.connectionStats = new NettyTransportConnectionStats(cacheManager, this.acceptedChannels, threadNamePrefix);
    }

    public void initializeHandler(ChannelInitializer<Channel> handler) {
        this.handler = handler;
    }

    @Override
    @ManagedOperation(description="Starts the transport", displayName="Starts the transport", name="start")
    public synchronized void start() {
        Channel ch;
        if (this.running) {
            return;
        }
        if (isLog4jAvailable) {
            InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)Log4J2LoggerFactory.INSTANCE);
        }
        this.masterGroup = NettyTransport.buildEventLoop(1, (ThreadFactory)this.masterThreadFactory, this.configuration.toString());
        this.ioGroup = this.cacheManager == null ? NettyTransport.buildEventLoop(this.configuration.ioThreads(), (ThreadFactory)this.ioThreadFactory, this.configuration.toString()) : (EventLoopGroup)SecurityActions.getGlobalComponentRegistry(this.cacheManager).getComponent(EventLoopGroup.class);
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.group(this.masterGroup, this.ioGroup);
        bootstrap.channel(this.getServerSocketChannel());
        bootstrap.childHandler(this.handler);
        bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)this.configuration.tcpNoDelay());
        if (this.configuration.sendBufSize() > 0) {
            bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)this.configuration.sendBufSize());
        }
        if (this.configuration.recvBufSize() > 0) {
            bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)this.configuration.recvBufSize());
        }
        bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)this.configuration.tcpKeepAlive());
        try {
            ch = bootstrap.bind((SocketAddress)this.address).sync().channel();
            this.nettyPort = ((InetSocketAddress)ch.localAddress()).getPort();
        }
        catch (InterruptedException e) {
            this.stopInternal();
            throw new CacheException((Throwable)e);
        }
        catch (Throwable t) {
            this.stopInternal();
            throw t;
        }
        this.serverChannels.add((Object)ch);
        this.running = true;
    }

    @Override
    @ManagedOperation(description="Stops the transport", displayName="Stops the transport", name="stop")
    public synchronized void stop() {
        if (this.running) {
            this.stopInternal();
        }
    }

    @GuardedBy(value="this")
    private void stopInternal() {
        Future masterTerminationFuture = this.masterGroup.shutdownGracefully(100L, 1000L, TimeUnit.MILLISECONDS);
        if (this.cacheManager == null) {
            Future ioTerminationFuture = this.ioGroup.shutdownGracefully(100L, 1000L, TimeUnit.MILLISECONDS);
            ioTerminationFuture.awaitUninterruptibly();
        }
        masterTerminationFuture.awaitUninterruptibly();
        if (this.serverChannels.isEmpty() && this.acceptedChannels.isEmpty()) {
            log.debug("Channel group completely closed, external resources released");
        } else {
            this.serverChannels.forEach(ch -> {
                if (ch.isActive()) {
                    log.channelStillBound((Channel)ch, ch.remoteAddress());
                    ch.close().awaitUninterruptibly();
                }
            });
            this.acceptedChannels.forEach(ch -> {
                if (ch.isActive()) {
                    log.channelStillConnected((Channel)ch, ch.remoteAddress());
                    ch.close().awaitUninterruptibly();
                }
            });
        }
        this.nettyPort = -1;
        this.running = false;
    }

    @Override
    @ManagedAttribute(description="Returns whether the transport is running", displayName="Transport running", dataType=DataType.TRAIT)
    public synchronized boolean isRunning() {
        return this.running;
    }

    @Override
    @ManagedAttribute(description="Returns the total number of bytes written by the server back to clients which includes both protocol and user information.", displayName="Number of total number of bytes written", measurementType=MeasurementType.TRENDSUP)
    public long getTotalBytesWritten() {
        return this.connectionStats.getTotalBytesWritten();
    }

    @Override
    @ManagedAttribute(description="Returns the total number of bytes read by the server from clients which includes both protocol and user information.", displayName="Number of total number of bytes read", measurementType=MeasurementType.TRENDSUP)
    public long getTotalBytesRead() {
        return this.connectionStats.getTotalBytesRead();
    }

    @Override
    @ManagedAttribute(description="Returns the host to which the transport binds.", displayName="Host name", dataType=DataType.TRAIT)
    public String getHostName() {
        return this.address.getHostName();
    }

    @Override
    @ManagedAttribute(description="Returns the port to which the transport binds.", displayName="Port", dataType=DataType.TRAIT)
    public int getPort() {
        return this.nettyPort == -1 ? this.address.getPort() : this.nettyPort;
    }

    @Override
    @ManagedAttribute(description="Returns the number of I/O threads.", displayName="Number of I/O threads")
    public int getNumberIOThreads() {
        int count = 0;
        for (EventExecutor unused : this.ioGroup) {
            ++count;
        }
        return count;
    }

    @Override
    @ManagedAttribute(description="Returns the number of pending tasks.", displayName="Pending tasks")
    public int getPendingTasks() {
        AtomicInteger count = new AtomicInteger(0);
        this.ioGroup.forEach(ee -> count.addAndGet(((SingleThreadEventExecutor)ee).pendingTasks()));
        return count.get();
    }

    @Override
    @ManagedAttribute(description="Returns the idle timeout.", displayName="Idle timeout", dataType=DataType.TRAIT)
    public int getIdleTimeout() {
        return this.configuration.idleTimeout();
    }

    @Override
    @ManagedAttribute(description="Returns whether TCP no delay was configured or not.", displayName="TCP no delay", dataType=DataType.TRAIT)
    public boolean getTcpNoDelay() {
        return this.configuration.tcpNoDelay();
    }

    @Override
    @ManagedAttribute(description="Returns the send buffer size.", displayName="Send buffer size", dataType=DataType.TRAIT)
    public int getSendBufferSize() {
        return this.configuration.sendBufSize();
    }

    @Override
    @ManagedAttribute(description="Returns the receive buffer size.", displayName="Receive buffer size", dataType=DataType.TRAIT)
    public int getReceiveBufferSize() {
        return this.configuration.recvBufSize();
    }

    @Override
    @ManagedAttribute(description="Returns a count of active connections this server.", displayName="Local active connections")
    public int getNumberOfLocalConnections() {
        return this.connectionStats.getNumberOfLocalConnections();
    }

    @Override
    @ManagedAttribute(description="Returns a count of active connections in the cluster. This operation will make remote calls to aggregate results, so latency might have an impact on the speed of calculation of this attribute.", displayName="Cluster-wide number of active connections")
    public int getNumberOfGlobalConnections() {
        return this.connectionStats.getNumberOfGlobalConnections();
    }

    public void updateTotalBytesWritten(int bytes) {
        this.connectionStats.incrementTotalBytesWritten(bytes);
    }

    public void updateTotalBytesRead(int bytes) {
        this.connectionStats.incrementTotalBytesRead(bytes);
    }

    @Override
    public CompletionStage<Void> closeChannels(ChannelMatcher channelMatcher) {
        CompletableFuture<Void> closed = new CompletableFuture<Void>();
        this.acceptedChannels.close(channelMatcher).addListener((GenericFutureListener)((ChannelGroupFutureListener)channelFutures -> closed.complete(null)));
        return closed;
    }

    private Class<? extends ServerChannel> getServerSocketChannel() {
        Class<? extends ServerSocketChannel> channel = NativeTransport.serverSocketChannelClass();
        log.createdSocketChannel(channel.getName(), this.configuration.toString());
        return channel;
    }

    public static MultithreadEventLoopGroup buildEventLoop(int nThreads, ThreadFactory threadFactory, String configuration) {
        MultithreadEventLoopGroup eventLoop = NativeTransport.createEventLoopGroup(nThreads, threadFactory);
        log.createdNettyEventLoop(eventLoop.getClass().getName(), configuration);
        return eventLoop;
    }
}

