package org.infinispan.server.memcached.text;
import java.util.List;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.concurrent.CompletableFuture;
import javax.security.auth.Subject;
import org.infinispan.server.memcached.MemcachedServer;

public class TextOpDecoderImpl extends TextOpDecoder {
	private int state;
	private int requestBytes;

	private int mc_parseUnsignedInt;
	private int mc_exptime;
	private byte[] mc_text_key;
	private int mc_flags;
	private ByteBuf mc_token;
	private byte[] mc_fixedArray;
	private int mc_int_number;
	private byte[] mc_text;
	private TextCommand mc_command;
	private List<byte[]> mc_text_key_list;
	private byte[] mc_key;
	private short mc_short;
	private List<byte[]> mc_keys;
	private boolean mc_eowc;
	private long mc_long_number;
	private long mc_cas_unique;
	private long mc_parseLong;
	private Void mc_consumeLine;
	private TextCommand mc_command_name;
	private int mc_vsize;
	private byte[] mc_value;
	private short mc_eol;
	private byte[] mc_delta;
	private boolean mc_noreply;
	private List<byte[]> mc_varargs;
	private List<byte[]> mc_text_list;

	private boolean deadEnd = false;
	public TextOpDecoderImpl(MemcachedServer server, Subject subject) {
		super(server, subject);
	}

	public TextOpDecoderImpl(MemcachedServer server) {
		this(server, ANONYMOUS);
	}

	private TextHeader getHeader() {
		return accessLogging ? new TextHeader(requestBytes, requestStart, principalName, mc_key, mc_command_name) : null;
	}

	@Override
	public void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
		int pos = buf.readerIndex();
		try {
			if (! ctx.channel().config().isAutoRead()) {
				log.tracef("Auto read was disabled, not reading next bytes yet");
				return;
			} else {
				log.tracef("Auto read was enabled, reading next bytes");
			}
			while (switch1_0(buf, out));
		} catch (Throwable t) {
			exceptionally(t);
		} finally {
			requestBytes += buf.readerIndex() - pos;
		}
	}

	private boolean switch1_0(ByteBuf buf, List<Object> out) throws Exception {
		switch (state >> 6) {
		case 0: return switch0(buf, out);
		case 1: return switch1(buf, out);
		default: throw new IllegalStateException();
		}
	}

	private boolean switch0(ByteBuf buf, List<Object> out) throws Exception {
		byte b;
		int pos;
		switch (state) {
		case 0: 
			// 
			reset(); 
			state = 1;
			// fallthrough
		case 1: 
			// 
			pos = buf.readerIndex();
			mc_command = org.infinispan.server.memcached.text.TextIntrinsics.command(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_command_name = mc_command;
			state = 2;
			// fallthrough
		case 2: 
			// mc.request
			requestStart = Instant.now();
			
			state = 3;
			// fallthrough
		case 3: 
			// mc.request
			return userSwitch3();
		case 4: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text_key = org.infinispan.server.memcached.text.TextIntrinsics.text_key(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_text_key;
			state = 5;
			// fallthrough
		case 5: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int_number = org.infinispan.server.memcached.text.TextIntrinsics.int_number(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_flags = mc_int_number;
			state = 6;
			// fallthrough
		case 6: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int_number = org.infinispan.server.memcached.text.TextIntrinsics.int_number(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_exptime = mc_int_number;
			state = 7;
			// fallthrough
		case 7: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int_number = org.infinispan.server.memcached.text.TextIntrinsics.int_number(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_vsize = mc_int_number;
			state = 8;
			// fallthrough
		case 8: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_eowc = org.infinispan.server.memcached.text.TextIntrinsics.eowc(buf);
			if (buf.readerIndex() == pos) return false;
			mc_noreply = mc_eowc;
			state = 9;
			// fallthrough
		case 9: 
			// mc.request/mc.parameters
			if (mc_vsize > 0) {
				state = 11;
				return true;
			}
			mc_value = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 10;
			// fallthrough
		case 10: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_short = org.infinispan.server.memcached.text.TextIntrinsics.short_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_eol = mc_short;
			state = 12;
			return true;
		case 11: 
			// mc.request/mc.parameters/mc.value
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.text.TextIntrinsics.fixedArray(buf, mc_vsize);
			if (buf.readerIndex() == pos) return false;
			mc_value = mc_fixedArray;
			state = 10;
			return true;
		case 12: 
			// mc.request/mc.parameters
			if (out.add(set(getHeader(), mc_key, mc_value, mc_flags, mc_exptime, mc_noreply))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 13: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text_key = org.infinispan.server.memcached.text.TextIntrinsics.text_key(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_text_key;
			state = 14;
			// fallthrough
		case 14: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int_number = org.infinispan.server.memcached.text.TextIntrinsics.int_number(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_flags = mc_int_number;
			state = 15;
			// fallthrough
		case 15: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int_number = org.infinispan.server.memcached.text.TextIntrinsics.int_number(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_exptime = mc_int_number;
			state = 16;
			// fallthrough
		case 16: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int_number = org.infinispan.server.memcached.text.TextIntrinsics.int_number(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_vsize = mc_int_number;
			state = 17;
			// fallthrough
		case 17: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_eowc = org.infinispan.server.memcached.text.TextIntrinsics.eowc(buf);
			if (buf.readerIndex() == pos) return false;
			mc_noreply = mc_eowc;
			state = 18;
			// fallthrough
		case 18: 
			// mc.request/mc.parameters
			if (mc_vsize > 0) {
				state = 20;
				return true;
			}
			mc_value = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 19;
			// fallthrough
		case 19: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_short = org.infinispan.server.memcached.text.TextIntrinsics.short_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_eol = mc_short;
			state = 21;
			return true;
		case 20: 
			// mc.request/mc.parameters/mc.value
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.text.TextIntrinsics.fixedArray(buf, mc_vsize);
			if (buf.readerIndex() == pos) return false;
			mc_value = mc_fixedArray;
			state = 19;
			return true;
		case 21: 
			// mc.request/mc.parameters
			if (out.add(add(getHeader(), mc_key, mc_value, mc_flags, mc_exptime, mc_noreply))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 22: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text_key = org.infinispan.server.memcached.text.TextIntrinsics.text_key(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_text_key;
			state = 23;
			// fallthrough
		case 23: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int_number = org.infinispan.server.memcached.text.TextIntrinsics.int_number(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_flags = mc_int_number;
			state = 24;
			// fallthrough
		case 24: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int_number = org.infinispan.server.memcached.text.TextIntrinsics.int_number(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_exptime = mc_int_number;
			state = 25;
			// fallthrough
		case 25: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int_number = org.infinispan.server.memcached.text.TextIntrinsics.int_number(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_vsize = mc_int_number;
			state = 26;
			// fallthrough
		case 26: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_eowc = org.infinispan.server.memcached.text.TextIntrinsics.eowc(buf);
			if (buf.readerIndex() == pos) return false;
			mc_noreply = mc_eowc;
			state = 27;
			// fallthrough
		case 27: 
			// mc.request/mc.parameters
			if (mc_vsize > 0) {
				state = 29;
				return true;
			}
			mc_value = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 28;
			// fallthrough
		case 28: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_short = org.infinispan.server.memcached.text.TextIntrinsics.short_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_eol = mc_short;
			state = 30;
			return true;
		case 29: 
			// mc.request/mc.parameters/mc.value
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.text.TextIntrinsics.fixedArray(buf, mc_vsize);
			if (buf.readerIndex() == pos) return false;
			mc_value = mc_fixedArray;
			state = 28;
			return true;
		case 30: 
			// mc.request/mc.parameters
			if (out.add(replace(getHeader(), mc_key, mc_value, mc_flags, mc_exptime, mc_noreply))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 31: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text_key = org.infinispan.server.memcached.text.TextIntrinsics.text_key(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_text_key;
			state = 32;
			// fallthrough
		case 32: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_eowc = org.infinispan.server.memcached.text.TextIntrinsics.eowc(buf);
			if (buf.readerIndex() == pos) return false;
			mc_noreply = mc_eowc;
			state = 33;
			// fallthrough
		case 33: 
			// mc.request/mc.parameters
			if (out.add(delete(getHeader(), mc_key, mc_noreply))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 34: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text_key = org.infinispan.server.memcached.text.TextIntrinsics.text_key(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_text_key;
			state = 35;
			// fallthrough
		case 35: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int_number = org.infinispan.server.memcached.text.TextIntrinsics.int_number(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_flags = mc_int_number;
			state = 36;
			// fallthrough
		case 36: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int_number = org.infinispan.server.memcached.text.TextIntrinsics.int_number(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_exptime = mc_int_number;
			state = 37;
			// fallthrough
		case 37: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int_number = org.infinispan.server.memcached.text.TextIntrinsics.int_number(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_vsize = mc_int_number;
			state = 38;
			// fallthrough
		case 38: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_eowc = org.infinispan.server.memcached.text.TextIntrinsics.eowc(buf);
			if (buf.readerIndex() == pos) return false;
			mc_noreply = mc_eowc;
			state = 39;
			// fallthrough
		case 39: 
			// mc.request/mc.parameters
			if (mc_vsize > 0) {
				state = 41;
				return true;
			}
			mc_value = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 40;
			// fallthrough
		case 40: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_short = org.infinispan.server.memcached.text.TextIntrinsics.short_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_eol = mc_short;
			state = 42;
			return true;
		case 41: 
			// mc.request/mc.parameters/mc.value
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.text.TextIntrinsics.fixedArray(buf, mc_vsize);
			if (buf.readerIndex() == pos) return false;
			mc_value = mc_fixedArray;
			state = 40;
			return true;
		case 42: 
			// mc.request/mc.parameters
			if (out.add(concat(getHeader(), mc_key, mc_value, mc_flags, mc_exptime, mc_noreply, true))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 43: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text_key = org.infinispan.server.memcached.text.TextIntrinsics.text_key(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_text_key;
			state = 44;
			// fallthrough
		case 44: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int_number = org.infinispan.server.memcached.text.TextIntrinsics.int_number(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_flags = mc_int_number;
			state = 45;
			// fallthrough
		case 45: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int_number = org.infinispan.server.memcached.text.TextIntrinsics.int_number(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_exptime = mc_int_number;
			state = 46;
			// fallthrough
		case 46: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int_number = org.infinispan.server.memcached.text.TextIntrinsics.int_number(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_vsize = mc_int_number;
			state = 47;
			// fallthrough
		case 47: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_eowc = org.infinispan.server.memcached.text.TextIntrinsics.eowc(buf);
			if (buf.readerIndex() == pos) return false;
			mc_noreply = mc_eowc;
			state = 48;
			// fallthrough
		case 48: 
			// mc.request/mc.parameters
			if (mc_vsize > 0) {
				state = 50;
				return true;
			}
			mc_value = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 49;
			// fallthrough
		case 49: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_short = org.infinispan.server.memcached.text.TextIntrinsics.short_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_eol = mc_short;
			state = 51;
			return true;
		case 50: 
			// mc.request/mc.parameters/mc.value
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.text.TextIntrinsics.fixedArray(buf, mc_vsize);
			if (buf.readerIndex() == pos) return false;
			mc_value = mc_fixedArray;
			state = 49;
			return true;
		case 51: 
			// mc.request/mc.parameters
			if (out.add(concat(getHeader(), mc_key, mc_value, mc_flags, mc_exptime, mc_noreply, false))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 52: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text_key = org.infinispan.server.memcached.text.TextIntrinsics.text_key(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_text_key;
			state = 53;
			// fallthrough
		case 53: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int_number = org.infinispan.server.memcached.text.TextIntrinsics.int_number(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_flags = mc_int_number;
			state = 54;
			// fallthrough
		case 54: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int_number = org.infinispan.server.memcached.text.TextIntrinsics.int_number(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_exptime = mc_int_number;
			state = 55;
			// fallthrough
		case 55: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int_number = org.infinispan.server.memcached.text.TextIntrinsics.int_number(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_vsize = mc_int_number;
			state = 56;
			// fallthrough
		case 56: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_long_number = org.infinispan.server.memcached.text.TextIntrinsics.long_number(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_cas_unique = mc_long_number;
			state = 57;
			// fallthrough
		case 57: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_eowc = org.infinispan.server.memcached.text.TextIntrinsics.eowc(buf);
			if (buf.readerIndex() == pos) return false;
			mc_noreply = mc_eowc;
			state = 58;
			// fallthrough
		case 58: 
			// mc.request/mc.parameters
			if (mc_vsize > 0) {
				state = 60;
				return true;
			}
			mc_value = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 59;
			// fallthrough
		case 59: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_short = org.infinispan.server.memcached.text.TextIntrinsics.short_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_eol = mc_short;
			state = 61;
			return true;
		case 60: 
			// mc.request/mc.parameters/mc.value
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.text.TextIntrinsics.fixedArray(buf, mc_vsize);
			if (buf.readerIndex() == pos) return false;
			mc_value = mc_fixedArray;
			state = 59;
			return true;
		case 61: 
			// mc.request/mc.parameters
			if (out.add(cas(getHeader(), mc_key, mc_value, mc_flags, mc_exptime, mc_cas_unique, mc_noreply))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 62: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text_key_list = org.infinispan.server.memcached.text.TextIntrinsics.text_key_list(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_keys = mc_text_key_list;
			state = 63;
			// fallthrough
		case 63: 
			// mc.request/mc.parameters
			if (out.add(get(getHeader(), mc_keys, false))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		}
		return true;
	}

	private boolean switch1(ByteBuf buf, List<Object> out) throws Exception {
		byte b;
		int pos;
		switch (state) {
		case 64: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text_key_list = org.infinispan.server.memcached.text.TextIntrinsics.text_key_list(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_keys = mc_text_key_list;
			state = 65;
			// fallthrough
		case 65: 
			// mc.request/mc.parameters
			if (out.add(get(getHeader(), mc_keys, true))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 66: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text_key = org.infinispan.server.memcached.text.TextIntrinsics.text_key(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_text_key;
			state = 67;
			// fallthrough
		case 67: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text = org.infinispan.server.memcached.text.TextIntrinsics.text(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_delta = mc_text;
			state = 68;
			// fallthrough
		case 68: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_eowc = org.infinispan.server.memcached.text.TextIntrinsics.eowc(buf);
			if (buf.readerIndex() == pos) return false;
			mc_noreply = mc_eowc;
			state = 69;
			// fallthrough
		case 69: 
			// mc.request/mc.parameters
			if (out.add(incr(getHeader(), mc_key, mc_delta, mc_noreply, true))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 70: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text_key = org.infinispan.server.memcached.text.TextIntrinsics.text_key(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_text_key;
			state = 71;
			// fallthrough
		case 71: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text = org.infinispan.server.memcached.text.TextIntrinsics.text(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_delta = mc_text;
			state = 72;
			// fallthrough
		case 72: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_eowc = org.infinispan.server.memcached.text.TextIntrinsics.eowc(buf);
			if (buf.readerIndex() == pos) return false;
			mc_noreply = mc_eowc;
			state = 73;
			// fallthrough
		case 73: 
			// mc.request/mc.parameters
			if (out.add(incr(getHeader(), mc_key, mc_delta, mc_noreply, false))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 74: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text_key = org.infinispan.server.memcached.text.TextIntrinsics.text_key(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_text_key;
			state = 75;
			// fallthrough
		case 75: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int_number = org.infinispan.server.memcached.text.TextIntrinsics.int_number(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_exptime = mc_int_number;
			state = 76;
			// fallthrough
		case 76: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_eowc = org.infinispan.server.memcached.text.TextIntrinsics.eowc(buf);
			if (buf.readerIndex() == pos) return false;
			mc_noreply = mc_eowc;
			state = 77;
			// fallthrough
		case 77: 
			// mc.request/mc.parameters
			if (out.add(touch(getHeader(), mc_key, mc_exptime, mc_noreply))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 78: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int_number = org.infinispan.server.memcached.text.TextIntrinsics.int_number(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_exptime = mc_int_number;
			state = 79;
			// fallthrough
		case 79: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text_key_list = org.infinispan.server.memcached.text.TextIntrinsics.text_key_list(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_keys = mc_text_key_list;
			state = 80;
			// fallthrough
		case 80: 
			// mc.request/mc.parameters
			if (out.add(gat(getHeader(), mc_exptime, mc_keys, false))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 81: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int_number = org.infinispan.server.memcached.text.TextIntrinsics.int_number(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_exptime = mc_int_number;
			state = 82;
			// fallthrough
		case 82: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text_key_list = org.infinispan.server.memcached.text.TextIntrinsics.text_key_list(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_keys = mc_text_key_list;
			state = 83;
			// fallthrough
		case 83: 
			// mc.request/mc.parameters
			if (out.add(gat(getHeader(), mc_exptime, mc_keys, true))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 84: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text_list = org.infinispan.server.memcached.text.TextIntrinsics.text_list(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_varargs = mc_text_list;
			state = 85;
			// fallthrough
		case 85: 
			// mc.request/mc.parameters
			if (out.add(flush_all(getHeader(), mc_varargs))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 86: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_short = org.infinispan.server.memcached.text.TextIntrinsics.short_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_eol = mc_short;
			state = 87;
			// fallthrough
		case 87: 
			// mc.request/mc.parameters
			if (out.add(version(getHeader()))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 88: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_short = org.infinispan.server.memcached.text.TextIntrinsics.short_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_eol = mc_short;
			state = 89;
			// fallthrough
		case 89: 
			// mc.request/mc.parameters
			quit(getHeader());
			
			state = 0;
			return true;
		case 90: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text_key_list = org.infinispan.server.memcached.text.TextIntrinsics.text_key_list(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_keys = mc_text_key_list;
			state = 91;
			// fallthrough
		case 91: 
			// mc.request/mc.parameters
			if (out.add(stats(getHeader(), mc_keys))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 92: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text_key = org.infinispan.server.memcached.text.TextIntrinsics.text_key(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_text_key;
			state = 93;
			// fallthrough
		case 93: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text_list = org.infinispan.server.memcached.text.TextIntrinsics.text_list(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_varargs = mc_text_list;
			state = 94;
			// fallthrough
		case 94: 
			// mc.request/mc.parameters
			if (out.add(mg(getHeader(), mc_key, mc_varargs))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 95: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text_key = org.infinispan.server.memcached.text.TextIntrinsics.text_key(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_text_key;
			state = 96;
			// fallthrough
		case 96: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_int_number = org.infinispan.server.memcached.text.TextIntrinsics.int_number(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_vsize = mc_int_number;
			state = 97;
			// fallthrough
		case 97: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text_list = org.infinispan.server.memcached.text.TextIntrinsics.text_list(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_varargs = mc_text_list;
			state = 98;
			// fallthrough
		case 98: 
			// mc.request/mc.parameters
			if (mc_vsize > 0) {
				state = 100;
				return true;
			}
			mc_value = org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY;
			state = 99;
			// fallthrough
		case 99: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_short = org.infinispan.server.memcached.text.TextIntrinsics.short_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_eol = mc_short;
			state = 101;
			return true;
		case 100: 
			// mc.request/mc.parameters/mc.value
			pos = buf.readerIndex();
			mc_fixedArray = org.infinispan.server.memcached.text.TextIntrinsics.fixedArray(buf, mc_vsize);
			if (buf.readerIndex() == pos) return false;
			mc_value = mc_fixedArray;
			state = 99;
			return true;
		case 101: 
			// mc.request/mc.parameters
			if (out.add(ms(getHeader(), mc_key, mc_value, mc_varargs))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 102: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text_key = org.infinispan.server.memcached.text.TextIntrinsics.text_key(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_text_key;
			state = 103;
			// fallthrough
		case 103: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text_list = org.infinispan.server.memcached.text.TextIntrinsics.text_list(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_varargs = mc_text_list;
			state = 104;
			// fallthrough
		case 104: 
			// mc.request/mc.parameters
			if (out.add(md(getHeader(), mc_key, mc_varargs))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 105: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text_key = org.infinispan.server.memcached.text.TextIntrinsics.text_key(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_text_key;
			state = 106;
			// fallthrough
		case 106: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text_list = org.infinispan.server.memcached.text.TextIntrinsics.text_list(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_varargs = mc_text_list;
			state = 107;
			// fallthrough
		case 107: 
			// mc.request/mc.parameters
			if (out.add(ma(getHeader(), mc_key, mc_varargs))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 108: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_short = org.infinispan.server.memcached.text.TextIntrinsics.short_(buf);
			if (buf.readerIndex() == pos) return false;
			mc_eol = mc_short;
			state = 109;
			// fallthrough
		case 109: 
			// mc.request/mc.parameters
			if (out.add(mn(getHeader()))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		case 110: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text_key = org.infinispan.server.memcached.text.TextIntrinsics.text_key(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_key = mc_text_key;
			state = 111;
			// fallthrough
		case 111: 
			// mc.request/mc.parameters
			pos = buf.readerIndex();
			mc_text_list = org.infinispan.server.memcached.text.TextIntrinsics.text_list(buf, reader);
			if (buf.readerIndex() == pos) return false;
			mc_varargs = mc_text_list;
			state = 112;
			// fallthrough
		case 112: 
			// mc.request/mc.parameters
			if (out.add(me(getHeader(), mc_key, mc_varargs))) {
			state = 0;
			return false;
			}
			;
			
			state = 0;
			return true;
		}
		return true;
	}

	private void deadEnd() {
		if (! deadEnd) {
			exceptionCaught(getHeader(), new IllegalStateException("Dead end processing request"));
			deadEnd = true;
		}
		state = 0;
	}

	private void exceptionally(Throwable t) throws Exception {
		state = 0;
		exceptionCaught(getHeader(), t);
	}

	private void reset() {
		requestBytes = 0;
		mc_parseUnsignedInt = 0;
		mc_exptime = 0;
		mc_text_key = null;
		mc_flags = 0;
		mc_token = null;
		mc_fixedArray = null;
		mc_int_number = 0;
		mc_text = null;
		mc_command = null;
		mc_text_key_list = null;
		mc_key = null;
		mc_short = 0;
		mc_keys = null;
		mc_eowc = false;
		mc_long_number = 0;
		mc_cas_unique = 0;
		mc_parseLong = 0;
		mc_consumeLine = null;
		mc_command_name = null;
		mc_vsize = 0;
		mc_value = null;
		mc_eol = 0;
		mc_delta = null;
		mc_noreply = false;
		mc_varargs = null;
		mc_text_list = null;
	}

	public int requestBytes() {
		return requestBytes;
	}

	private boolean userSwitch3() throws Exception {
		switch (mc_command_name) {
		case set: 
			state = 4;
			return true;
		case add: 
			state = 13;
			return true;
		case replace: 
			state = 22;
			return true;
		case delete: 
			state = 31;
			return true;
		case append: 
			state = 34;
			return true;
		case prepend: 
			state = 43;
			return true;
		case cas: 
			state = 52;
			return true;
		case get: 
			state = 62;
			return true;
		case gets: 
			state = 64;
			return true;
		case incr: 
			state = 66;
			return true;
		case decr: 
			state = 70;
			return true;
		case touch: 
			state = 74;
			return true;
		case gat: 
			state = 78;
			return true;
		case gats: 
			state = 81;
			return true;
		case flush_all: 
			state = 84;
			return true;
		case version: 
			state = 86;
			return true;
		case quit: 
			state = 88;
			return true;
		case stats: 
			state = 90;
			return true;
		case mg: 
			state = 92;
			return true;
		case ms: 
			state = 95;
			return true;
		case md: 
			state = 102;
			return true;
		case ma: 
			state = 105;
			return true;
		case mn: 
			state = 108;
			return true;
		case me: 
			state = 110;
			return true;
		default: 
			throw new IllegalArgumentException("Unknown command " + mc_command_name);
			
		}
	}

}
