/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.logging;

import io.netty.channel.ChannelFuture;
import java.net.InetSocketAddress;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.infinispan.commons.util.Util;
import org.infinispan.server.memcached.logging.Header;
import org.infinispan.util.logging.LogFactory;
import org.jboss.logging.Logger;
import org.jboss.logging.MDC;

public final class MemcachedAccessLogging {
    public static final Logger log = LogFactory.getLogger((String)"MEMCACHED_ACCESS_LOG");

    public static boolean isEnabled() {
        return log.isTraceEnabled();
    }

    public static void logOK(ChannelFuture future, Header header, int responseBytes) {
        MemcachedAccessLogging.logAfterComplete(future, header, responseBytes, "OK");
    }

    public static void logException(ChannelFuture future, Header header, String exception, int responseBytes) {
        MemcachedAccessLogging.logAfterComplete(future, header, responseBytes, exception);
    }

    private static void logAfterComplete(ChannelFuture future, Header header, int responseBytes, String status) {
        String remoteAddress = ((InetSocketAddress)future.channel().remoteAddress()).getHostString();
        if (future.isDone()) {
            MemcachedAccessLogging.logAfterComplete(remoteAddress, header, responseBytes, status);
            return;
        }
        future.addListener(f -> MemcachedAccessLogging.logAfterComplete(remoteAddress, header, responseBytes, status));
    }

    private static void logAfterComplete(String remoteAddress, Header header, int responseBytes, String status) {
        long duration = header.requestStart == null ? -1L : ChronoUnit.MILLIS.between(header.requestStart, Instant.now());
        MDC.clear();
        MDC.put((String)"address", (Object)remoteAddress);
        MDC.put((String)"user", (Object)MemcachedAccessLogging.checkForNull(header.principalName));
        MDC.put((String)"method", (Object)MemcachedAccessLogging.checkForNull(header.getOp()));
        MDC.put((String)"protocol", (Object)header.getProtocol());
        MDC.put((String)"status", (Object)MemcachedAccessLogging.checkForNull(status));
        MDC.put((String)"responseSize", (Object)responseBytes);
        MDC.put((String)"requestSize", (Object)header.requestBytes);
        MDC.put((String)"duration", (Object)duration);
        log.tracef("/%s", (Object)MemcachedAccessLogging.checkForNull(header.getKey()));
    }

    private static String checkForNull(Object obj) {
        if (obj == null || obj instanceof String && ((String)obj).isEmpty()) {
            return "-";
        }
        if (obj instanceof byte[]) {
            return Util.printArray((byte[])((byte[])obj));
        }
        return obj.toString();
    }
}

