/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.logging;

import io.netty.channel.ChannelHandlerContext;
import java.time.temporal.Temporal;
import java.util.List;
import org.infinispan.commons.time.TimeService;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.logging.AccessData;

public class Tracker {
    private final TimeService timeService;
    private final ChannelHandlerContext ctx;
    private byte[][] keys;
    private Temporal start;
    private int bytesRequested;
    private int requestSize;
    private RespCommand req;

    public Tracker(ChannelHandlerContext ctx, TimeService timeService) {
        this.timeService = timeService;
        this.ctx = ctx;
    }

    public void track(RespCommand req, List<byte[]> arguments) {
        if (this.start != null) {
            throw new IllegalStateException("Interleaving command not allowed!");
        }
        this.start = this.timeService.instant();
        this.bytesRequested = 0;
        this.keys = req.extractKeys(arguments);
        this.requestSize = req.size(arguments);
        this.req = req;
    }

    public void increaseBytesRequested(int bytes) {
        this.bytesRequested += bytes;
    }

    public AccessData done(Throwable throwable) {
        if (this.start == null) {
            return null;
        }
        AccessData ad = AccessData.create(this.ctx, this.req, this.start, this.keys, this.requestSize, this.bytesRequested, throwable);
        this.start = null;
        return ad;
    }
}

