/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.cluster;

import io.netty.channel.ChannelHandlerContext;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import net.jcip.annotations.GuardedBy;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.manager.CacheManagerInfo;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespErrorUtil;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.RespServer;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.commands.cluster.CLUSTER;
import org.infinispan.server.resp.serialization.Resp3Response;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.function.SerializableFunction;

public class NODES
extends RespCommand
implements Resp3Command {
    @GuardedBy(value="this")
    protected ConsistentHash hash = null;
    @GuardedBy(value="this")
    protected CompletionStage<CharSequence> response = null;

    public NODES() {
        super(2, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        handler.checkPermission(AuthorizationPermission.ADMIN);
        AdvancedCache<byte[], byte[]> respCache = handler.cache();
        DistributionManager dm = respCache.getDistributionManager();
        if (dm == null) {
            RespErrorUtil.customError("This instance has cluster support disabled", handler.allocator());
            return handler.myStage();
        }
        LocalizedCacheTopology topology = dm.getCacheTopology();
        ConsistentHash currentCH = topology.getCurrentCH();
        if (currentCH == null) {
            RespErrorUtil.customError("No consistent hash available", handler.allocator());
            return handler.myStage();
        }
        NODES nODES = this;
        synchronized (nODES) {
            if (!currentCH.equals((Object)this.hash)) {
                EmbeddedCacheManager ecm = SecurityActions.getEmbeddedCacheManager(respCache);
                this.response = NODES.requestClusterInformation(handler, ctx, ecm, (CacheTopology)topology);
                this.hash = currentCH;
            }
        }
        return handler.stageToReturn(this.response, ctx, Resp3Response.BULK_STRING);
    }

    protected static CompletionStage<CharSequence> requestClusterInformation(Resp3Handler handler, ChannelHandlerContext ctx, EmbeddedCacheManager ecm, CacheTopology topology) {
        ConsistentHash hash = topology.getCurrentCH();
        return NODES.readNodeInformation(hash.getMembers(), handler).thenApply(information -> {
            StringBuilder response = new StringBuilder();
            Address local = ecm.getAddress();
            int cport = NODES.findClientPort(ctx.channel().remoteAddress());
            for (Address member : hash.getMembers()) {
                boolean isMyself = member.equals((Object)local);
                IntSet owner = CLUSTER.ownedSlots(member, hash, handler.respServer().segmentSlotRelation());
                String initial = (String)information.get(member);
                String health = "connected";
                if (initial != null) {
                    response.append(String.format(initial, cport));
                    if (isMyself) {
                        response.append("myself,");
                    }
                } else {
                    response.append(member).append(' ');
                    if (isMyself) {
                        RespServer server = handler.respServer();
                        response.append(server.getHost()).append(':').append(server.getPort());
                        response.append('@').append(cport);
                        response.append(' ');
                        response.append("myself,");
                    } else {
                        response.append(":0@0 noaddr,fail?,");
                    }
                    health = "disconnected";
                }
                response.append("master").append(' ');
                response.append('-').append(' ');
                response.append('0').append(' ');
                response.append(Instant.now().getEpochSecond()).append(' ');
                response.append(topology.getTopologyId()).append(' ');
                response.append(health).append(' ');
                NODES.serializeSegments(response, owner);
                response.append('\n');
            }
            return response;
        });
    }

    private static void serializeSegments(StringBuilder response, IntSet ranges) {
        boolean first = true;
        int i = ranges.nextSetBit(0);
        while (i >= 0) {
            if (!first) {
                response.append(' ');
            }
            first = false;
            int runStart = i;
            while (ranges.contains(i + 1)) {
                ++i;
            }
            response.append(runStart).append('-').append(i);
            i = ranges.nextSetBit(i + 1);
        }
    }

    private static CompletionStage<Map<Address, String>> readNodeInformation(List<Address> members, Resp3Handler handler) {
        ConcurrentHashMap response = new ConcurrentHashMap(members.size());
        ClusterExecutor executor = SecurityActions.getClusterExecutor(handler.cache());
        String sqn = handler.respServer().getQualifiedName();
        return executor.filterTargets(members).submitConsumer((SerializableFunction & Serializable)ecm -> NODES.readLocalNodeInformation(sqn, ecm), (address, res, t) -> {
            if (t != null) {
                throw CompletableFutures.asCompletionException((Throwable)t);
            }
            response.put(address, res);
        }).thenApply(ignore -> response);
    }

    private static String readLocalNodeInformation(String serverName, EmbeddedCacheManager ecm) {
        CacheManagerInfo info = ecm.getCacheManagerInfo();
        ComponentRef ref = ((BasicComponentRegistry)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)ecm).getComponent(BasicComponentRegistry.class)).getComponent(serverName, RespServer.class);
        String name = info.getNodeName();
        StringBuilder sb = new StringBuilder();
        sb.append(name).append(' ');
        if (ref != null) {
            RespServer server = (RespServer)((Object)ref.running());
            sb.append(server.getHost()).append(':').append(server.getPort()).append('@').append("%d");
            sb.append(' ');
        } else {
            sb.append(":0@0 noaddr,");
        }
        return sb.toString();
    }

    private static int findClientPort(SocketAddress addr) {
        if (addr instanceof InetSocketAddress) {
            return ((InetSocketAddress)addr).getPort();
        }
        return 0;
    }
}

