/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.generic;

import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.time.TimeService;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.Util;
import org.infinispan.server.resp.commands.ArgumentUtils;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.serialization.Resp3Response;

public class EXPIRE
extends RespCommand
implements Resp3Command {
    public static final CompletableFuture<Long> NOT_APPLIED = CompletableFuture.completedFuture(0L);
    public static final CompletableFuture<Long> APPLIED = CompletableFuture.completedFuture(1L);
    private final boolean unixTime;
    private final boolean seconds;

    public EXPIRE() {
        this(false, true);
    }

    protected EXPIRE(boolean at, boolean seconds) {
        super(-3, 1, 1, 1);
        this.unixTime = at;
        this.seconds = seconds;
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        byte[] key = arguments.get(0);
        long expiration = ArgumentUtils.toLong(arguments.get(1));
        if (this.seconds) {
            expiration = TimeUnit.SECONDS.toMillis(expiration);
        }
        Mode mode = Mode.NONE;
        if (arguments.size() == 3) {
            mode = Mode.valueOf(new String(arguments.get(2), StandardCharsets.US_ASCII).toUpperCase());
        }
        return handler.stageToReturn(EXPIRE.expire(handler, key, expiration, mode, this.unixTime), ctx, Resp3Response.INTEGER);
    }

    private static CompletionStage<Long> expire(Resp3Handler handler, byte[] key, long expiration, Mode mode, boolean unixTime) {
        MediaType vmt = handler.cache().getValueDataConversion().getStorageMediaType();
        AdvancedCache acm = handler.typedCache(vmt);
        return acm.getCacheEntryAsync((Object)key).thenCompose(e -> {
            if (e == null) {
                return NOT_APPLIED;
            }
            long ttl = e.getLifespan();
            if (unixTime) {
                ttl = Util.toUnixTime(ttl, handler.respServer().getTimeService());
            } else if (ttl >= 0L) {
                ttl = e.getLifespan();
            }
            switch (mode.ordinal()) {
                case 1: {
                    if (ttl < 0L) break;
                    return NOT_APPLIED;
                }
                case 2: {
                    if (ttl >= 0L) break;
                    return NOT_APPLIED;
                }
                case 3: {
                    if (expiration >= ttl && ttl >= 0L) break;
                    return NOT_APPLIED;
                }
                case 4: {
                    if (ttl <= 0L || expiration <= ttl) break;
                    return NOT_APPLIED;
                }
            }
            CompletableFuture replace = expiration <= 0L || unixTime && EXPIRE.isInThePast(expiration, handler.respServer().getTimeService()) ? acm.removeAsync(e.getKey(), e.getValue()) : (unixTime ? acm.replaceAsync((Object)((byte[])e.getKey()), e.getValue(), e.getValue(), Util.fromUnixTime(expiration, handler.respServer().getTimeService()), TimeUnit.MILLISECONDS) : acm.replaceAsync((Object)((byte[])e.getKey()), e.getValue(), e.getValue(), expiration, TimeUnit.MILLISECONDS));
            return replace.thenCompose(b -> {
                if (b.booleanValue()) {
                    return APPLIED;
                }
                return EXPIRE.expire(handler, key, expiration, mode, unixTime);
            });
        });
    }

    private static boolean isInThePast(long expiration, TimeService timeService) {
        return expiration <= timeService.wallClockTime();
    }

    static enum Mode {
        NONE,
        NX,
        XX,
        GT,
        LT;

    }
}

