/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.set;

import io.netty.channel.ChannelHandlerContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.multimap.impl.EmbeddedSetCache;
import org.infinispan.multimap.impl.SetBucket;
import org.infinispan.server.resp.Consumers;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.commands.set.SINTER;

public class SDIFF
extends RespCommand
implements Resp3Command {
    public SDIFF() {
        super(-2, 1, -1, 1);
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        EmbeddedSetCache<byte[], byte[]> esc = handler.getEmbeddedSetCache();
        boolean diffItself = arguments.stream().skip(1L).anyMatch(item -> Objects.deepEquals(arguments.get(0), item));
        Set<byte[]> uniqueKeys = SINTER.getUniqueKeys(handler, arguments);
        CompletableFuture allEntries = esc.getAll(uniqueKeys);
        return handler.stageToReturn(allEntries.thenApply(entriesMap -> SDIFF.diff((byte[])arguments.get(0), entriesMap, diffItself)), ctx, Consumers.COLLECTION_BULK_BICONSUMER);
    }

    public static Collection<byte[]> diff(byte[] key, Map<byte[], SetBucket<byte[]>> buckets, boolean diffItself) {
        List minuend = Collections.emptyList();
        if (!diffItself) {
            byte[] kInMap = SDIFF.getKeyForMap(key, buckets);
            if (kInMap != null) {
                minuend = buckets.get(kInMap).toList();
            }
            buckets.remove(kInMap);
        }
        block0: for (SetBucket<byte[]> bucket : buckets.values()) {
            for (byte[] item : bucket.toList()) {
                if (minuend.isEmpty()) continue block0;
                minuend.removeIf(v -> Objects.deepEquals(v, item));
            }
        }
        return minuend;
    }

    static byte[] getKeyForMap(byte[] key, Map<byte[], SetBucket<byte[]>> buckets) {
        if (buckets.isEmpty()) {
            return null;
        }
        return buckets.keySet().stream().filter(item -> Arrays.equals(item, key)).findFirst().orElse(null);
    }
}

