/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.query.Indexer;
import org.infinispan.query.Search;
import org.infinispan.query.core.stats.SearchStatistics;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.impl.InfinispanQueryStatisticsInfo;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.resources.ResourceUtil;
import org.infinispan.rest.resources.SecurityActions;
import org.infinispan.search.mapper.mapping.SearchMapping;
import org.infinispan.security.Security;
import org.infinispan.util.logging.LogFactory;

public class SearchAdminResource
implements ResourceHandler {
    private static final Log LOG = (Log)LogFactory.getLog(SearchAdminResource.class, Log.class);
    private final InvocationHelper invocationHelper;

    public SearchAdminResource(InvocationHelper invocationHelper) {
        this.invocationHelper = invocationHelper;
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.POST).path("/v2/caches/{cacheName}/search/indexes").deprecated().withAction("mass-index").handleWith(this::reindex).invocation().methods(Method.POST).path("/v2/caches/{cacheName}/search/indexes").withAction("reindex").handleWith(this::reindex).invocation().methods(Method.POST).path("/v2/caches/{cacheName}/search/indexes").withAction("updateSchema").handleWith(this::updateSchema).invocation().methods(Method.POST).path("/v2/caches/{cacheName}/search/indexes").withAction("clear").handleWith(this::clearIndexes).invocation().methods(Method.GET).path("/v2/caches/{cacheName}/search/indexes/metamodel").handleWith(this::indexMetamodel).invocation().methods(Method.GET).path("/v2/caches/{cacheName}/search/indexes/stats").deprecated().handleWith(this::indexStats).invocation().methods(Method.GET).path("/v2/caches/{cacheName}/search/query/stats").deprecated().handleWith(this::queryStats).invocation().methods(Method.POST).path("/v2/caches/{cacheName}/search/query/stats").deprecated().withAction("clear").handleWith(this::clearStats).invocation().methods(Method.GET).path("/v2/caches/{cacheName}/search/stats").handleWith(this::searchStats).invocation().methods(Method.POST).path("/v2/caches/{cacheName}/search/stats").withAction("clear").handleWith(this::clearSearchStats).create();
    }

    private CompletionStage<RestResponse> searchStats(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        if (cache == null) {
            responseBuilder.status(HttpResponseStatus.NOT_FOUND);
            return null;
        }
        Configuration cacheConfiguration = SecurityActions.getCacheConfiguration(cache);
        if (!cacheConfiguration.statistics().enabled()) {
            responseBuilder.status(HttpResponseStatus.NOT_FOUND).build();
        }
        String scopeParam = request.getParameter("scope");
        boolean pretty = ResourceUtil.isPretty(request);
        if (scopeParam != null && scopeParam.equalsIgnoreCase("cluster")) {
            CompletionStage stats = Search.getClusteredSearchStatistics(cache);
            return stats.thenApply(s -> ResourceUtil.asJsonResponse(this.invocationHelper.newResponse(request), s.toJson(), pretty));
        }
        return Search.getSearchStatistics(cache).computeSnapshot().thenApply(s -> ResourceUtil.asJsonResponse(this.invocationHelper.newResponse(request), s.toJson(), pretty));
    }

    private CompletionStage<RestResponse> clearSearchStats(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        if (cache == null) {
            responseBuilder.status(HttpResponseStatus.NOT_FOUND);
            return null;
        }
        Configuration cacheConfiguration = cache.getCacheConfiguration();
        if (!cacheConfiguration.statistics().enabled()) {
            return CompletableFuture.completedFuture(responseBuilder.status(HttpResponseStatus.NOT_FOUND.code()).build());
        }
        String scopeParam = request.getParameter("scope");
        if (scopeParam != null && scopeParam.equalsIgnoreCase("cluster")) {
            throw new CacheException("NotImplemented");
        }
        SearchStatistics searchStatistics = Search.getSearchStatistics(cache);
        Security.doAs((Subject)request.getSubject(), () -> searchStatistics.getQueryStatistics().clear());
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletionStage<RestResponse> reindex(RestRequest request) {
        boolean local = Boolean.parseBoolean(request.getParameter("local"));
        return this.runIndexer(request, s -> local ? s.runLocal() : s.run(), true);
    }

    private CompletionStage<RestResponse> clearIndexes(RestRequest request) {
        return this.runIndexer(request, Indexer::remove, false);
    }

    private CompletionStage<RestResponse> updateSchema(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        AdvancedCache<?, ?> cache = this.lookupIndexedCache(request, responseBuilder);
        int status = responseBuilder.getStatus();
        if (status < HttpResponseStatus.OK.code() || status >= HttpResponseStatus.MULTIPLE_CHOICES.code()) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        responseBuilder.status(HttpResponseStatus.NO_CONTENT);
        try {
            SearchMapping searchMapping = ComponentRegistryUtils.getSearchMapping(cache);
            searchMapping.restart();
        }
        catch (Exception e) {
            throw Util.unchecked((Throwable)e);
        }
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletionStage<RestResponse> indexMetamodel(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        AdvancedCache<?, ?> cache = this.lookupIndexedCache(request, responseBuilder);
        int status = responseBuilder.getStatus();
        if (status < HttpResponseStatus.OK.code() || status >= HttpResponseStatus.MULTIPLE_CHOICES.code()) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        SearchMapping searchMapping = ComponentRegistryUtils.getSearchMapping(cache);
        Json metamodel = Json.make(searchMapping.metamodel().values());
        return ResourceUtil.asJsonResponseFuture(responseBuilder, metamodel, ResourceUtil.isPretty(request));
    }

    private CompletionStage<RestResponse> indexStats(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        boolean pretty = ResourceUtil.isPretty(request);
        InfinispanQueryStatisticsInfo searchStats = this.lookupQueryStatistics(request, responseBuilder);
        if (searchStats == null) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        return searchStats.computeLegacyIndexStatistics().thenApply(json -> ResourceUtil.asJsonResponse(responseBuilder, json, pretty));
    }

    private CompletionStage<RestResponse> queryStats(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        InfinispanQueryStatisticsInfo searchStats = this.lookupQueryStatistics(request, responseBuilder);
        if (searchStats == null) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), searchStats.getLegacyQueryStatistics(), ResourceUtil.isPretty(request));
    }

    private CompletionStage<RestResponse> clearStats(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        InfinispanQueryStatisticsInfo queryStatistics = this.lookupQueryStatistics(request, responseBuilder);
        if (queryStatistics == null) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        responseBuilder.status(HttpResponseStatus.NO_CONTENT);
        queryStatistics.clear();
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletionStage<RestResponse> runIndexer(RestRequest request, Function<Indexer, CompletionStage<Void>> op, boolean supportAsync) {
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        List<String> mode = request.parameters().get("mode");
        boolean asyncParams = mode != null && !mode.isEmpty() && mode.iterator().next().equalsIgnoreCase("async");
        boolean async = asyncParams && supportAsync;
        AdvancedCache<?, ?> cache = this.lookupIndexedCache(request, responseBuilder);
        int status = responseBuilder.getStatus();
        if (status < HttpResponseStatus.OK.code() || status >= HttpResponseStatus.MULTIPLE_CHOICES.code()) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        responseBuilder.status(HttpResponseStatus.NO_CONTENT);
        Indexer indexer = ComponentRegistryUtils.getIndexer(cache);
        if (async) {
            try {
                LOG.asyncMassIndexerStarted();
                op.apply(indexer).whenComplete((v, e) -> {
                    if (e == null) {
                        LOG.asyncMassIndexerSuccess();
                    } else {
                        LOG.errorExecutingMassIndexer(e.getCause());
                    }
                });
            }
            catch (Exception e2) {
                Util.unchecked((Throwable)e2);
            }
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        return op.apply(indexer).thenApply(v -> responseBuilder.build());
    }

    private AdvancedCache<?, ?> lookupIndexedCache(RestRequest request, NettyRestResponse.Builder builder) {
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        if (cache == null) {
            builder.status(HttpResponseStatus.NOT_FOUND);
            return null;
        }
        Configuration cacheConfiguration = SecurityActions.getCacheConfiguration(cache);
        if (!cacheConfiguration.indexing().enabled()) {
            throw Log.REST.cacheNotIndexed(cacheName);
        }
        return cache;
    }

    private AdvancedCache<?, ?> lookupCacheWithStats(RestRequest request, NettyRestResponse.Builder builder) {
        Configuration cacheConfiguration;
        AdvancedCache<?, ?> cache = this.lookupIndexedCache(request, builder);
        if (cache != null && !(cacheConfiguration = SecurityActions.getCacheConfiguration(cache)).statistics().enabled()) {
            throw Log.REST.statisticsNotEnabled(cache.getName());
        }
        return cache;
    }

    private InfinispanQueryStatisticsInfo lookupQueryStatistics(RestRequest request, NettyRestResponse.Builder builder) {
        AdvancedCache<?, ?> cache = this.lookupCacheWithStats(request, builder);
        if (builder.getStatus() != HttpResponseStatus.OK.code()) {
            return null;
        }
        return ComponentRegistryUtils.getQueryStatistics(cache);
    }
}

